#include "stdafx.h"
#include "PythonCOM.h"

PyIBase::PyIBase()
{
	_Py_NewReference(this);
}
PyIBase::~PyIBase()
{
}

/*static*/BOOL PyIBase::is_object(const PyObject *ob, PyComTypeObject *which)
{
	// First check that the type names is known in my map.
	// If not, then it cant be my type...
	extern PyObject *g_obPyCom_MapNameToType; // map of Names to types.
	PyObject *obCheck = PyDict_GetItemString(g_obPyCom_MapNameToType,ob->ob_type->tp_name);
	if (obCheck==NULL) {
		PyErr_Clear();
		return FALSE;
	}
	// now check for inheritance.
	PyComTypeObject *thisType = (PyComTypeObject *)ob->ob_type;
	while (thisType) {
		if (which==thisType)
			return TRUE;
		thisType = thisType->baseType;
	}
	return FALSE;
}
BOOL PyIBase::is_object(PyComTypeObject *which)
{
	return is_object(this,which);
}

/*static*/PyObject *
PyIBase::getattr(PyObject *self, char *name)
{
	return ((PyIBase *)self)->getattr(name);
}

PyObject *
PyIBase::getattr(char *name)
{
	// implement inheritance.
	PyObject *retMethod = NULL;
	PyComTypeObject *thisType = (PyComTypeObject *)ob_type;
	while (thisType) {
		retMethod = Py_FindMethod(thisType->methods, (PyObject *)this, name);
		if (retMethod)
			break;
		thisType = thisType->baseType;
		if (thisType)
			PyErr_Clear();
	}
	return retMethod;
}
/*static*/int PyIBase::setattr(PyObject *op, char *name, PyObject *v)
{
	PyIBase* bc = (PyIBase *)op;
	return bc->setattr(name,v);
}
int PyIBase::setattr(char *name, PyObject *v)
{
	char buf[128];
	sprintf(buf, "%s has read-only attributes", ob_type->tp_name );
	PyErr_SetString(PyExc_TypeError, buf);
	return -1;
}
/*static*/ PyObject *
PyIBase::repr( PyObject *ob )
{
	return ((PyIBase *)ob)->repr();
}
PyObject * PyIBase::repr()
{
	char buf[80];
	wsprintf(buf, "<%s at %p>",ob_type->tp_name, (PyObject *)this);
	return PyString_FromString(buf);
}
/*static*/ void PyIBase::dealloc(PyObject *ob)
{
	delete (PyIBase *)ob;
}
