#
# Initialization for the win32com package
#

#
# Gross hack that should go some time soon.  There are serious flaws in
# early versions of winerror....  Check this, and warn all about it...
# The correct version was released with Pythonwin 1.0 and later.
try:
	import winerror
	winerror.win16_E_NOTIMPL
except ImportError:
	print "Warning: win32com cant import winerror to check its version.  COM is unlikely to work without this module!"
except AttributeError:
	print "Warning: There is an old winerror installed.  Please install a new version."
	print "win32com is unlikely to work correctly."
try:
	del winerror # Clean the namespace.
except:
	pass


# Add support for an external "COM Extensions" path.
#  Concept is that you can register a seperate path to be used for
#  COM extensions, outside of the win32com directory.  These modules, however,
#  look identical to win32com built-in modules.
#  This is the technique that we use for the "standard" COM extensions.
#  eg "win32com.mapi" or "win32com.axscript" both work, even though they do not
#  live under the main win32com directory.

### TODO - Load _all_ \\Extensions subkeys - for now, we only read the default
### Modules will work if loaded into "win32comext" path.

def SetupEnvironment():
	import win32api, sys
	HKEY_LOCAL_MACHINE = 0x80000002 # Avoid pulling in win32con for just this...
	key = "SOFTWARE\\Python\\PythonCore\\%s\\PythonPath\\win32com\\Extensions" % sys.winver
	try:
		__.__path__.append( win32api.RegQueryValue(HKEY_LOCAL_MACHINE, key) )
	except win32api.error:
		# Nothing registered - try default
		try:
			__.__path__.append( win32api.GetFullPathName( __.__path__[0] + "\\..\\win32comext") )
		except win32api.error:
			# Give up in disgust!
			pass

	# For the sake of developers, we also look up a "__build_path__" key
	# If extension modules add support, we can load their .pyd's from a completely
	# different directory (see the comments below)
	key = "SOFTWARE\\Python\\PythonCore\\%s\\PythonPath\\win32com\\BuildPath" % sys.winver
	try:
		__.__build_path__ = win32api.RegQueryValue(HKEY_LOCAL_MACHINE, key)
	except win32api.error:
		pass

# A Helper for developers.  A sub-package's __init__ can call this help function,
# which allows the .pyd files for the extension to live in a special "Build" directory
# (which the win32com developers do!)
def __PackageSupportBuildPath__(package):
	# See if we have a special directory for the binaries (for developers)
	try:
		if package.__path__: package.__path__.append(__.__build_path__)
	except AttributeError:
		pass

# This seems to be called twice - once with __path__ = None, and then
# again with a list.  Not sure this is "normal"...
if __.__path__:
	SetupEnvironment()
	# Inject the helper into the main win32com namespace.
	__.__PackageSupportBuildPath__ = __PackageSupportBuildPath__
	del __PackageSupportBuildPath__

#
# Ensure core support loaded for extensions etc. by importing pythoncom.
# We must get funny about it because it's standard location is not found
# by the "ni" package.  (This is because Pythoncom.dll _must_ live
# in the Windows System directory for various reasons!)
# (Another alternative is to ensure "regni" is imported first!)

import ihooks
loader = ihooks.BasicModuleLoader()
modinfo = loader.find_module('pythoncom')
if modinfo is None: 
	raise ImportError, "The PythonCOM extension module can not be located"
__.pythoncom = loader.load_module('pythoncom', modinfo)

import sys
sys.modules['win32com.pythoncom'] = __.pythoncom

# get rid of these for module users
del ihooks, loader, sys, modinfo

