# Test makepy - try and run it over every OCX in the windows system directory.

import sys
import win32api
import traceback
import glob
import os
import string

import ni
import win32com.test.util
from win32com.client import makepy
import win32com.pythoncom

def TestBuildTLB(filename, verbose = 1):
	capture = win32com.test.util.CaptureWriter()
	capture.capture()
	try:
		if verbose: sys.stderr.write("Testing %s - " % filename)
		try:
			t = win32com.pythoncom.LoadTypeLib(filename)
		except win32com.pythoncom.com_error:
			if not verbose: sys.stderr.write("Makepy for %s failed\n" % filename )
			sys.stderr.write("Unable to open OCX for type information\n")
			return
		try:
			makepy.MakeClassesFromTypeLib(t, 1, 0)
		except KeyboardInterrupt:
			raise KeyboardInterrupt
		except:
			if not verbose: sys.stderr.write("Makepy for %s failed\n" % filename )
			sys.stderr.write("\n*** Generation of code failed")
			capture.release()
			traceback.print_exc()
			return 
		if verbose: sys.stderr.write("testing generated code - ")
		try:
			co = compile (capture.get_captured(), "<makepy test>", "exec")
			dict = {}
			exec co in dict, dict
		except KeyboardInterrupt:
			raise KeyboardInterrupt
		except:
			sys.stderr.write("\n*** Compilation of generated code failed")
			capture.release()
			traceback.print_exc()
			return
		if verbose: sys.stderr.write("ok\n")
	finally:
		capture.release()


def TestAllSystemOCX(verbose=1):
	fileSpec = os.path.join(win32api.GetSystemDirectory(),"*.ocx")
	files = glob.glob(fileSpec)
	if not verbose: sys.stderr.write("Testing makepy.py over %d OCX files.  Please wait...\n" % len(files))
	for filename in files:
		TestBuildTLB(filename,verbose)

def TestAllSystemTLB(verbose=1):
	fileSpec = os.path.join(win32api.GetSystemDirectory(),"*.tlb")
	files = glob.glob(fileSpec)
	if not verbose: sys.stderr.write("Testing makepy.py over %d TLB files.  Please wait...\n" % len(files))
	for filename in files:
		TestBuildTLB(filename,verbose)

def TestAll(verbose = 1):
	TestAllSystemTLB(verbose)
	TestAllSystemOCX(verbose)
	win32com.test.util.CheckClean()
	
if __name__=='__main__':
	TestAll()
