#
# This assumes that you have MSAccess and DAO installed.
#  You need to run makepy.py over "msaccess.tlb" and
#  "dao3032.dll", and ensure the generated files are on the
#  path.

def DumpAccessInfo(dbname):
	import ni, win32com.client, win32com.pythoncom, sys
	try:
		import dao3032
		try:
			import msacc8
		except ImportError:
			import msaccess
	except ImportError:
		print "***** The MSAccess tests could not be run - the required modules arent available"
		print "      Please run makepy.py over msaccess.tlb and dao3032.dll"
		return
	import daodump
	a = forms = None
	try:
		sys.stderr.write("Creating Access Application...\n")
		a=win32com.client.Dispatch("Access.Application")
		print "Opening database %s" % dbname
		a.OpenCurrentDatabase(dbname)
		db = a.CurrentDb()
		print "db is", db
		daodump.DumpDB(db,1)
		forms = a.Forms
		print "There are %d forms open." % (len(forms))
# Uncommenting these lines means Access remains open.
#		for form in forms:
#			print " %s" % form.Name
		reports = a.Reports
		print "There are %d reports open" % (len(reports))
	finally:
		if not a is None: 
			sys.stderr.write("Closing database\n")
			a.CloseCurrentDatabase()

def LoadGenSupport():
	have = 0
	try:
		import dao3032
		have = 1
	except ImportError:
		pass
	try:
		import dao350
		have = 1
	except ImportError:
		pass
	if not have:
		print "WARNING: Could not import DAO generated support.  Test will be slow!"
		

if __name__=='__main__':
	import ni, sys
	from util import CheckClean
	LoadGenSupport()
	DumpAccessInfo('d:\\msoffice\\access\\samples\\NorthWind.mdb')
	CheckClean()

