"""Python.Interpreter COM Server
  
  This module implements a very very simple COM server which
  exposes the Python interpreter.

  This is designed more as a demonstration than a full blown COM server.
  General functionality and Error handling are both limited.

  To use this object, ensure it is registered by running this module
  from Python.exe.  Then, from Visual Basic, use "CreateObject('Python.Interpreter')",
  and call its methods!
"""

import ni
from win32com.server.exception import Exception
from pywintypes import UnicodeType
import winerror

# Expose the Python interpreter.
class Interpreter:
	"""The interpreter object exposed via COM
	"""
	_public_methods_ = [ 'Exec', 'Eval' ]
	def Eval(self, exp):
		"""Evaluate an expression.
		"""
		if type(exp) not in [type(''),UnicodeType]:
			raise Exception(desc="Must be a string",scode=winerror.DISP_E_TYPEMISMATCH)
				
		return eval(str(exp))
	def Exec(self, exp):
		"""Execute a statement.
		"""
		if type(exp) not in [type(''), UnicodeType]:
			raise Exception(desc="Must be a string",scode=winerror.DISP_E_TYPEMISMATCH)
		exec str(exp)

if __name__=='__main__':
	print "Registering COM server..."
	from win32com.server.register import RegisterServer
	import sys

	dispatcher = None
	if len(sys.argv)>1 and sys.argv[1]=="-d":
		print "Registering debug server..."
		dispatcher = "DispatcherWin32trace"

	RegisterServer("{30BD3490-2632-11cf-AD5B-524153480001}",
                       "win32com.servers.interp.Interpreter",
                       "Python Interpreter",
                       "Python.Interpreter",
                       "Python.Interpreter.2",
                       dispatcher = dispatcher)
	print "Class registered."
