// PyCOMTest.h : Declaration of the CPyCOMTest


#include "connres.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CPyCOMTest

const int nMaxSessions = 10;

template <class T, class I, const IID *piid>
class CPyCOMTestImpl :
	public CComObjectRoot,
	public IDispatchImpl<I, piid, &LIBID_PyCOMTestLib>, 
	public IConnectionPointContainerImpl<T>
{
public:
	CPyCOMTestImpl() :
	  pLastArray(NULL) {;}
	~CPyCOMTestImpl();

	STDMETHOD(Start)(long* pnID);
	STDMETHOD(Stop)(long nID);
	STDMETHOD(StopAll)();
	STDMETHOD(Test)(VARIANT, QsBoolean, QsBoolean *);
	STDMETHOD(Test2)(QsAttribute, QsAttribute *);
	STDMETHOD(GetSetInterface)(IPyCOMTest *ininterface, IPyCOMTest **outinterface);
	STDMETHOD(GetMultipleInterfaces)(IPyCOMTest **outinterface1, IPyCOMTest **outinterface2);
	STDMETHOD(GetSetDispatch)(IDispatch *indisp, IDispatch **outdisp);
	STDMETHOD(GetSetUnknown)(IUnknown *inunk, IUnknown **outunk);
	STDMETHOD(SetIntSafeArray)(SAFEARRAY* ints, int *retSize);
	STDMETHOD(SetVariantSafeArray)(SAFEARRAY* vars, int *retSize);
	STDMETHOD(GetSafeArrays)(SAFEARRAY** attrs,
                                      SAFEARRAY**attrs2,
                                      SAFEARRAY** ints);
	STDMETHOD(GetSimpleSafeArray)(SAFEARRAY** ints);
	STDMETHOD(GetSimpleCounter)(ISimpleCounter** counter);

	STDMETHOD(SetVarArgs)(SAFEARRAY *);
	STDMETHOD(GetLastVarArgs)(SAFEARRAY **);

	// method to broadcast a call on the current connections
	HRESULT Fire(long  nID);
protected:
	SAFEARRAY *pLastArray;
};

class CPyCOMTest : 
	public CPyCOMTestImpl<CPyCOMTest, IPyCOMTest, &IID_IPyCOMTest>,
//	public CComDualImpl<IPyCOMTest, &IID_IPyCOMTest, &LIBID_PyCOMTestLib>, 
	public ISupportErrorInfo,
	public IConnectionPointImpl<CPyCOMTest, &IID_IPyCOMTestEvent, CComDynamicUnkArray>,
	public CComCoClass<CPyCOMTest,&CLSID_CoPyCOMTest>
{
public:
	CPyCOMTest()
	{
		memset(m_rsArray, 0, nMaxSessions*sizeof(PyCOMTestSessionData));
	}
	~CPyCOMTest();

BEGIN_COM_MAP(CPyCOMTest)
	COM_INTERFACE_ENTRY2(IDispatch, IPyCOMTest)
	COM_INTERFACE_ENTRY(IPyCOMTest)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()
//	DECLARE_NOT_AGGREGATABLE(CPyCOMTest) 
// Remove the comment from the line above if you don't want your object to 
// support aggregation.  The default is to support it

	DECLARE_REGISTRY_RESOURCEID(IDR_PYCOMTEST)

// Connection Point
	BEGIN_CONNECTION_POINT_MAP(CPyCOMTest)
		CONNECTION_POINT_ENTRY(IID_IPyCOMTestEvent)
	END_CONNECTION_POINT_MAP()
	
// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IPyCOMTest
	// info associated to each session
	struct PyCOMTestSessionData
	{
		CPyCOMTest* pPyCOMTest;
		HANDLE m_hEvent;
		HANDLE m_hThread;
		int m_nID;
	};
protected:
	PyCOMTestSessionData m_rsArray[nMaxSessions];
	void CreatePyCOMTestSession(PyCOMTestSessionData& rs);

	_ThreadModel::AutoCriticalSection m_cs;
};

class CPyCOMTest2 : public CPyCOMTest
{
	STDMETHOD(TestDerived)(QsAttribute, QsAttribute *);
};

