/*
 * FILE : win32servicemodule.cpp
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 -3
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initwin32service

#define SWIG_name    "win32service"

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                            
        if (!PyTuple_Check(target)) {   
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#include "windows.h"
#include "winbase.h"
#include "PyWinTypes.h"
#include "tchar.h"
typedef BOOL  BOOLAPI;

typedef HANDLE INT_HANDLE;


PyObject *MyCreateService(
    SC_HANDLE hSCManager,	// handle to service control manager database  
    TCHAR *lpServiceName,	// pointer to name of service to start 
    TCHAR *lpDisplayName,	// pointer to display name 
    DWORD dwDesiredAccess,	// type of access to service 
    DWORD dwServiceType,	// type of service 
    DWORD dwStartType,		// when to start service 
    DWORD dwErrorControl,	// severity if service fails to start 
    TCHAR * lpBinaryPathName,	// pointer to name of binary file 
    TCHAR * lpLoadOrderGroup,	// pointer to name of load ordering group 
    BOOL  bFetchTag,
    PyObject *obDeps,		// array of dependency names 
    TCHAR *lpServiceStartName,	// pointer to account name of service 
    TCHAR *lpPassword 	// pointer to password for service account 
   )
{
	PyObject *rc = NULL;
	TCHAR *lpDeps = NULL;
	DWORD tagID;
	DWORD *pTagID = bFetchTag ? &tagID : NULL;
	SC_HANDLE sh = 0;
	if (obDeps!=Py_None) {
		if (!PySequence_Check(obDeps)) {
			PyErr_SetString(PyExc_ValueError, "Dependencies must be None or a list of strings");
			goto cleanup;
		}
 		int numStrings = PySequence_Length(obDeps);
		// Need to loop twice - once to get the buffer length
		int len = 0;
		for (int i=0;i<numStrings;i++) {
			PyObject *obString = PySequence_GetItem(obDeps, i);
			if (obString==NULL)
				goto cleanup;
			if (!PyString_Check(obString)) {
				Py_DECREF(obString);
				PyErr_SetString(PyExc_ValueError, "The list items for Dependencies must all be strings");
				goto cleanup;
			}
			len += PyString_Size(obString) + 1;
			Py_DECREF(obString);
		}
		// Allocate the buffer
		lpDeps = new TCHAR[len+2]; // Double '\0' terminated
		TCHAR *p = lpDeps;
		for (i=0;i<numStrings;i++) {
			// We know the sequence is valid.
			PyObject *obString = PySequence_GetItem(obDeps, i);
			BSTR pStr;
			if (!PyWinObject_AsBstr(obString, &pStr)) {
				Py_DECREF(obString);
				goto cleanup;
			}
			int len = SysStringLen(pStr);
			_tcsncpy(p, pStr, len);
			p += len;
			*p++ = L'\0';
			SysFreeString(pStr);
			Py_DECREF(obString);
		}
		*p = L'\0'; // Add second terminator.
	}
	sh = CreateService(hSCManager,lpServiceName,lpDisplayName,dwDesiredAccess,
	                             dwServiceType, dwStartType, dwErrorControl, lpBinaryPathName,
	                             lpLoadOrderGroup, pTagID, lpDeps, lpServiceStartName, lpPassword);
	if (sh==0) {
		PyWin_SetAPIError("CreateService");
		rc = NULL;
	} else {
		if (bFetchTag)
			rc = Py_BuildValue("ll", sh, tagID);
		else
			rc = PyInt_FromLong((long)sh);
	}
cleanup:
	delete [] lpDeps;
	if (rc==NULL) {
		// HACK HACK HACK - I know that the strings are not freed by SWIG
		// if the function fails.
//		SysFreeString(lpServiceName);
//		SysFreeString(lpDisplayName);
//		SysFreeString(lpBinaryPathName);
//		SysFreeString(lpLoadOrderGroup);
//		SysFreeString(lpServiceStartName);
//		SysFreeString(lpPassword);
	}
	return rc;
		
}

PyObject *MyStartService( SC_HANDLE scHandle, PyObject *serviceArgs )
{
	LPTSTR *pArgs;
	DWORD numStrings = 0;
	if (serviceArgs==Py_None)
		pArgs = NULL;
	else if (!PySequence_Check(serviceArgs)) {
		PyErr_SetString(PyExc_ValueError, "Service arguments must be list of strings.");
		return NULL;
	} else {
		numStrings = PySequence_Length(serviceArgs);
		pArgs = new LPTSTR [numStrings];
		if (pArgs==NULL) {
			PyErr_SetString(PyExc_MemoryError, "Allocating argument arrays");
			return NULL;
		}
		for (DWORD i=0;i<numStrings;i++) {
			PyObject *obString = PySequence_GetItem(serviceArgs, (int)i);
			if (obString==NULL) {
				delete [] pArgs;
				return NULL;
			}
			pArgs[i] = NULL;
			PyWinObject_AsBstr(obString, pArgs+i);
			Py_DECREF(obString);
		}
	}
	PyObject *rc;
	if (StartService(scHandle, numStrings, (LPCTSTR *)pArgs)) {
		rc = Py_None;
		Py_INCREF(Py_None);
	} else
		rc = PyWin_SetAPIError("StartService");
	for (DWORD i=0;i<numStrings;i++)
		SysFreeString(pArgs[i]);
	delete [] pArgs;
	return rc;
}
static PyObject *_wrap_python_const_SERVICE_CONTROL_STOP;
static PyObject *_wrap_python_const_SERVICE_CONTROL_PAUSE;
static PyObject *_wrap_python_const_SERVICE_CONTROL_CONTINUE;
static PyObject *_wrap_python_const_SERVICE_CONTROL_INTERROGATE;
static PyObject *_wrap_python_const_SERVICE_CONTROL_SHUTDOWN;
static PyObject *_wrap_python_const_SC_MANAGER_ALL_ACCESS;
static PyObject *_wrap_python_const_SC_MANAGER_CONNECT;
static PyObject *_wrap_python_const_SC_MANAGER_CREATE_SERVICE;
static PyObject *_wrap_python_const_SC_MANAGER_ENUMERATE_SERVICE;
static PyObject *_wrap_python_const_SC_MANAGER_LOCK;
static PyObject *_wrap_python_const_SC_MANAGER_QUERY_LOCK_STATUS;
static PyObject *_wrap_python_const_SC_MANAGER_MODIFY_BOOT_CONFIG;
static PyObject *_wrap_python_const_SC_GROUP_IDENTIFIER;
static PyObject *_wrap_python_const_SERVICE_WIN32_OWN_PROCESS;
static PyObject *_wrap_python_const_SERVICE_WIN32_SHARE_PROCESS;
static PyObject *_wrap_python_const_SERVICE_KERNEL_DRIVER;
static PyObject *_wrap_python_const_SERVICE_FILE_SYSTEM_DRIVER;
static PyObject *_wrap_python_const_SERVICE_INTERACTIVE_PROCESS;
static PyObject *_wrap_python_const_SERVICE_STOPPED;
static PyObject *_wrap_python_const_SERVICE_START_PENDING;
static PyObject *_wrap_python_const_SERVICE_STOP_PENDING;
static PyObject *_wrap_python_const_SERVICE_RUNNING;
static PyObject *_wrap_python_const_SERVICE_CONTINUE_PENDING;
static PyObject *_wrap_python_const_SERVICE_PAUSE_PENDING;
static PyObject *_wrap_python_const_SERVICE_PAUSED;
static PyObject *_wrap_python_const_SERVICE_ACCEPT_STOP;
static PyObject *_wrap_python_const_SERVICE_ACCEPT_PAUSE_CONTINUE;
static PyObject *_wrap_python_const_SERVICE_ACCEPT_SHUTDOWN;
static PyObject *_wrap_python_const_SERVICE_BOOT_START;
static PyObject *_wrap_python_const_SERVICE_SYSTEM_START;
static PyObject *_wrap_python_const_SERVICE_AUTO_START;
static PyObject *_wrap_python_const_SERVICE_DEMAND_START;
static PyObject *_wrap_python_const_SERVICE_DISABLED;
static PyObject *_wrap_python_const_SERVICE_ERROR_IGNORE;
static PyObject *_wrap_python_const_SERVICE_ERROR_NORMAL;
static PyObject *_wrap_python_const_SERVICE_ERROR_SEVERE;
static PyObject *_wrap_python_const_SERVICE_ERROR_CRITICAL;
static PyObject *_wrap_python_const_SERVICE_ALL_ACCESS;
static PyObject *_wrap_python_const_SERVICE_CHANGE_CONFIG;
static PyObject *_wrap_python_const_SERVICE_ENUMERATE_DEPENDENTS;
static PyObject *_wrap_python_const_SERVICE_INTERROGATE;
static PyObject *_wrap_python_const_SERVICE_PAUSE_CONTINUE;
static PyObject *_wrap_python_const_SERVICE_QUERY_CONFIG;
static PyObject *_wrap_python_const_SERVICE_QUERY_STATUS;
static PyObject *_wrap_python_const_SERVICE_START;
static PyObject *_wrap_python_const_SERVICE_STOP;
static PyObject *_wrap_python_const_SERVICE_USER_DEFINED_CONTROL;
static PyObject *_wrap_StartService(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    SC_HANDLE  _arg0;
    PyObject * _arg1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"lO:StartService",&_arg0,&_obj1)) 
        return NULL;
{
  _arg1 = _obj1;
}
    _result = (PyObject *)MyStartService(_arg0,_arg1);
{
	if (_result==NULL) return NULL; // get out now!
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_OpenService(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    SC_HANDLE  _result;
    SC_HANDLE  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    unsigned long  _arg2;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"lOl:OpenService",&_arg0,&_obj1,&_arg2)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (SC_HANDLE )OpenService(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (_result==0)  {
           ;
           return PyWin_SetAPIError("OpenService");
      }
}    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_OpenSCManager(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    SC_HANDLE  _result;
    PyWin_AutoFreeBstr  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    unsigned long  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOl:OpenSCManager",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj0, &_arg0, TRUE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, TRUE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (SC_HANDLE )OpenSCManager(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (_result==0)  {
           ;
           return PyWin_SetAPIError("OpenSCManager");
      }
}    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_CloseServiceHandle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    SC_HANDLE  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:CloseServiceHandle",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )CloseServiceHandle(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("CloseServiceHandle");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_QueryServiceStatus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    SC_HANDLE  _arg0;
    SERVICE_STATUS * _arg1;
    SERVICE_STATUS  temp;

    self = self;
{
	_arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"l:QueryServiceStatus",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )QueryServiceStatus(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("QueryServiceStatus");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	Py_DECREF(_resultobj);
	_resultobj = Py_BuildValue("lllllll", 
		_arg1->dwServiceType,
		_arg1->dwCurrentState,
		_arg1->dwControlsAccepted,
		_arg1->dwWin32ExitCode,
		_arg1->dwServiceSpecificExitCode,
		_arg1->dwCheckPoint,
		_arg1->dwWaitHint);
}
    return _resultobj;
}

static PyObject *_wrap_SetServiceStatus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    SERVICE_STATUS_HANDLE  _arg0;
    SERVICE_STATUS * _arg1;
    SERVICE_STATUS  junk;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"lO:SetServiceStatus",&_arg0,&_obj1)) 
        return NULL;
{
	_arg1 = &junk;
	if (!PyArg_ParseTuple(_obj1, "lllllll", 
		&_arg1->dwServiceType,
		&_arg1->dwCurrentState,
		&_arg1->dwControlsAccepted,
		&_arg1->dwWin32ExitCode,
		&_arg1->dwServiceSpecificExitCode,
		&_arg1->dwCheckPoint,
		&_arg1->dwWaitHint))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )SetServiceStatus(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("SetServiceStatus");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_ControlService(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    SC_HANDLE  _arg0;
    DWORD  _arg1;
    SERVICE_STATUS * _arg2;
    SERVICE_STATUS  temp;

    self = self;
{
	_arg2 = &temp;
}
    if(!PyArg_ParseTuple(args,"ll:ControlService",&_arg0,&_arg1)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )ControlService(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("ControlService");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	Py_DECREF(_resultobj);
	_resultobj = Py_BuildValue("lllllll", 
		_arg2->dwServiceType,
		_arg2->dwCurrentState,
		_arg2->dwControlsAccepted,
		_arg2->dwWin32ExitCode,
		_arg2->dwServiceSpecificExitCode,
		_arg2->dwCheckPoint,
		_arg2->dwWaitHint);
}
    return _resultobj;
}

static PyObject *_wrap_DeleteService(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    SC_HANDLE  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:DeleteService",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )DeleteService(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("DeleteService");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_CreateService(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    SC_HANDLE  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    PyWin_AutoFreeBstr  _arg2;
    DWORD  _arg3;
    DWORD  _arg4;
    DWORD  _arg5;
    DWORD  _arg6;
    PyWin_AutoFreeBstr  _arg7;
    PyWin_AutoFreeBstr  _arg8;
    BOOL  _arg9;
    PyObject * _arg10;
    PyWin_AutoFreeBstr  _arg11;
    PyWin_AutoFreeBstr  _arg12;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj7 = 0;
    PyObject * _obj8 = 0;
    PyObject * _obj10 = 0;
    PyObject * _obj11 = 0;
    PyObject * _obj12 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"lOOllllOOiOOO:CreateService",&_arg0,&_obj1,&_obj2,&_arg3,&_arg4,&_arg5,&_arg6,&_obj7,&_obj8,&_arg9,&_obj10,&_obj11,&_obj12)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj2, &_arg2, FALSE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj7, &_arg7, FALSE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj8, &_arg8, TRUE))
		return NULL;
}
{
  _arg10 = _obj10;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj11, &_arg11, TRUE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj12, &_arg12, TRUE))
		return NULL;
}
    _result = (PyObject *)MyCreateService(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11,_arg12);
{
	if (_result==NULL) return NULL; // get out now!
	_resultobj = _result;
}
    return _resultobj;
}

static PyMethodDef win32serviceMethods[] = {
	 { "CreateService", _wrap_CreateService, 1 },
	 { "DeleteService", _wrap_DeleteService, 1 },
	 { "ControlService", _wrap_ControlService, 1 },
	 { "SetServiceStatus", _wrap_SetServiceStatus, 1 },
	 { "QueryServiceStatus", _wrap_QueryServiceStatus, 1 },
	 { "CloseServiceHandle", _wrap_CloseServiceHandle, 1 },
	 { "OpenSCManager", _wrap_OpenSCManager, 1 },
	 { "OpenService", _wrap_OpenService, 1 },
	 { "StartService", _wrap_StartService, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initwin32service)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("win32service", win32serviceMethods);
	 d = PyModule_GetDict(m);

#ifndef PYCOM_EXPORT
	 PyDict_SetItemString(d,"UNICODE", PyInt_FromLong(
#ifdef UNICODE
	1
#else
	0
#endif
	));
#endif

	// All errors raised by this module are of this type.
	Py_INCREF(PyWinExc_ApiError);
	PyDict_SetItemString(d, "error", PyWinExc_ApiError);
	 _wrap_python_const_SERVICE_CONTROL_STOP = PyInt_FromLong(SERVICE_CONTROL_STOP);
	 PyDict_SetItemString(d,"SERVICE_CONTROL_STOP", _wrap_python_const_SERVICE_CONTROL_STOP);
	 _wrap_python_const_SERVICE_CONTROL_PAUSE = PyInt_FromLong(SERVICE_CONTROL_PAUSE);
	 PyDict_SetItemString(d,"SERVICE_CONTROL_PAUSE", _wrap_python_const_SERVICE_CONTROL_PAUSE);
	 _wrap_python_const_SERVICE_CONTROL_CONTINUE = PyInt_FromLong(SERVICE_CONTROL_CONTINUE);
	 PyDict_SetItemString(d,"SERVICE_CONTROL_CONTINUE", _wrap_python_const_SERVICE_CONTROL_CONTINUE);
	 _wrap_python_const_SERVICE_CONTROL_INTERROGATE = PyInt_FromLong(SERVICE_CONTROL_INTERROGATE);
	 PyDict_SetItemString(d,"SERVICE_CONTROL_INTERROGATE", _wrap_python_const_SERVICE_CONTROL_INTERROGATE);
	 _wrap_python_const_SERVICE_CONTROL_SHUTDOWN = PyInt_FromLong(SERVICE_CONTROL_SHUTDOWN);
	 PyDict_SetItemString(d,"SERVICE_CONTROL_SHUTDOWN", _wrap_python_const_SERVICE_CONTROL_SHUTDOWN);
	 _wrap_python_const_SC_MANAGER_ALL_ACCESS = PyInt_FromLong(SC_MANAGER_ALL_ACCESS);
	 PyDict_SetItemString(d,"SC_MANAGER_ALL_ACCESS", _wrap_python_const_SC_MANAGER_ALL_ACCESS);
	 _wrap_python_const_SC_MANAGER_CONNECT = PyInt_FromLong(SC_MANAGER_CONNECT);
	 PyDict_SetItemString(d,"SC_MANAGER_CONNECT", _wrap_python_const_SC_MANAGER_CONNECT);
	 _wrap_python_const_SC_MANAGER_CREATE_SERVICE = PyInt_FromLong(SC_MANAGER_CREATE_SERVICE);
	 PyDict_SetItemString(d,"SC_MANAGER_CREATE_SERVICE", _wrap_python_const_SC_MANAGER_CREATE_SERVICE);
	 _wrap_python_const_SC_MANAGER_ENUMERATE_SERVICE = PyInt_FromLong(SC_MANAGER_ENUMERATE_SERVICE);
	 PyDict_SetItemString(d,"SC_MANAGER_ENUMERATE_SERVICE", _wrap_python_const_SC_MANAGER_ENUMERATE_SERVICE);
	 _wrap_python_const_SC_MANAGER_LOCK = PyInt_FromLong(SC_MANAGER_LOCK);
	 PyDict_SetItemString(d,"SC_MANAGER_LOCK", _wrap_python_const_SC_MANAGER_LOCK);
	 _wrap_python_const_SC_MANAGER_QUERY_LOCK_STATUS = PyInt_FromLong(SC_MANAGER_QUERY_LOCK_STATUS);
	 PyDict_SetItemString(d,"SC_MANAGER_QUERY_LOCK_STATUS", _wrap_python_const_SC_MANAGER_QUERY_LOCK_STATUS);
	 _wrap_python_const_SC_MANAGER_MODIFY_BOOT_CONFIG = PyInt_FromLong(SC_MANAGER_MODIFY_BOOT_CONFIG);
	 PyDict_SetItemString(d,"SC_MANAGER_MODIFY_BOOT_CONFIG", _wrap_python_const_SC_MANAGER_MODIFY_BOOT_CONFIG);
	 _wrap_python_const_SC_GROUP_IDENTIFIER = PyInt_FromLong(SC_GROUP_IDENTIFIER);
	 PyDict_SetItemString(d,"SC_GROUP_IDENTIFIER", _wrap_python_const_SC_GROUP_IDENTIFIER);
	 _wrap_python_const_SERVICE_WIN32_OWN_PROCESS = PyInt_FromLong(SERVICE_WIN32_OWN_PROCESS);
	 PyDict_SetItemString(d,"SERVICE_WIN32_OWN_PROCESS", _wrap_python_const_SERVICE_WIN32_OWN_PROCESS);
	 _wrap_python_const_SERVICE_WIN32_SHARE_PROCESS = PyInt_FromLong(SERVICE_WIN32_SHARE_PROCESS);
	 PyDict_SetItemString(d,"SERVICE_WIN32_SHARE_PROCESS", _wrap_python_const_SERVICE_WIN32_SHARE_PROCESS);
	 _wrap_python_const_SERVICE_KERNEL_DRIVER = PyInt_FromLong(SERVICE_KERNEL_DRIVER);
	 PyDict_SetItemString(d,"SERVICE_KERNEL_DRIVER", _wrap_python_const_SERVICE_KERNEL_DRIVER);
	 _wrap_python_const_SERVICE_FILE_SYSTEM_DRIVER = PyInt_FromLong(SERVICE_FILE_SYSTEM_DRIVER);
	 PyDict_SetItemString(d,"SERVICE_FILE_SYSTEM_DRIVER", _wrap_python_const_SERVICE_FILE_SYSTEM_DRIVER);
	 _wrap_python_const_SERVICE_INTERACTIVE_PROCESS = PyInt_FromLong(SERVICE_INTERACTIVE_PROCESS);
	 PyDict_SetItemString(d,"SERVICE_INTERACTIVE_PROCESS", _wrap_python_const_SERVICE_INTERACTIVE_PROCESS);
	 _wrap_python_const_SERVICE_STOPPED = PyInt_FromLong(SERVICE_STOPPED);
	 PyDict_SetItemString(d,"SERVICE_STOPPED", _wrap_python_const_SERVICE_STOPPED);
	 _wrap_python_const_SERVICE_START_PENDING = PyInt_FromLong(SERVICE_START_PENDING);
	 PyDict_SetItemString(d,"SERVICE_START_PENDING", _wrap_python_const_SERVICE_START_PENDING);
	 _wrap_python_const_SERVICE_STOP_PENDING = PyInt_FromLong(SERVICE_STOP_PENDING);
	 PyDict_SetItemString(d,"SERVICE_STOP_PENDING", _wrap_python_const_SERVICE_STOP_PENDING);
	 _wrap_python_const_SERVICE_RUNNING = PyInt_FromLong(SERVICE_RUNNING);
	 PyDict_SetItemString(d,"SERVICE_RUNNING", _wrap_python_const_SERVICE_RUNNING);
	 _wrap_python_const_SERVICE_CONTINUE_PENDING = PyInt_FromLong(SERVICE_CONTINUE_PENDING);
	 PyDict_SetItemString(d,"SERVICE_CONTINUE_PENDING", _wrap_python_const_SERVICE_CONTINUE_PENDING);
	 _wrap_python_const_SERVICE_PAUSE_PENDING = PyInt_FromLong(SERVICE_PAUSE_PENDING);
	 PyDict_SetItemString(d,"SERVICE_PAUSE_PENDING", _wrap_python_const_SERVICE_PAUSE_PENDING);
	 _wrap_python_const_SERVICE_PAUSED = PyInt_FromLong(SERVICE_PAUSED);
	 PyDict_SetItemString(d,"SERVICE_PAUSED", _wrap_python_const_SERVICE_PAUSED);
	 _wrap_python_const_SERVICE_ACCEPT_STOP = PyInt_FromLong(SERVICE_ACCEPT_STOP);
	 PyDict_SetItemString(d,"SERVICE_ACCEPT_STOP", _wrap_python_const_SERVICE_ACCEPT_STOP);
	 _wrap_python_const_SERVICE_ACCEPT_PAUSE_CONTINUE = PyInt_FromLong(SERVICE_ACCEPT_PAUSE_CONTINUE);
	 PyDict_SetItemString(d,"SERVICE_ACCEPT_PAUSE_CONTINUE", _wrap_python_const_SERVICE_ACCEPT_PAUSE_CONTINUE);
	 _wrap_python_const_SERVICE_ACCEPT_SHUTDOWN = PyInt_FromLong(SERVICE_ACCEPT_SHUTDOWN);
	 PyDict_SetItemString(d,"SERVICE_ACCEPT_SHUTDOWN", _wrap_python_const_SERVICE_ACCEPT_SHUTDOWN);
	 _wrap_python_const_SERVICE_BOOT_START = PyInt_FromLong(SERVICE_BOOT_START);
	 PyDict_SetItemString(d,"SERVICE_BOOT_START", _wrap_python_const_SERVICE_BOOT_START);
	 _wrap_python_const_SERVICE_SYSTEM_START = PyInt_FromLong(SERVICE_SYSTEM_START);
	 PyDict_SetItemString(d,"SERVICE_SYSTEM_START", _wrap_python_const_SERVICE_SYSTEM_START);
	 _wrap_python_const_SERVICE_AUTO_START = PyInt_FromLong(SERVICE_AUTO_START);
	 PyDict_SetItemString(d,"SERVICE_AUTO_START", _wrap_python_const_SERVICE_AUTO_START);
	 _wrap_python_const_SERVICE_DEMAND_START = PyInt_FromLong(SERVICE_DEMAND_START);
	 PyDict_SetItemString(d,"SERVICE_DEMAND_START", _wrap_python_const_SERVICE_DEMAND_START);
	 _wrap_python_const_SERVICE_DISABLED = PyInt_FromLong(SERVICE_DISABLED);
	 PyDict_SetItemString(d,"SERVICE_DISABLED", _wrap_python_const_SERVICE_DISABLED);
	 _wrap_python_const_SERVICE_ERROR_IGNORE = PyInt_FromLong(SERVICE_ERROR_IGNORE);
	 PyDict_SetItemString(d,"SERVICE_ERROR_IGNORE", _wrap_python_const_SERVICE_ERROR_IGNORE);
	 _wrap_python_const_SERVICE_ERROR_NORMAL = PyInt_FromLong(SERVICE_ERROR_NORMAL);
	 PyDict_SetItemString(d,"SERVICE_ERROR_NORMAL", _wrap_python_const_SERVICE_ERROR_NORMAL);
	 _wrap_python_const_SERVICE_ERROR_SEVERE = PyInt_FromLong(SERVICE_ERROR_SEVERE);
	 PyDict_SetItemString(d,"SERVICE_ERROR_SEVERE", _wrap_python_const_SERVICE_ERROR_SEVERE);
	 _wrap_python_const_SERVICE_ERROR_CRITICAL = PyInt_FromLong(SERVICE_ERROR_CRITICAL);
	 PyDict_SetItemString(d,"SERVICE_ERROR_CRITICAL", _wrap_python_const_SERVICE_ERROR_CRITICAL);
	 _wrap_python_const_SERVICE_ALL_ACCESS = PyInt_FromLong(SERVICE_ALL_ACCESS);
	 PyDict_SetItemString(d,"SERVICE_ALL_ACCESS", _wrap_python_const_SERVICE_ALL_ACCESS);
	 _wrap_python_const_SERVICE_CHANGE_CONFIG = PyInt_FromLong(SERVICE_CHANGE_CONFIG);
	 PyDict_SetItemString(d,"SERVICE_CHANGE_CONFIG", _wrap_python_const_SERVICE_CHANGE_CONFIG);
	 _wrap_python_const_SERVICE_ENUMERATE_DEPENDENTS = PyInt_FromLong(SERVICE_ENUMERATE_DEPENDENTS);
	 PyDict_SetItemString(d,"SERVICE_ENUMERATE_DEPENDENTS", _wrap_python_const_SERVICE_ENUMERATE_DEPENDENTS);
	 _wrap_python_const_SERVICE_INTERROGATE = PyInt_FromLong(SERVICE_INTERROGATE);
	 PyDict_SetItemString(d,"SERVICE_INTERROGATE", _wrap_python_const_SERVICE_INTERROGATE);
	 _wrap_python_const_SERVICE_PAUSE_CONTINUE = PyInt_FromLong(SERVICE_PAUSE_CONTINUE);
	 PyDict_SetItemString(d,"SERVICE_PAUSE_CONTINUE", _wrap_python_const_SERVICE_PAUSE_CONTINUE);
	 _wrap_python_const_SERVICE_QUERY_CONFIG = PyInt_FromLong(SERVICE_QUERY_CONFIG);
	 PyDict_SetItemString(d,"SERVICE_QUERY_CONFIG", _wrap_python_const_SERVICE_QUERY_CONFIG);
	 _wrap_python_const_SERVICE_QUERY_STATUS = PyInt_FromLong(SERVICE_QUERY_STATUS);
	 PyDict_SetItemString(d,"SERVICE_QUERY_STATUS", _wrap_python_const_SERVICE_QUERY_STATUS);
	 _wrap_python_const_SERVICE_START = PyInt_FromLong(SERVICE_START);
	 PyDict_SetItemString(d,"SERVICE_START", _wrap_python_const_SERVICE_START);
	 _wrap_python_const_SERVICE_STOP = PyInt_FromLong(SERVICE_STOP);
	 PyDict_SetItemString(d,"SERVICE_STOP", _wrap_python_const_SERVICE_STOP);
	 _wrap_python_const_SERVICE_USER_DEFINED_CONTROL = PyInt_FromLong(SERVICE_USER_DEFINED_CONTROL);
	 PyDict_SetItemString(d,"SERVICE_USER_DEFINED_CONTROL", _wrap_python_const_SERVICE_USER_DEFINED_CONTROL);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_LONG",0);
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_BOOLAPI","_BOOL",0);
	 SWIG_RegisterMapping("_BOOLAPI","_unsigned_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_signed_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_int",0);
	 SWIG_RegisterMapping("_long","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_long","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_long","_ULONG",0);
	 SWIG_RegisterMapping("_long","_LONG",0);
	 SWIG_RegisterMapping("_long","_DWORD",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_LPCTSTR","_char_p",0);
	 SWIG_RegisterMapping("_LPCTSTR","_LPCSTR",0);
	 SWIG_RegisterMapping("_ULONG","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_ULONG","_long",0);
	 SWIG_RegisterMapping("_ULONG","_DWORD",0);
	 SWIG_RegisterMapping("_ULONG","_LONG",0);
	 SWIG_RegisterMapping("_WORD","_unsigned_short",0);
	 SWIG_RegisterMapping("_WORD","_short",0);
	 SWIG_RegisterMapping("_LPCSTR","_LPCTSTR",0);
	 SWIG_RegisterMapping("_LPCSTR","_char_p",0);
	 SWIG_RegisterMapping("_char_p","_LPCTSTR",0);
	 SWIG_RegisterMapping("_char_p","_LPCSTR",0);
	 SWIG_RegisterMapping("_unsigned_long","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_ULONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_LONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_BOOL","_BOOLAPI",0);
	 SWIG_RegisterMapping("_BOOL","_int",0);
	 SWIG_RegisterMapping("_BOOL","_signed_int",0);
	 SWIG_RegisterMapping("_BOOL","_unsigned_int",0);
	 SWIG_RegisterMapping("_signed_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_signed_int","_BOOL",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_long",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_SERVICE_STATUS_HANDLE","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_short","_WORD",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_DWORD","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_ULONG",0);
	 SWIG_RegisterMapping("_DWORD","_LONG",0);
	 SWIG_RegisterMapping("_DWORD","_unsigned_long",0);
	 SWIG_RegisterMapping("_DWORD","_long",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_LONG","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_SC_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_ULONG",0);
	 SWIG_RegisterMapping("_LONG","_long",0);
	 SWIG_RegisterMapping("_LONG","_signed_long",0);
	 SWIG_RegisterMapping("_LONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_LONG","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOL",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_WORD",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_int","_BOOL",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_SERVICE_STATUS_HANDLE",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_long",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_SC_HANDLE","_INT_HANDLE",0);
}
