// @doc
#include "stdafxdde.h"
#include "ddemodule.h"

BOOL PythonDDEServer::OnCreate()
{
	CVirtualHelper helper("OnCreate", this);
	if (helper.HaveHandler())
		return helper.call();
	else
		return TRUE;
}

/*static*/ PythonDDEServer *PyDDEServer::GetServer (PyObject *self)
{
	return (PythonDDEServer *)ui_assoc_object::GetGoodCppObject( self, &type);
}

// @pymethod |PyDDEServer|Create|Create a server
PyObject *PyDDEServer_Create(PyObject *self, PyObject *args)
{
	char *serviceName; DWORD flags = 0;
	PythonDDEServer *pServer = PyDDEServer::GetServer(self);
	if (!pServer) return NULL;
	// @pyparm string|name||Name of the server to start.
	// @pyparm int|filterFlags|0|Filter flags.
	if (!PyArg_ParseTuple(args, "s|i:Create", &serviceName, &flags))
		return NULL;
	if (!pServer->Create(serviceName, flags))
		RETURN_DDE_ERR("The server could not be created");
	RETURN_NONE;
	// @comm Note there can only be one server per application.
}

// @pymethod |PyDDEServer|AddTopic|
PyObject *PyDDEServer_AddTopic(PyObject *self, PyObject *args)
{
	PyObject *obTopic;
	PythonDDEServer *pServer = PyDDEServer::GetServer(self);
	if (!pServer) return NULL;
	// @pyparm <o PyDDETopic>|topic||The topic to add.
	if (!PyArg_ParseTuple(args, "O:AddTopic", &obTopic))
		return NULL;
	PythonDDETopic *pTopic = PyDDETopic::GetTopic(obTopic);
	if (!pTopic) return NULL;
	if (!pServer->AddTopic(pTopic))
		RETURN_DDE_ERR("AddTopic failed.");
	RETURN_NONE;
}

// @pymethod int|PyDDEServer|GetLastError|
PyObject *PyDDEServer_GetLastError(PyObject *self, PyObject *args)
{
	PythonDDEServer *pServer = PyDDEServer::GetServer(self);
	if (!pServer) return NULL;
	if (!PyArg_ParseTuple(args, ":GetLastError"))
		return NULL;
	return Py_BuildValue("i",pServer->GetLastError());
}
// @pymethod |PyDDEServer|Destroy|
PyObject *PyDDEServer_Destroy(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":Destroy")) return NULL;
	PythonDDEServer *pServer = PyDDEServer::GetServer(self);
	if (!pServer) return NULL;
	delete pServer;
	RETURN_NONE;
}
// @pymethod |PyDDEServer|Shutdown|
PyObject *PyDDEServer_Shutdown(PyObject *self, PyObject *args)
{
	// @comm Note the underlying DDE object (ie, Server, Topics and Items) are not cleaned up by this call.
	if (!PyArg_ParseTuple(args,":Shutdown")) return NULL;
	PythonDDEServer *pServer = PyDDEServer::GetServer(self);
	if (!pServer) return NULL;
	pServer->Shutdown();
	RETURN_NONE;
}


// @object PyDDEServer|A DDE server.
static struct PyMethodDef PyDDEServer_methods[] = {
	{"AddTopic",    PyDDEServer_AddTopic, 1}, // @pymeth AddTopic|Adds a topic to the server.
	{"Create",      PyDDEServer_Create, 1}, // @pymeth Create|Creates a DDE server
	{"Destroy",		PyDDEServer_Destroy, 1}, // @pymeth Destroy|Destroys the underlying C++ object.
	{"GetLastError",PyDDEServer_GetLastError, 1}, // @pymeth GetLastError|Returns the last DDE error.
	{"Showdown",	PyDDEServer_Shutdown, 1}, // @pymeth Shutdown|Shutsdown the server.
	{NULL,			NULL}		// sentinel
};



ui_type_CObject PyDDEServer::type("PyDDEServer", 
								   &ui_assoc_CObject::type, 
								   RUNTIME_CLASS(CDDEServer), 
								   sizeof(PyDDEServer), 
								   PyDDEServer_methods,
      							   GET_PY_CTOR(PyDDEServer));
