// @doc
#include "stdafxdde.h"
#include "ddemodule.h"

static char BASED_CODE szModName[] = "dde";
static char BASED_CODE errorName[] = "error";
PyObject * BASED_CODE dde_module_error = NULL;

PyObject *PyDDE_CreateServer(PyObject *s, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":CreateServer")) return NULL;
	return ui_assoc_object::make(PyDDEServer::type, new PythonDDEServer);
}

PyObject *PyDDE_CreateTopic(PyObject *s, PyObject *args)
{
	char *name;
	if (!PyArg_ParseTuple(args,"s:CreateTopic", &name)) return NULL;
	PythonDDETopic *pNew = new PythonDDETopic;
	pNew->Create(name);
	return ui_assoc_object::make(PyDDETopic::type, pNew);
}

PyObject *PyDDE_CreateStringItem(PyObject *s, PyObject *args)
{
	char *name;
	if (!PyArg_ParseTuple(args,"s:CreateStringItem", &name)) return NULL;
	PythonDDEStringItem *pNew = new PythonDDEStringItem;
	pNew->Create(name);
	return ui_assoc_object::make(PyDDEStringItem::type, pNew);
}

// @module dde|A module for DDE support
static struct PyMethodDef dde_methods[] =
{
	{"CreateServer", PyDDE_CreateServer, 1},
	{"CreateTopic", PyDDE_CreateTopic, 1},
	{"CreateStringItem", PyDDE_CreateStringItem, 1},
	{NULL,  NULL}
};

extern "C" void __declspec(dllexport) initdde(void)
{
	PyObject *dict, *module;
	if (AfxGetApp()==NULL) {
		PyErr_SetString(PyExc_ImportError, "This must be an MFC application - try loading win32ui first");
		return;
	}
	module = Py_InitModule(szModName, dde_methods);
	dict = PyModule_GetDict(module);
	dde_module_error = PyString_FromString(errorName);
	PyDict_SetItemString(dict, "error", dde_module_error);
}
