//
// @doc

#include "windows.h"
#include "Python.h"
#include "PyWinTypes.h"
#include "PyWinObjects.h"
#include "PySecurityObjects.h"

// @pymethod <o PySID>|pywintypes|SID|Creates a new SID object
PyObject *PyWinMethod_NewSID(PyObject *self, PyObject *args)
{
	int bufSize = 32;
	if (!PyArg_ParseTuple(args, "|i:SID", &bufSize))
		return NULL;
	return new PySID(bufSize);
}

BOOL PyWinObject_AsSID(PyObject *ob, PSID *ppSID, BOOL bNoneOK /*= TRUE*/)
{
	if (bNoneOK && ob==Py_None) {
		*ppSID = NULL;
	} else if (!PySID_Check(ob)) {
		PyErr_SetString(PyExc_TypeError, "The object is not a PySID object");
		return FALSE;
	} else {
		*ppSID = ((PySID *)ob)->GetSID();
	}
	return TRUE;
}

// @pymethod |PySID|Initialize|Initialize the SID.
PyObject *PySID::Initialize(PyObject *self, PyObject *args)
{
	PySID *This = (PySID *)self;
	byte cnt;
	SID_IDENTIFIER_AUTHORITY sid_ia;
	if (!PyArg_ParseTuple(args, "(bbbbbb)b:Initialize", 
		&sid_ia.Value[0], &sid_ia.Value[1],&sid_ia.Value[2],
		&sid_ia.Value[3],&sid_ia.Value[4],&sid_ia.Value[5],
		&cnt))
		return NULL;
	if (!InitializeSid(This->GetSID(), &sid_ia, cnt))
		return PyWin_SetAPIError("InitializeSid");
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PySID|SetSubAuthority|Sets a SID SubAuthority
// @comm See the function GetSidSubAuthority
PyObject *PySID::SetSubAuthority(PyObject *self, PyObject *args)
{
	PySID *This = (PySID *)self;
	int num;
	long val;
	if (!PyArg_ParseTuple(args, "il", &num, &val))
		return NULL;
	*GetSidSubAuthority(This->GetSID(), num) = val;
	Py_INCREF(Py_None);
	return Py_None;
}

// @object PySID|A Python object, representing a SID structure
static struct PyMethodDef PySID_methods[] = {
	{"Initialize",     PySID::Initialize, 1}, 	// @pymeth Initialize|Initialize the SID.
	{"SetSubAuthority",PySID::SetSubAuthority, 1}, 	// @pymeth SetSubAuthority|Sets a SID SubAuthority
	{NULL}
};


PYWINTYPES_EXPORT PyTypeObject PySIDType =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PySID",
	sizeof(PySID),
	0,
	PySID::deallocFunc,		/* tp_dealloc */
	0,		/* tp_print */
	PySID::getattr,				/* tp_getattr */
	0,				/* tp_setattr */
	0,
	0,						/* tp_repr */
	0,						/* tp_as_number */
	0,	/* tp_as_sequence */
	0,						/* tp_as_mapping */
	0,
	0,						/* tp_call */
	0,		/* tp_str */
};


PySID::PySID(int bufSize)
{
	ob_type = &PySIDType;
	_Py_NewReference(this);
	m_psid = (PSID)malloc(bufSize);
	memset(m_psid, 0, bufSize);
}

PySID::~PySID()
{
	free(m_psid);
}

PyObject *PySID::getattr(PyObject *self, char *name)
{
	return Py_FindMethod(PySID_methods, self, name);
}

/*static*/ void PySID::deallocFunc(PyObject *ob)
{
	delete (PySID *)ob;
}

