
import win32serviceutil, win32evtlog, win32event
import win32service
import eventlogchecker

class EventLogChecker(eventlogchecker.EventLogChecker):
	def ActionFailed(self, msg, items, filter, action):
		import servicemanager
		servicemanager.LogErrorMsg("EventLogChecker action %s failed\r\n%s" % (action.actionName, `msg`))

class EventLogCheckerService(win32serviceutil.ServiceFramework):
	_svc_name_ = "Trapper"
	_svc_display_name_ = "Trapper Service"
	_svc_deps_ = ['EventLog']
	def __init__(self, args):
		win32serviceutil.ServiceFramework.__init__(self, args)
		import win32traceutil
		self.hWaitStop = win32event.CreateEvent(None, 0, 0, None)
		self.hWaitEventLog = win32event.CreateEvent(None, 0, 0, None)
		self.hEventLog = win32evtlog.OpenEventLog(None,"Application")
		win32evtlog.NotifyChangeEventLog(self.hEventLog, self.hWaitEventLog)
		self.eventLogCheckers = eventlogchecker.CreateEventLogCheckers(EventLogChecker)
#		if self.ssh:
		import servicemanager
		servicemanager.LogInfoMsg("The %s service is starting" % (self._svc_display_name_))

	def SvcStop(self):
		self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
		win32event.SetEvent(self.hWaitStop)

	def SvcDoRun(self):
		# Seek to the end of the event log
		flags = win32evtlog.EVENTLOG_SEEK_READ | win32evtlog.EVENTLOG_FORWARDS_READ
		offset = win32evtlog.GetNumberOfEventLogRecords(self.hEventLog)
		data = win32evtlog.ReadEventLog(self.hEventLog, flags, offset)
		print "Throwing away", data
		print "Entering wait loop"
		while 1:
			rc = win32event.WaitForMultipleObjects((self.hWaitStop, self.hWaitEventLog), 0, win32event.INFINITE)
			if rc==win32event.WAIT_OBJECT_0:
				# Stop event
				break
			else:
				print "** New event log entry"
				while 1:
					data = win32evtlog.ReadEventLog(self.hEventLog, win32evtlog.EVENTLOG_SEQUENTIAL_READ|win32evtlog.EVENTLOG_FORWARDS_READ, 0)
					print "No of items is", len(data)
					if not data:
						break
					for item in data:
						for checker in self.eventLogCheckers:
							checker.EventItemFeeder(item)
							checker.Process()

if __name__=='__main__':
	win32serviceutil.HandleCommandLine(EventLogCheckerService)

