/*
 * FILE : win32filemodule.cpp
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 -3
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initwin32file

#define SWIG_name    "win32file"

//#define UNICODE

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                            
        if (!PyTuple_Check(target)) {   
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#include "windows.h"
#include "winbase.h"
#include "PyWinTypes.h"
#include "tchar.h"
typedef BOOL  BOOLAPI;

typedef HANDLE INT_HANDLE;
static PyObject *_wrap_python_const_FILE_GENERIC_READ;
static PyObject *_wrap_python_const_FILE_GENERIC_WRITE;
static PyObject *_wrap_python_const_FILE_ALL_ACCESS;
static PyObject *_wrap_python_const_GENERIC_READ;
static PyObject *_wrap_python_const_GENERIC_WRITE;
static PyObject *_wrap_python_const_GENERIC_EXECUTE;
static PyObject *_wrap_python_const_FILE_SHARE_DELETE;
static PyObject *_wrap_python_const_FILE_SHARE_READ;
static PyObject *_wrap_python_const_FILE_SHARE_WRITE;
static PyObject *_wrap_python_const_CREATE_NEW;
static PyObject *_wrap_python_const_CREATE_ALWAYS;
static PyObject *_wrap_python_const_OPEN_EXISTING;
static PyObject *_wrap_python_const_OPEN_ALWAYS;
static PyObject *_wrap_python_const_TRUNCATE_EXISTING;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_ARCHIVE;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_COMPRESSED;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_HIDDEN;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_NORMAL;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_OFFLINE;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_READONLY;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_SYSTEM;
static PyObject *_wrap_python_const_FILE_ATTRIBUTE_TEMPORARY;
static PyObject *_wrap_python_const_FILE_FLAG_WRITE_THROUGH;
static PyObject *_wrap_python_const_FILE_FLAG_OVERLAPPED;
static PyObject *_wrap_python_const_FILE_FLAG_NO_BUFFERING;
static PyObject *_wrap_python_const_FILE_FLAG_RANDOM_ACCESS;
static PyObject *_wrap_python_const_FILE_FLAG_SEQUENTIAL_SCAN;
static PyObject *_wrap_python_const_FILE_FLAG_DELETE_ON_CLOSE;
static PyObject *_wrap_python_const_FILE_FLAG_BACKUP_SEMANTICS;
static PyObject *_wrap_python_const_FILE_FLAG_POSIX_SEMANTICS;
static PyObject *_wrap_python_const_SECURITY_ANONYMOUS;
static PyObject *_wrap_python_const_SECURITY_IDENTIFICATION;
static PyObject *_wrap_python_const_SECURITY_IMPERSONATION;
static PyObject *_wrap_python_const_SECURITY_DELEGATION;
static PyObject *_wrap_python_const_SECURITY_CONTEXT_TRACKING;
static PyObject *_wrap_python_const_SECURITY_EFFECTIVE_ONLY;
static PyObject *_wrap_python_const_SCS_32BIT_BINARY;
static PyObject *_wrap_python_const_SCS_DOS_BINARY;
static PyObject *_wrap_python_const_SCS_OS216_BINARY;
static PyObject *_wrap_python_const_SCS_PIF_BINARY;
static PyObject *_wrap_python_const_SCS_POSIX_BINARY;
static PyObject *_wrap_python_const_SCS_WOW_BINARY;
static PyObject *_wrap_python_const_DRIVE_UNKNOWN;
static PyObject *_wrap_python_const_DRIVE_NO_ROOT_DIR;
static PyObject *_wrap_python_const_DRIVE_REMOVABLE;
static PyObject *_wrap_python_const_DRIVE_FIXED;
static PyObject *_wrap_python_const_DRIVE_REMOTE;
static PyObject *_wrap_python_const_DRIVE_CDROM;
static PyObject *_wrap_python_const_DRIVE_RAMDISK;

PyObject *MyGetCompressedFileSize(TCHAR *fname)
{
	DWORD dwSizeLow, dwSizeHigh;
    Py_BEGIN_ALLOW_THREADS
	dwSizeLow = GetCompressedFileSize(fname, &dwSizeHigh);
    Py_END_ALLOW_THREADS
	// If we failed ... 
	if (dwSizeLow == 0xFFFFFFFF && 
	    GetLastError() != NO_ERROR )
		return PyWin_SetAPIError("GetFileSize");
	return PyLong_FromTwoInts(dwSizeHigh, dwSizeLow);
}
PyObject *MyGetFileSize(HANDLE hFile)
{
	DWORD dwSizeLow, dwSizeHigh;
    Py_BEGIN_ALLOW_THREADS
	dwSizeLow = GetFileSize (hFile, &dwSizeHigh);
    Py_END_ALLOW_THREADS
	// If we failed ... 
	if (dwSizeLow == 0xFFFFFFFF && 
	    GetLastError() != NO_ERROR )
		return PyWin_SetAPIError("GetFileSize");
	return PyLong_FromTwoInts(dwSizeHigh, dwSizeLow);
}

// @pyswig int|ReadFile|Reads a string from a file
PyObject *MyReadFile(PyObject *self, PyObject *args)
{
	OVERLAPPED *pOverlapped;
	PyObject *obhFile;
	HANDLE hFile;
	DWORD bufSize;
	PyObject *obOverlapped = NULL;

	if (!PyArg_ParseTuple(args, "Ol|O:ReadFile", 
		&obhFile, // @pyparm int|hFile||Handle to the file
		&bufSize, // @pyparm int|bufSize||Size of the buffer to create for the read.
		&obOverlapped))	// @pyparm <o PyOVERLAPPED>|ol|None|An overlapped structure
		return NULL;
	if (obOverlapped==NULL)
		pOverlapped = NULL;
	else {
		if (!PyWinObject_AsOVERLAPPED(obOverlapped, &pOverlapped))
			return NULL;
	}
	if (!PyWinObject_AsHANDLE(obhFile, &hFile))
		return NULL;

	void *buf = malloc(bufSize);
	DWORD numRead;
	BOOL ok;
    Py_BEGIN_ALLOW_THREADS
	ok = ReadFile(hFile, buf, bufSize, &numRead, pOverlapped);
    Py_END_ALLOW_THREADS
	if (!ok) {
		free(buf);
		return PyWin_SetAPIError("ReadFile");
	}
	PyObject *result = PyString_FromStringAndSize((char *)buf, numRead);
	free(buf);
	return result;
}

// @pyswig int|WriteFile|Writes a string to a file
// @rdesc The result is the number of bytes written.
PyObject *MyWriteFile(PyObject *self, PyObject *args)
{
	OVERLAPPED *pOverlapped;
	PyObject *obhFile;
	HANDLE hFile;
	char *writeData;
	DWORD writeSize;
	PyObject *obOverlapped = NULL;

	if (!PyArg_ParseTuple(args, "Os#|O:Write", 
		&obhFile, // @pyparm <o PyHANDLE>|hFile||Handle to the file
		&writeData, &writeSize, // @pyparm string|data||The data to write.
		&obOverlapped))	// @pyparm <o PyOVERLAPPED>|ol|None|An overlapped structure
		return NULL;
	if (obOverlapped==NULL)
		pOverlapped = NULL;
	else {
		if (!PyWinObject_AsOVERLAPPED(obOverlapped, &pOverlapped))
			return NULL;
	}
	if (!PyWinObject_AsHANDLE(obhFile, &hFile))
		return NULL;
	DWORD numWritten;
	BOOL ok;
    Py_BEGIN_ALLOW_THREADS
	ok = WriteFile(hFile, writeData, writeSize, &numWritten, pOverlapped);
    Py_END_ALLOW_THREADS
	if (!ok) {
		return PyWin_SetAPIError("WriteFile");
	}
	return PyInt_FromLong(numWritten);
}

// @pyswig |CloseHandle|Closes an open handle.
static PyObject *MyCloseHandle(PyObject *self, PyObject *args)
{
	PyObject *obHandle;
	if (!PyArg_ParseTuple(args, "O:CloseHandle",
			&obHandle)) // @pyparm <o PyHANDLE>/int|handle||A previously opened handle.
		return NULL;
	if (!PyWinObject_CloseHANDLE(obHandle))
		return NULL
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *_wrap_python_const_FILE_TYPE_UNKNOWN;
static PyObject *_wrap_python_const_FILE_TYPE_DISK;
static PyObject *_wrap_python_const_FILE_TYPE_CHAR;
static PyObject *_wrap_python_const_FILE_TYPE_PIPE;
static PyObject *_wrap_python_const_MOVEFILE_COPY_ALLOWED;
static PyObject *_wrap_python_const_MOVEFILE_DELAY_UNTIL_REBOOT;
static PyObject *_wrap_python_const_MOVEFILE_REPLACE_EXISTING;
static PyObject *_wrap_python_const_MOVEFILE_WRITE_THROUGH;
static PyObject *_wrap_AreFileApisANSI(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOL  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":AreFileApisANSI")) 
        return NULL;
    _result = (BOOL )AreFileApisANSI();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_CopyFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    TCHAR * _arg1;
    BOOL  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OOi:CopyFile",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )CopyFile(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}

           return PyWin_SetAPIError("CopyFile");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_CreateDirectory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    SECURITY_ATTRIBUTES * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"OO:CreateDirectory",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsSECURITY_ATTRIBUTES(_obj1, &_arg1))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )CreateDirectory(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("CreateDirectory");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_CreateDirectoryEx(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    TCHAR * _arg1;
    SECURITY_ATTRIBUTES * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OOO:CreateDirectoryEx",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsSECURITY_ATTRIBUTES(_obj2, &_arg2))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )CreateDirectoryEx(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}

           return PyWin_SetAPIError("CreateDirectoryEx");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_CreateFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HANDLE  _result;
    TCHAR * _arg0;
    DWORD  _arg1;
    DWORD  _arg2;
    SECURITY_ATTRIBUTES * _arg3;
    DWORD  _arg4;
    DWORD  _arg5;
    HANDLE  _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj6 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"OllOllO:CreateFile",&_obj0,&_arg1,&_arg2,&_obj3,&_arg4,&_arg5,&_obj6)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsSECURITY_ATTRIBUTES(_obj3, &_arg3))
		return NULL;
}
{
	if (!PyWinObject_AsHANDLE(_obj6, &_arg6, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HANDLE )CreateFile(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);

      Py_END_ALLOW_THREADS
      if (_result==0 || _result==INVALID_HANDLE_VALUE)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("CreateFile");
      }
}{
  _resultobj = PyWinObject_FromHANDLE(_result);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_DefineDosDevice(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    DWORD  _arg0;
    TCHAR * _arg1;
    TCHAR * _arg2;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
	_arg1 = NULL;
}
{
	_arg2 = NULL;
}
    if(!PyArg_ParseTuple(args,"lOO:DefineDosDevice",&_arg0,&_obj1,&_obj2)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj2, &_arg2, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )DefineDosDevice(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg1);
}
{
	PyWinObject_FreeTCHAR(_arg2);
}

           return PyWin_SetAPIError("DefineDosDevice");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
{
	PyWinObject_FreeTCHAR(_arg2);
}
    return _resultobj;
}

static PyObject *_wrap_DeleteFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:DeleteFile",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )DeleteFile(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("DeleteFile");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_FindClose(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    INT_HANDLE  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:FindClose",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )FindClose(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("FindClose");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_FindCloseChangeNotification(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    INT_HANDLE  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:FindCloseChangeNotification",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )FindCloseChangeNotification(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("FindCloseChangeNotification");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_FindFirstChangeNotification(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    INT_HANDLE  _result;
    TCHAR * _arg0;
    BOOL  _arg1;
    DWORD  _arg2;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"Oil:FindFirstChangeNotification",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (INT_HANDLE )FindFirstChangeNotification(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (_result==0 || _result==INVALID_HANDLE_VALUE)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("FindFirstChangeNotification");
      }
}    _resultobj = Py_BuildValue("l",_result);
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_FindNextChangeNotification(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    INT_HANDLE  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:FindNextChangeNotification",&_arg0)) 
        return NULL;
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )FindNextChangeNotification(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("FindNextChangeNotification");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_FlushFileBuffers(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:FlushFileBuffers",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )FlushFileBuffers(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("FlushFileBuffers");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_GetBinaryType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:GetBinaryType",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )GetBinaryType(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("GetBinaryType");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_GetDiskFreeSpace(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    unsigned long * _arg2;
    unsigned long  temp0;
    unsigned long * _arg3;
    unsigned long  temp1;
    unsigned long * _arg4;
    unsigned long  temp2;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
{
  _arg2 = &temp0;
}
{
  _arg3 = &temp1;
}
{
  _arg4 = &temp2;
}
    if(!PyArg_ParseTuple(args,"O:GetDiskFreeSpace",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )GetDiskFreeSpace(_arg0,_arg1,_arg2,_arg3,_arg4);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("GetDiskFreeSpace");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg3));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_GetDriveType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    long  _result;
    TCHAR * _arg0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:GetDriveType",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (long )GetDriveType(_arg0);
    _resultobj = Py_BuildValue("l",_result);
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_GetFileAttributes(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DWORD  _result;
    TCHAR * _arg0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:GetFileAttributes",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (DWORD )GetFileAttributes(_arg0);
    _resultobj = Py_BuildValue("l",_result);
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_GetCompressedFileSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:GetCompressedFileSize",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )GetCompressedFileSize(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("GetCompressedFileSize");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_GetFileSize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DWORD  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GetFileSize",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (DWORD )MyGetFileSize(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_GetFileType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned long  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GetFileType",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (unsigned long )GetFileType(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_GetLogicalDrives(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned long  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":GetLogicalDrives")) 
        return NULL;
    _result = (unsigned long )GetLogicalDrives();
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_LockFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    DWORD  _arg1;
    DWORD  _arg2;
    DWORD  _arg3;
    DWORD  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ollll:LockFile",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )LockFile(_arg0,_arg1,_arg2,_arg3,_arg4);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("LockFile");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_MoveFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    TCHAR * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OO:MoveFile",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )MoveFile(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}

           return PyWin_SetAPIError("MoveFile");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_MoveFileEx(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    TCHAR * _arg1;
    DWORD  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OOl:MoveFileEx",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )MoveFileEx(_arg0,_arg1,_arg2);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}

           return PyWin_SetAPIError("MoveFileEx");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_RemoveDirectory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:RemoveDirectory",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )RemoveDirectory(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("RemoveDirectory");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_SetCurrentDirectory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"O:SetCurrentDirectory",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )SetCurrentDirectory(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("SetCurrentDirectory");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_SetEndOfFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOL  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:SetEndOfFile",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (BOOL )SetEndOfFile(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_SetFileApisToANSI(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":SetFileApisToANSI")) 
        return NULL;
    SetFileApisToANSI();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_SetFileApisToOEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":SetFileApisToOEM")) 
        return NULL;
    SetFileApisToOEM();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_SetFileAttributes(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    DWORD  _arg1;
    PyObject * _obj0 = 0;

    self = self;
{
	_arg0 = NULL;
}
    if(!PyArg_ParseTuple(args,"Ol:SetFileAttributes",&_obj0,&_arg1)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )SetFileAttributes(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}

           return PyWin_SetAPIError("SetFileAttributes");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
    return _resultobj;
}

static PyObject *_wrap_SetVolumeLabel(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    TCHAR * _arg0;
    TCHAR * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg0 = NULL;
}
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OO:SetVolumeLabel",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsTCHAR(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsTCHAR(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )SetVolumeLabel(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}

           return PyWin_SetAPIError("SetVolumeLabel");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	PyWinObject_FreeTCHAR(_arg0);
}
{
	PyWinObject_FreeTCHAR(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_UnlockFile(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    DWORD  _arg1;
    DWORD  _arg2;
    DWORD  _arg3;
    DWORD  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ollll:UnlockFile",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )UnlockFile(_arg0,_arg1,_arg2,_arg3,_arg4);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("UnlockFile");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyMethodDef win32fileMethods[] = {
	 { "UnlockFile", _wrap_UnlockFile, 1 },
	 { "SetVolumeLabel", _wrap_SetVolumeLabel, 1 },
	 { "SetFileAttributes", _wrap_SetFileAttributes, 1 },
	 { "SetFileApisToOEM", _wrap_SetFileApisToOEM, 1 },
	 { "SetFileApisToANSI", _wrap_SetFileApisToANSI, 1 },
	 { "SetEndOfFile", _wrap_SetEndOfFile, 1 },
	 { "SetCurrentDirectory", _wrap_SetCurrentDirectory, 1 },
	 { "RemoveDirectory", _wrap_RemoveDirectory, 1 },
	 { "MoveFileEx", _wrap_MoveFileEx, 1 },
	 { "MoveFile", _wrap_MoveFile, 1 },
	 { "LockFile", _wrap_LockFile, 1 },
	 { "GetLogicalDrives", _wrap_GetLogicalDrives, 1 },
	 { "GetFileType", _wrap_GetFileType, 1 },
	 { "CloseHandle", MyCloseHandle, 1 },
	 { "WriteFile", MyWriteFile, 1 },
	 { "ReadFile", MyReadFile, 1 },
	 { "GetFileSize", _wrap_GetFileSize, 1 },
	 { "GetCompressedFileSize", _wrap_GetCompressedFileSize, 1 },
	 { "GetFileAttributes", _wrap_GetFileAttributes, 1 },
	 { "GetDriveType", _wrap_GetDriveType, 1 },
	 { "GetDiskFreeSpace", _wrap_GetDiskFreeSpace, 1 },
	 { "GetBinaryType", _wrap_GetBinaryType, 1 },
	 { "FlushFileBuffers", _wrap_FlushFileBuffers, 1 },
	 { "FindNextChangeNotification", _wrap_FindNextChangeNotification, 1 },
	 { "FindFirstChangeNotification", _wrap_FindFirstChangeNotification, 1 },
	 { "FindCloseChangeNotification", _wrap_FindCloseChangeNotification, 1 },
	 { "FindClose", _wrap_FindClose, 1 },
	 { "DeleteFile", _wrap_DeleteFile, 1 },
	 { "DefineDosDevice", _wrap_DefineDosDevice, 1 },
	 { "CreateFile", _wrap_CreateFile, 1 },
	 { "CreateDirectoryEx", _wrap_CreateDirectoryEx, 1 },
	 { "CreateDirectory", _wrap_CreateDirectory, 1 },
	 { "CopyFile", _wrap_CopyFile, 1 },
	 { "AreFileApisANSI", _wrap_AreFileApisANSI, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initwin32file)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("win32file", win32fileMethods);
	 d = PyModule_GetDict(m);

#ifndef PYCOM_EXPORT
	 PyDict_SetItemString(d,"UNICODE", PyInt_FromLong(
#ifdef UNICODE
	1
#else
	0
#endif
	));
#endif
	 _wrap_python_const_FILE_GENERIC_READ = PyInt_FromLong(FILE_GENERIC_READ);
	 PyDict_SetItemString(d,"FILE_GENERIC_READ", _wrap_python_const_FILE_GENERIC_READ);
	 _wrap_python_const_FILE_GENERIC_WRITE = PyInt_FromLong(FILE_GENERIC_WRITE);
	 PyDict_SetItemString(d,"FILE_GENERIC_WRITE", _wrap_python_const_FILE_GENERIC_WRITE);
	 _wrap_python_const_FILE_ALL_ACCESS = PyInt_FromLong(FILE_ALL_ACCESS);
	 PyDict_SetItemString(d,"FILE_ALL_ACCESS", _wrap_python_const_FILE_ALL_ACCESS);
	 _wrap_python_const_GENERIC_READ = PyInt_FromLong(GENERIC_READ);
	 PyDict_SetItemString(d,"GENERIC_READ", _wrap_python_const_GENERIC_READ);
	 _wrap_python_const_GENERIC_WRITE = PyInt_FromLong(GENERIC_WRITE);
	 PyDict_SetItemString(d,"GENERIC_WRITE", _wrap_python_const_GENERIC_WRITE);
	 _wrap_python_const_GENERIC_EXECUTE = PyInt_FromLong(GENERIC_EXECUTE);
	 PyDict_SetItemString(d,"GENERIC_EXECUTE", _wrap_python_const_GENERIC_EXECUTE);
	 _wrap_python_const_FILE_SHARE_DELETE = PyInt_FromLong(FILE_SHARE_DELETE);
	 PyDict_SetItemString(d,"FILE_SHARE_DELETE", _wrap_python_const_FILE_SHARE_DELETE);
	 _wrap_python_const_FILE_SHARE_READ = PyInt_FromLong(FILE_SHARE_READ);
	 PyDict_SetItemString(d,"FILE_SHARE_READ", _wrap_python_const_FILE_SHARE_READ);
	 _wrap_python_const_FILE_SHARE_WRITE = PyInt_FromLong(FILE_SHARE_WRITE);
	 PyDict_SetItemString(d,"FILE_SHARE_WRITE", _wrap_python_const_FILE_SHARE_WRITE);
	 _wrap_python_const_CREATE_NEW = PyInt_FromLong(CREATE_NEW);
	 PyDict_SetItemString(d,"CREATE_NEW", _wrap_python_const_CREATE_NEW);
	 _wrap_python_const_CREATE_ALWAYS = PyInt_FromLong(CREATE_ALWAYS);
	 PyDict_SetItemString(d,"CREATE_ALWAYS", _wrap_python_const_CREATE_ALWAYS);
	 _wrap_python_const_OPEN_EXISTING = PyInt_FromLong(OPEN_EXISTING);
	 PyDict_SetItemString(d,"OPEN_EXISTING", _wrap_python_const_OPEN_EXISTING);
	 _wrap_python_const_OPEN_ALWAYS = PyInt_FromLong(OPEN_ALWAYS);
	 PyDict_SetItemString(d,"OPEN_ALWAYS", _wrap_python_const_OPEN_ALWAYS);
	 _wrap_python_const_TRUNCATE_EXISTING = PyInt_FromLong(TRUNCATE_EXISTING);
	 PyDict_SetItemString(d,"TRUNCATE_EXISTING", _wrap_python_const_TRUNCATE_EXISTING);
	 _wrap_python_const_FILE_ATTRIBUTE_ARCHIVE = PyInt_FromLong(FILE_ATTRIBUTE_ARCHIVE);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_ARCHIVE", _wrap_python_const_FILE_ATTRIBUTE_ARCHIVE);
	 _wrap_python_const_FILE_ATTRIBUTE_COMPRESSED = PyInt_FromLong(FILE_ATTRIBUTE_COMPRESSED);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_COMPRESSED", _wrap_python_const_FILE_ATTRIBUTE_COMPRESSED);
	 _wrap_python_const_FILE_ATTRIBUTE_HIDDEN = PyInt_FromLong(FILE_ATTRIBUTE_HIDDEN);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_HIDDEN", _wrap_python_const_FILE_ATTRIBUTE_HIDDEN);
	 _wrap_python_const_FILE_ATTRIBUTE_NORMAL = PyInt_FromLong(FILE_ATTRIBUTE_NORMAL);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_NORMAL", _wrap_python_const_FILE_ATTRIBUTE_NORMAL);
	 _wrap_python_const_FILE_ATTRIBUTE_OFFLINE = PyInt_FromLong(FILE_ATTRIBUTE_OFFLINE);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_OFFLINE", _wrap_python_const_FILE_ATTRIBUTE_OFFLINE);
	 _wrap_python_const_FILE_ATTRIBUTE_READONLY = PyInt_FromLong(FILE_ATTRIBUTE_READONLY);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_READONLY", _wrap_python_const_FILE_ATTRIBUTE_READONLY);
	 _wrap_python_const_FILE_ATTRIBUTE_SYSTEM = PyInt_FromLong(FILE_ATTRIBUTE_SYSTEM);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_SYSTEM", _wrap_python_const_FILE_ATTRIBUTE_SYSTEM);
	 _wrap_python_const_FILE_ATTRIBUTE_TEMPORARY = PyInt_FromLong(FILE_ATTRIBUTE_TEMPORARY);
	 PyDict_SetItemString(d,"FILE_ATTRIBUTE_TEMPORARY", _wrap_python_const_FILE_ATTRIBUTE_TEMPORARY);
	 _wrap_python_const_FILE_FLAG_WRITE_THROUGH = PyInt_FromLong(FILE_FLAG_WRITE_THROUGH);
	 PyDict_SetItemString(d,"FILE_FLAG_WRITE_THROUGH", _wrap_python_const_FILE_FLAG_WRITE_THROUGH);
	 _wrap_python_const_FILE_FLAG_OVERLAPPED = PyInt_FromLong(FILE_FLAG_OVERLAPPED);
	 PyDict_SetItemString(d,"FILE_FLAG_OVERLAPPED", _wrap_python_const_FILE_FLAG_OVERLAPPED);
	 _wrap_python_const_FILE_FLAG_NO_BUFFERING = PyInt_FromLong(FILE_FLAG_NO_BUFFERING);
	 PyDict_SetItemString(d,"FILE_FLAG_NO_BUFFERING", _wrap_python_const_FILE_FLAG_NO_BUFFERING);
	 _wrap_python_const_FILE_FLAG_RANDOM_ACCESS = PyInt_FromLong(FILE_FLAG_RANDOM_ACCESS);
	 PyDict_SetItemString(d,"FILE_FLAG_RANDOM_ACCESS", _wrap_python_const_FILE_FLAG_RANDOM_ACCESS);
	 _wrap_python_const_FILE_FLAG_SEQUENTIAL_SCAN = PyInt_FromLong(FILE_FLAG_SEQUENTIAL_SCAN);
	 PyDict_SetItemString(d,"FILE_FLAG_SEQUENTIAL_SCAN", _wrap_python_const_FILE_FLAG_SEQUENTIAL_SCAN);
	 _wrap_python_const_FILE_FLAG_DELETE_ON_CLOSE = PyInt_FromLong(FILE_FLAG_DELETE_ON_CLOSE);
	 PyDict_SetItemString(d,"FILE_FLAG_DELETE_ON_CLOSE", _wrap_python_const_FILE_FLAG_DELETE_ON_CLOSE);
	 _wrap_python_const_FILE_FLAG_BACKUP_SEMANTICS = PyInt_FromLong(FILE_FLAG_BACKUP_SEMANTICS);
	 PyDict_SetItemString(d,"FILE_FLAG_BACKUP_SEMANTICS", _wrap_python_const_FILE_FLAG_BACKUP_SEMANTICS);
	 _wrap_python_const_FILE_FLAG_POSIX_SEMANTICS = PyInt_FromLong(FILE_FLAG_POSIX_SEMANTICS);
	 PyDict_SetItemString(d,"FILE_FLAG_POSIX_SEMANTICS", _wrap_python_const_FILE_FLAG_POSIX_SEMANTICS);
	 _wrap_python_const_SECURITY_ANONYMOUS = PyInt_FromLong(SECURITY_ANONYMOUS);
	 PyDict_SetItemString(d,"SECURITY_ANONYMOUS", _wrap_python_const_SECURITY_ANONYMOUS);
	 _wrap_python_const_SECURITY_IDENTIFICATION = PyInt_FromLong(SECURITY_IDENTIFICATION);
	 PyDict_SetItemString(d,"SECURITY_IDENTIFICATION", _wrap_python_const_SECURITY_IDENTIFICATION);
	 _wrap_python_const_SECURITY_IMPERSONATION = PyInt_FromLong(SECURITY_IMPERSONATION);
	 PyDict_SetItemString(d,"SECURITY_IMPERSONATION", _wrap_python_const_SECURITY_IMPERSONATION);
	 _wrap_python_const_SECURITY_DELEGATION = PyInt_FromLong(SECURITY_DELEGATION);
	 PyDict_SetItemString(d,"SECURITY_DELEGATION", _wrap_python_const_SECURITY_DELEGATION);
	 _wrap_python_const_SECURITY_CONTEXT_TRACKING = PyInt_FromLong(SECURITY_CONTEXT_TRACKING);
	 PyDict_SetItemString(d,"SECURITY_CONTEXT_TRACKING", _wrap_python_const_SECURITY_CONTEXT_TRACKING);
	 _wrap_python_const_SECURITY_EFFECTIVE_ONLY = PyInt_FromLong(SECURITY_EFFECTIVE_ONLY);
	 PyDict_SetItemString(d,"SECURITY_EFFECTIVE_ONLY", _wrap_python_const_SECURITY_EFFECTIVE_ONLY);
	 _wrap_python_const_SCS_32BIT_BINARY = PyInt_FromLong(SCS_32BIT_BINARY);
	 PyDict_SetItemString(d,"SCS_32BIT_BINARY", _wrap_python_const_SCS_32BIT_BINARY);
	 _wrap_python_const_SCS_DOS_BINARY = PyInt_FromLong(SCS_DOS_BINARY);
	 PyDict_SetItemString(d,"SCS_DOS_BINARY", _wrap_python_const_SCS_DOS_BINARY);
	 _wrap_python_const_SCS_OS216_BINARY = PyInt_FromLong(SCS_OS216_BINARY);
	 PyDict_SetItemString(d,"SCS_OS216_BINARY", _wrap_python_const_SCS_OS216_BINARY);
	 _wrap_python_const_SCS_PIF_BINARY = PyInt_FromLong(SCS_PIF_BINARY);
	 PyDict_SetItemString(d,"SCS_PIF_BINARY", _wrap_python_const_SCS_PIF_BINARY);
	 _wrap_python_const_SCS_POSIX_BINARY = PyInt_FromLong(SCS_POSIX_BINARY);
	 PyDict_SetItemString(d,"SCS_POSIX_BINARY", _wrap_python_const_SCS_POSIX_BINARY);
	 _wrap_python_const_SCS_WOW_BINARY = PyInt_FromLong(SCS_WOW_BINARY);
	 PyDict_SetItemString(d,"SCS_WOW_BINARY", _wrap_python_const_SCS_WOW_BINARY);
	 _wrap_python_const_DRIVE_UNKNOWN = PyInt_FromLong(DRIVE_UNKNOWN);
	 PyDict_SetItemString(d,"DRIVE_UNKNOWN", _wrap_python_const_DRIVE_UNKNOWN);
	 _wrap_python_const_DRIVE_NO_ROOT_DIR = PyInt_FromLong(DRIVE_NO_ROOT_DIR);
	 PyDict_SetItemString(d,"DRIVE_NO_ROOT_DIR", _wrap_python_const_DRIVE_NO_ROOT_DIR);
	 _wrap_python_const_DRIVE_REMOVABLE = PyInt_FromLong(DRIVE_REMOVABLE);
	 PyDict_SetItemString(d,"DRIVE_REMOVABLE", _wrap_python_const_DRIVE_REMOVABLE);
	 _wrap_python_const_DRIVE_FIXED = PyInt_FromLong(DRIVE_FIXED);
	 PyDict_SetItemString(d,"DRIVE_FIXED", _wrap_python_const_DRIVE_FIXED);
	 _wrap_python_const_DRIVE_REMOTE = PyInt_FromLong(DRIVE_REMOTE);
	 PyDict_SetItemString(d,"DRIVE_REMOTE", _wrap_python_const_DRIVE_REMOTE);
	 _wrap_python_const_DRIVE_CDROM = PyInt_FromLong(DRIVE_CDROM);
	 PyDict_SetItemString(d,"DRIVE_CDROM", _wrap_python_const_DRIVE_CDROM);
	 _wrap_python_const_DRIVE_RAMDISK = PyInt_FromLong(DRIVE_RAMDISK);
	 PyDict_SetItemString(d,"DRIVE_RAMDISK", _wrap_python_const_DRIVE_RAMDISK);
	 _wrap_python_const_FILE_TYPE_UNKNOWN = PyInt_FromLong(FILE_TYPE_UNKNOWN);
	 PyDict_SetItemString(d,"FILE_TYPE_UNKNOWN", _wrap_python_const_FILE_TYPE_UNKNOWN);
	 _wrap_python_const_FILE_TYPE_DISK = PyInt_FromLong(FILE_TYPE_DISK);
	 PyDict_SetItemString(d,"FILE_TYPE_DISK", _wrap_python_const_FILE_TYPE_DISK);
	 _wrap_python_const_FILE_TYPE_CHAR = PyInt_FromLong(FILE_TYPE_CHAR);
	 PyDict_SetItemString(d,"FILE_TYPE_CHAR", _wrap_python_const_FILE_TYPE_CHAR);
	 _wrap_python_const_FILE_TYPE_PIPE = PyInt_FromLong(FILE_TYPE_PIPE);
	 PyDict_SetItemString(d,"FILE_TYPE_PIPE", _wrap_python_const_FILE_TYPE_PIPE);
	 _wrap_python_const_MOVEFILE_COPY_ALLOWED = PyInt_FromLong(MOVEFILE_COPY_ALLOWED);
	 PyDict_SetItemString(d,"MOVEFILE_COPY_ALLOWED", _wrap_python_const_MOVEFILE_COPY_ALLOWED);
	 _wrap_python_const_MOVEFILE_DELAY_UNTIL_REBOOT = PyInt_FromLong(MOVEFILE_DELAY_UNTIL_REBOOT);
	 PyDict_SetItemString(d,"MOVEFILE_DELAY_UNTIL_REBOOT", _wrap_python_const_MOVEFILE_DELAY_UNTIL_REBOOT);
	 _wrap_python_const_MOVEFILE_REPLACE_EXISTING = PyInt_FromLong(MOVEFILE_REPLACE_EXISTING);
	 PyDict_SetItemString(d,"MOVEFILE_REPLACE_EXISTING", _wrap_python_const_MOVEFILE_REPLACE_EXISTING);
	 _wrap_python_const_MOVEFILE_WRITE_THROUGH = PyInt_FromLong(MOVEFILE_WRITE_THROUGH);
	 PyDict_SetItemString(d,"MOVEFILE_WRITE_THROUGH", _wrap_python_const_MOVEFILE_WRITE_THROUGH);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_LONG",0);
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_BOOLAPI","_BOOL",0);
	 SWIG_RegisterMapping("_BOOLAPI","_unsigned_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_signed_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_int",0);
	 SWIG_RegisterMapping("_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_long","_ULONG",0);
	 SWIG_RegisterMapping("_long","_LONG",0);
	 SWIG_RegisterMapping("_long","_DWORD",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_LPCTSTR","_char_p",0);
	 SWIG_RegisterMapping("_LPCTSTR","_LPCSTR",0);
	 SWIG_RegisterMapping("_ULONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_ULONG","_long",0);
	 SWIG_RegisterMapping("_ULONG","_DWORD",0);
	 SWIG_RegisterMapping("_ULONG","_LONG",0);
	 SWIG_RegisterMapping("_WORD","_unsigned_short",0);
	 SWIG_RegisterMapping("_WORD","_short",0);
	 SWIG_RegisterMapping("_LPCSTR","_LPCTSTR",0);
	 SWIG_RegisterMapping("_LPCSTR","_char_p",0);
	 SWIG_RegisterMapping("_char_p","_LPCTSTR",0);
	 SWIG_RegisterMapping("_char_p","_LPCSTR",0);
	 SWIG_RegisterMapping("_unsigned_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_ULONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_LONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_BOOL","_BOOLAPI",0);
	 SWIG_RegisterMapping("_BOOL","_int",0);
	 SWIG_RegisterMapping("_BOOL","_signed_int",0);
	 SWIG_RegisterMapping("_BOOL","_unsigned_int",0);
	 SWIG_RegisterMapping("_signed_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_signed_int","_BOOL",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_WORD",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_DWORD","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_ULONG",0);
	 SWIG_RegisterMapping("_DWORD","_LONG",0);
	 SWIG_RegisterMapping("_DWORD","_unsigned_long",0);
	 SWIG_RegisterMapping("_DWORD","_long",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_LONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_ULONG",0);
	 SWIG_RegisterMapping("_LONG","_long",0);
	 SWIG_RegisterMapping("_LONG","_signed_long",0);
	 SWIG_RegisterMapping("_LONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_LONG","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOL",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_WORD",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_int","_BOOL",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
