/*
 * FILE : win32evtlog.cpp
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 -3
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initwin32evtlog

#define SWIG_name    "win32evtlog"

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                            
        if (!PyTuple_Check(target)) {   
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}

#include "windows.h"
#include "winbase.h"
#include "PyWinTypes.h"
#include "tchar.h"
typedef BOOL  BOOLAPI;

typedef HANDLE INT_HANDLE;


#include <structmember.h>

// @object PyEventLogRecord|An object containing the data in an EVENTLOGRECORD.
class PyEventLogRecord : public PyObject
{
public:
	PyEventLogRecord(EVENTLOGRECORD *pEvt);
	~PyEventLogRecord(void);

	static void deallocFunc(PyObject *ob);

	static PyObject *getattr(PyObject *self, char *name);
	static int setattr(PyObject *self, char *name, PyObject *v);
//#pragma warning( disable : 4251 )
	static struct memberlist memberlist[];
//#pragma warning( default : 4251 )

protected:
	DWORD Reserved;
	DWORD RecordNumber;
	PyObject *TimeGenerated;
	PyObject * TimeWritten;
	DWORD EventID;
	WORD EventType;
	PyObject *SourceName;
	PyObject *StringInserts;
	WORD EventCategory;
	WORD ReservedFlags;
	DWORD ClosingRecordNumber;
	PyObject *Sids;
	PyObject *Data;
	PyObject *ComputerName;
};

/*
PyObject *PyWinMethod_NewEventLogRecord(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args, ":EventLogRecord"))
		return NULL;
	return new PyEventLogRecord();
}
*/

PyTypeObject PyEventLogRecordType =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PyEventLogRecord",
	sizeof(PyEventLogRecord),
	0,
	PyEventLogRecord::deallocFunc,		/* tp_dealloc */
	0,		/* tp_print */
	PyEventLogRecord::getattr,				/* tp_getattr */
	PyEventLogRecord::setattr,				/* tp_setattr */
	0,	/* tp_compare */
	0,						/* tp_repr */
	0,						/* tp_as_number */
	0,	/* tp_as_sequence */
	0,						/* tp_as_mapping */
	0,
	0,						/* tp_call */
	0,		/* tp_str */
};

#define OFF(e) offsetof(PyEventLogRecord, e)

/*static*/ struct memberlist PyEventLogRecord::memberlist[] = {
	{"Reserved",           T_INT,     OFF(Reserved)}, // @property integer|PyEventLogRecord|Reserved|
	{"RecordNumber",       T_INT,	  OFF(RecordNumber)}, // @property integer|PyEventLogRecord|RecordNumber|
	{"TimeGenerated",      T_OBJECT,  OFF(TimeGenerated)}, // @property <o PyTime>|PyEventLogRecord|TimeGenerated|
	{"TimeWritten",        T_OBJECT,  OFF(TimeWritten)}, // @property <o PyTime>|PyEventLogRecord|TimeWritten|
	{"EventID",            T_INT,	  OFF(EventID)}, // @property integer|PyEventLogRecord|EventID|
	{"EventType",          T_SHORT,	  OFF(EventType)}, // @property integer|PyEventLogRecord|EventType|
	{"EventCategory",      T_SHORT,   OFF(EventCategory)}, // @property integer|PyEventLogRecord|EventCategory|
	{"ReservedFlags",      T_SHORT,   OFF(ReservedFlags)}, // @property integer|PyEventLogRecord|ReservedFlags|
	{"ClosingRecordNumber",T_INT,     OFF(ClosingRecordNumber)}, // @property integer|PyEventLogRecord|ClosingRecordNumber|
	{"SourceName",         T_OBJECT,  OFF(SourceName)}, // @property <o PyUnicode>|PyEventLogRecord|SourceName|
	{"StringInserts",      T_OBJECT,  OFF(StringInserts)}, // @property (<o PyUnicode>,...)|PyEventLogRecord|StringInserts|
	{"Sids",               T_OBJECT,  OFF(Sids)}, // @property <o PySIDS>|PyEventLogRecord|Sids|
	{"Data",               T_OBJECT,  OFF(Data)}, // @property string|PyEventLogRecord|Data|
	{"ComputerName",       T_OBJECT,  OFF(ComputerName)}, // @property <o PyUnicode>|PyEventLogRecord|ComputerName|
	{NULL}
};

PyEventLogRecord::PyEventLogRecord(EVENTLOGRECORD *pEvt)
{
	ob_type = &PyEventLogRecordType;
	_Py_NewReference(this);
	Reserved = RecordNumber = EventID = ClosingRecordNumber = 0;
	TimeWritten = TimeGenerated = SourceName = ComputerName = StringInserts = Sids = Data = NULL;
	EventType = EventCategory = ReservedFlags = 0;
	if (pEvt==NULL) // Empty one.
		return;

	Reserved = pEvt->Reserved;
	RecordNumber = pEvt->RecordNumber;
	EventID = pEvt->EventID;
	EventType = pEvt->EventType;
	EventCategory = pEvt->EventCategory;
	ReservedFlags = pEvt->ReservedFlags;
	ClosingRecordNumber = pEvt->ClosingRecordNumber;

	if (pEvt->NumStrings==0) {
		StringInserts = Py_None;
		Py_INCREF(Py_None);
	} else {
		StringInserts = PyTuple_New(pEvt->NumStrings);
		if (StringInserts) {
			WCHAR *stringOffset = (WCHAR *) (((BYTE *)pEvt) + pEvt->StringOffset);
			for (DWORD stringNo = 0;stringNo<pEvt->NumStrings;stringNo++) {
				PyTuple_SET_ITEM( StringInserts, (int)stringNo, PyWinObject_FromWCHAR(stringOffset));
				stringOffset = stringOffset + (wcslen(stringOffset)) + 1;
			}
		}
	}

	TimeGenerated = PyWinTimeObject_FromLong(pEvt->TimeGenerated);
	TimeWritten = PyWinTimeObject_FromLong(pEvt->TimeWritten);

	Sids = Py_None; // Till we support em!
	Py_INCREF(Sids);

	Data = PyString_FromStringAndSize(((char *)pEvt)+pEvt->DataOffset, pEvt->DataLength);

	WCHAR *szSourceName = (WCHAR *)(((BYTE *)pEvt) + sizeof(EVENTLOGRECORD));
	SourceName = PyWinObject_FromWCHAR(szSourceName);

	ComputerName = PyWinObject_FromWCHAR(szSourceName + wcslen(szSourceName) + 1);
}

PyEventLogRecord::~PyEventLogRecord(void)
{
	Py_XDECREF(TimeWritten);
	Py_XDECREF(TimeGenerated);
	Py_XDECREF(SourceName);
	Py_XDECREF(StringInserts);
	Py_XDECREF(Sids);
	Py_XDECREF(Data);
	Py_XDECREF(ComputerName);
}

PyObject *PyEventLogRecord::getattr(PyObject *self, char *name)
{
	return PyMember_Get((char *)self, memberlist, name);
}

int PyEventLogRecord::setattr(PyObject *self, char *name, PyObject *v)
{
	if (v == NULL) {
		PyErr_SetString(PyExc_AttributeError, "can't delete EventLogRecord attributes");
		return -1;
	}
	return PyMember_Set((char *)self, memberlist, name, v);
}

/*static*/ void PyEventLogRecord::deallocFunc(PyObject *ob)
{
	delete (PyEventLogRecord *)ob;
}

PyObject *MakeEventLogObject( BYTE *buf, DWORD numBytes )
{
	PyObject *ret = PyList_New(0);
	if (ret==NULL) return NULL;
	while (numBytes>0) {
		EVENTLOGRECORD *pEvt = (EVENTLOGRECORD *)buf;
/***		PyObject *stringsObject;
		if (pEvt->NumStrings==0) {
			stringsObject = Py_None;
			Py_INCREF(Py_None);
		} else {
			stringsObject = PyTuple_New(pEvt->NumStrings);
			if (stringsObject==NULL) {
				Py_DECREF(ret);
				return NULL;
			}
			WCHAR *stringOffset = (WCHAR *) (((BYTE *)pEvt) + pEvt->StringOffset);
			for (DWORD stringNo = 0;stringNo<pEvt->NumStrings;stringNo++) {
				PyTuple_SET_ITEM( stringsObject, (int)stringNo, PyWinObject_FromWCHAR(stringOffset));
				stringOffset = stringOffset + (wcslen(stringOffset)) + 1;
			}
		}
		PyObject *obSids = Py_None; // Till we support em!
		Py_INCREF(obSids);
		PyObject *obData = PyString_FromStringAndSize((char *)buf+pEvt->DataOffset, pEvt->DataLength);
		WCHAR *sourceName = (WCHAR *)(((BYTE *)buf) + sizeof(EVENTLOGRECORD));
		PyObject *obSourceName = PyWinObject_FromWCHAR(sourceName);
		PyObject *subItem = Py_BuildValue("llllliOOiilOO",
			pEvt->Reserved,
			pEvt->RecordNumber,
			pEvt->TimeGenerated,
			pEvt->TimeWritten,
			pEvt->EventID,
			pEvt->EventType,
			obSourceName,
			stringsObject,
			pEvt->EventCategory,
			pEvt->ReservedFlags,
			pEvt->ClosingRecordNumber,
			obSids,
			obData);
		Py_XDECREF(obSourceName);
		Py_XDECREF(obData);
		Py_XDECREF(obSids);
		Py_XDECREF(stringsObject);
***/
		PyObject *subItem = new PyEventLogRecord(pEvt);
		if (subItem==NULL) {
			Py_DECREF(ret);
			PyErr_SetString(PyExc_MemoryError, "Allocating EventLogRecord object");
			return NULL;
		}
		PyList_Append(ret, subItem);
		Py_DECREF(subItem);
		buf = buf + pEvt->Length;
		numBytes -= pEvt->Length;
	}
	return ret;
}

PyObject *MyReadEventLog( HANDLE hEventLog, DWORD dwReadFlags, DWORD dwRecordOffset)
{
	DWORD needed, read;
	needed = 1024;
	BYTE *buf;
	while (1) {
		buf = (BYTE *)malloc(needed);
		if (buf==NULL) {
			PyErr_SetString(PyExc_MemoryError, "Allocating initial buffer");
			return NULL;
		}
		if (!ReadEventLogW(hEventLog, dwReadFlags, dwRecordOffset, buf, needed, &read, &needed)) {
			DWORD err = GetLastError();
			if (err==ERROR_HANDLE_EOF) {
				read = 0;// pretend everything is OK...
				break;
			}
			else if (err==ERROR_INSUFFICIENT_BUFFER) {
				free(buf);
				continue; // try again.
			} else {
				free(buf);
				return PyWin_SetAPIError("ReadEventLog");
			}
		}
		else
			break;
	}
	// Convert the object.
	PyObject *ret = MakeEventLogObject(buf, read);
	free(buf);
	return ret;
}

PyObject * MyReportEvent( HANDLE hEventLog,
    WORD wType,	// event type to log 
    WORD wCategory,	// event category 
    DWORD dwEventID,	// event identifier
    PyObject *obSID,    // user security identifier object (optional)
    PyObject *obStrings,  // insert strings
    PyObject *obData)     // raw data
{
	PyObject *rc = NULL;
	WORD numStrings = 0;
	BSTR *pStrings = NULL;
	int i;
	DWORD dataSize = 0;
	char *pData;
	if (obSID != Py_None) {
		PyErr_SetString(PyExc_TypeError, "Only None is supported for SID");
		return NULL;
	}
	if (obStrings==Py_None) {
		pStrings = NULL;
	} else if (PySequence_Check(obStrings)) {
		numStrings = PySequence_Length(obStrings);
		pStrings = new BSTR [numStrings];
		if (pStrings==NULL) {
			PyErr_SetString(PyExc_MemoryError, "Allocating string arrays");
			goto cleanup;
		}
		memset(pStrings, 0, sizeof(BSTR *)*numStrings);
		for (i=0;i<numStrings;i++) {
			PyObject *obString = PySequence_GetItem(obStrings, i);
			if (obString==NULL) {
				goto cleanup;
			}
			BOOL ok = PyWinObject_AsBstr(obString, pStrings+i);
			Py_XDECREF(obString);
			if (!ok)
				goto cleanup;
		}
	} else {
		PyErr_SetString(PyExc_TypeError, "strings must be None or a sequence");
		goto cleanup;
	}
	if (obData==Py_None)
		pData = NULL;
	else if (PyString_Check(obData)){
		pData = PyString_AsString(obData);
		dataSize = PyString_Size(obData);
	} else {
		PyErr_SetString(PyExc_TypeError, "data must be None or a string");
		return NULL;
	}
	if (!ReportEventW(hEventLog, wType, wCategory,	dwEventID, NULL, numStrings, dataSize, (const WCHAR **)pStrings, pData)) {
		PyWin_SetAPIError("ReportEvent");
		goto cleanup;
	}
	Py_INCREF(Py_None);
	rc = Py_None;
cleanup:
	if (pStrings) {
		for (i=0;i<numStrings;i++)
			SysFreeString(pStrings[i]);
		delete [] pStrings;
	}
	return rc;
}

static PyObject *_wrap_python_const_EVENTLOG_FORWARDS_READ;
static PyObject *_wrap_python_const_EVENTLOG_BACKWARDS_READ;
static PyObject *_wrap_python_const_EVENTLOG_SEEK_READ;
static PyObject *_wrap_python_const_EVENTLOG_SEQUENTIAL_READ;
static PyObject *_wrap_python_const_EVENTLOG_SUCCESS;
static PyObject *_wrap_python_const_EVENTLOG_ERROR_TYPE;
static PyObject *_wrap_python_const_EVENTLOG_WARNING_TYPE;
static PyObject *_wrap_python_const_EVENTLOG_INFORMATION_TYPE;
static PyObject *_wrap_python_const_EVENTLOG_AUDIT_SUCCESS;
static PyObject *_wrap_python_const_EVENTLOG_AUDIT_FAILURE;
static PyObject *_wrap_python_const_EVENTLOG_START_PAIRED_EVENT;
static PyObject *_wrap_python_const_EVENTLOG_END_PAIRED_EVENT;
static PyObject *_wrap_python_const_EVENTLOG_END_ALL_PAIRED_EVENTS;
static PyObject *_wrap_python_const_EVENTLOG_PAIRED_EVENT_ACTIVE;
static PyObject *_wrap_python_const_EVENTLOG_PAIRED_EVENT_INACTIVE;
static PyObject *_wrap_ClearEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    WCHAR * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OO:ClearEventLog",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	// Wide string code!
	if (!PyWinObject_AsBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )ClearEventLogW(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	// Wide string cleanup
	SysFreeString(_arg1);
}

           return PyWin_SetAPIError("ClearEventLogW");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	// Wide string cleanup
	SysFreeString(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_BackupEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    WCHAR * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
	_arg1 = NULL;
}
    if(!PyArg_ParseTuple(args,"OO:BackupEventLog",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	// Wide string code!
	if (!PyWinObject_AsBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )BackupEventLogW(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           {
	// Wide string cleanup
	SysFreeString(_arg1);
}

           return PyWin_SetAPIError("BackupEventLogW");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
	// Wide string cleanup
	SysFreeString(_arg1);
}
    return _resultobj;
}

static PyObject *_wrap_CloseEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:CloseEventLog",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )CloseEventLog(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("CloseEventLog");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_DeregisterEventSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:DeregisterEventSource",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )DeregisterEventSource(_arg0);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("DeregisterEventSource");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_NotifyChangeEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    HANDLE  _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:NotifyChangeEventLog",&_obj0,&_obj1)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
	if (!PyWinObject_AsHANDLE(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )NotifyChangeEventLog(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("NotifyChangeEventLog");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_GetNumberOfEventLogRecords(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    PyObject * _obj0 = 0;

    self = self;
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:GetNumberOfEventLogRecords",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )GetNumberOfEventLogRecords(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("GetNumberOfEventLogRecords");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_GetOldestEventLogRecord(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    BOOLAPI  _result;
    HANDLE  _arg0;
    unsigned long * _arg1;
    unsigned long  temp;
    PyObject * _obj0 = 0;

    self = self;
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"O:GetOldestEventLogRecord",&_obj0)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (BOOLAPI )GetOldestEventLogRecord(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (!_result)  {
           
           return PyWin_SetAPIError("GetOldestEventLogRecord");
      }
}{
	_resultobj = Py_None;
	Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    if (!_resultobj) {
      _resultobj = o;
    } else if (_resultobj == Py_None) {
      Py_DECREF(Py_None);
      _resultobj = o;
    } else {
      if (!PyList_Check(_resultobj)) {
	PyObject *o2 = _resultobj;
	_resultobj = PyList_New(0);
	PyList_Append(_resultobj,o2);
	Py_XDECREF(o2);
      }
      PyList_Append(_resultobj,o);
      Py_XDECREF(o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_OpenEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HANDLE  _result;
    PyWin_AutoFreeBstr  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OpenEventLog",&_obj0,&_obj1)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj0, &_arg0, TRUE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HANDLE )OpenEventLogW(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (_result==0 || _result==INVALID_HANDLE_VALUE)  {
           
           return PyWin_SetAPIError("OpenEventLogW");
      }
}{
  _resultobj = PyWinObject_FromHANDLE(_result);
}
    return _resultobj;
}

static PyObject *_wrap_RegisterEventSource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HANDLE  _result;
    PyWin_AutoFreeBstr  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:RegisterEventSource",&_obj0,&_obj1)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj0, &_arg0, TRUE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HANDLE )RegisterEventSourceW(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (_result==0 || _result==INVALID_HANDLE_VALUE)  {
           
           return PyWin_SetAPIError("RegisterEventSourceW");
      }
}{
  _resultobj = PyWinObject_FromHANDLE(_result);
}
    return _resultobj;
}

static PyObject *_wrap_OpenBackupEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    HANDLE  _result;
    PyWin_AutoFreeBstr  _arg0;
    PyWin_AutoFreeBstr  _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:OpenBackupEventLog",&_obj0,&_obj1)) 
        return NULL;
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj0, &_arg0, TRUE))
		return NULL;
}
{
	// Auto-free Wide string code!
	if (!PyWinObject_AsAutoFreeBstr(_obj1, &_arg1, FALSE))
		return NULL;
}
{
      Py_BEGIN_ALLOW_THREADS
          _result = (HANDLE )OpenBackupEventLogW(_arg0,_arg1);

      Py_END_ALLOW_THREADS
      if (_result==0 || _result==INVALID_HANDLE_VALUE)  {
           
           return PyWin_SetAPIError("OpenBackupEventLogW");
      }
}{
  _resultobj = PyWinObject_FromHANDLE(_result);
}
    return _resultobj;
}

static PyObject *_wrap_ReadEventLog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    HANDLE  _arg0;
    DWORD  _arg1;
    DWORD  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oll:ReadEventLog",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
    _result = (PyObject *)MyReadEventLog(_arg0,_arg1,_arg2);
{
	if (_result==NULL) return NULL; // get out now!
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ReportEvent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    HANDLE  _arg0;
    WORD  _arg1;
    WORD  _arg2;
    DWORD  _arg3;
    PyObject * _arg4;
    PyObject * _arg5;
    PyObject * _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj5 = 0;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OhhlOOO:ReportEvent",&_obj0,&_arg1,&_arg2,&_arg3,&_obj4,&_obj5,&_obj6)) 
        return NULL;
{
	if (!PyWinObject_AsHANDLE(_obj0, &_arg0, FALSE))
		return NULL;
}
{
  _arg4 = _obj4;
}
{
  _arg5 = _obj5;
}
{
  _arg6 = _obj6;
}
    _result = (PyObject *)MyReportEvent(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
{
	if (_result==NULL) return NULL; // get out now!
	_resultobj = _result;
}
    return _resultobj;
}

static PyMethodDef win32evtlogMethods[] = {
	 { "ReportEvent", _wrap_ReportEvent, 1 },
	 { "ReadEventLog", _wrap_ReadEventLog, 1 },
	 { "OpenBackupEventLog", _wrap_OpenBackupEventLog, 1 },
	 { "RegisterEventSource", _wrap_RegisterEventSource, 1 },
	 { "OpenEventLog", _wrap_OpenEventLog, 1 },
	 { "GetOldestEventLogRecord", _wrap_GetOldestEventLogRecord, 1 },
	 { "GetNumberOfEventLogRecords", _wrap_GetNumberOfEventLogRecords, 1 },
	 { "NotifyChangeEventLog", _wrap_NotifyChangeEventLog, 1 },
	 { "DeregisterEventSource", _wrap_DeregisterEventSource, 1 },
	 { "CloseEventLog", _wrap_CloseEventLog, 1 },
	 { "BackupEventLog", _wrap_BackupEventLog, 1 },
	 { "ClearEventLog", _wrap_ClearEventLog, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initwin32evtlog)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("win32evtlog", win32evtlogMethods);
	 d = PyModule_GetDict(m);

#ifndef PYCOM_EXPORT
	 PyDict_SetItemString(d,"UNICODE", PyInt_FromLong(
#ifdef UNICODE
	1
#else
	0
#endif
	));
#endif
	 _wrap_python_const_EVENTLOG_FORWARDS_READ = PyInt_FromLong(EVENTLOG_FORWARDS_READ);
	 PyDict_SetItemString(d,"EVENTLOG_FORWARDS_READ", _wrap_python_const_EVENTLOG_FORWARDS_READ);
	 _wrap_python_const_EVENTLOG_BACKWARDS_READ = PyInt_FromLong(EVENTLOG_BACKWARDS_READ);
	 PyDict_SetItemString(d,"EVENTLOG_BACKWARDS_READ", _wrap_python_const_EVENTLOG_BACKWARDS_READ);
	 _wrap_python_const_EVENTLOG_SEEK_READ = PyInt_FromLong(EVENTLOG_SEEK_READ);
	 PyDict_SetItemString(d,"EVENTLOG_SEEK_READ", _wrap_python_const_EVENTLOG_SEEK_READ);
	 _wrap_python_const_EVENTLOG_SEQUENTIAL_READ = PyInt_FromLong(EVENTLOG_SEQUENTIAL_READ);
	 PyDict_SetItemString(d,"EVENTLOG_SEQUENTIAL_READ", _wrap_python_const_EVENTLOG_SEQUENTIAL_READ);
	 _wrap_python_const_EVENTLOG_SUCCESS = PyInt_FromLong(EVENTLOG_SUCCESS);
	 PyDict_SetItemString(d,"EVENTLOG_SUCCESS", _wrap_python_const_EVENTLOG_SUCCESS);
	 _wrap_python_const_EVENTLOG_ERROR_TYPE = PyInt_FromLong(EVENTLOG_ERROR_TYPE);
	 PyDict_SetItemString(d,"EVENTLOG_ERROR_TYPE", _wrap_python_const_EVENTLOG_ERROR_TYPE);
	 _wrap_python_const_EVENTLOG_WARNING_TYPE = PyInt_FromLong(EVENTLOG_WARNING_TYPE);
	 PyDict_SetItemString(d,"EVENTLOG_WARNING_TYPE", _wrap_python_const_EVENTLOG_WARNING_TYPE);
	 _wrap_python_const_EVENTLOG_INFORMATION_TYPE = PyInt_FromLong(EVENTLOG_INFORMATION_TYPE);
	 PyDict_SetItemString(d,"EVENTLOG_INFORMATION_TYPE", _wrap_python_const_EVENTLOG_INFORMATION_TYPE);
	 _wrap_python_const_EVENTLOG_AUDIT_SUCCESS = PyInt_FromLong(EVENTLOG_AUDIT_SUCCESS);
	 PyDict_SetItemString(d,"EVENTLOG_AUDIT_SUCCESS", _wrap_python_const_EVENTLOG_AUDIT_SUCCESS);
	 _wrap_python_const_EVENTLOG_AUDIT_FAILURE = PyInt_FromLong(EVENTLOG_AUDIT_FAILURE);
	 PyDict_SetItemString(d,"EVENTLOG_AUDIT_FAILURE", _wrap_python_const_EVENTLOG_AUDIT_FAILURE);
	 _wrap_python_const_EVENTLOG_START_PAIRED_EVENT = PyInt_FromLong(EVENTLOG_START_PAIRED_EVENT);
	 PyDict_SetItemString(d,"EVENTLOG_START_PAIRED_EVENT", _wrap_python_const_EVENTLOG_START_PAIRED_EVENT);
	 _wrap_python_const_EVENTLOG_END_PAIRED_EVENT = PyInt_FromLong(EVENTLOG_END_PAIRED_EVENT);
	 PyDict_SetItemString(d,"EVENTLOG_END_PAIRED_EVENT", _wrap_python_const_EVENTLOG_END_PAIRED_EVENT);
	 _wrap_python_const_EVENTLOG_END_ALL_PAIRED_EVENTS = PyInt_FromLong(EVENTLOG_END_ALL_PAIRED_EVENTS);
	 PyDict_SetItemString(d,"EVENTLOG_END_ALL_PAIRED_EVENTS", _wrap_python_const_EVENTLOG_END_ALL_PAIRED_EVENTS);
	 _wrap_python_const_EVENTLOG_PAIRED_EVENT_ACTIVE = PyInt_FromLong(EVENTLOG_PAIRED_EVENT_ACTIVE);
	 PyDict_SetItemString(d,"EVENTLOG_PAIRED_EVENT_ACTIVE", _wrap_python_const_EVENTLOG_PAIRED_EVENT_ACTIVE);
	 _wrap_python_const_EVENTLOG_PAIRED_EVENT_INACTIVE = PyInt_FromLong(EVENTLOG_PAIRED_EVENT_INACTIVE);
	 PyDict_SetItemString(d,"EVENTLOG_PAIRED_EVENT_INACTIVE", _wrap_python_const_EVENTLOG_PAIRED_EVENT_INACTIVE);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_signed_long","_LONG",0);
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_BOOLAPI","_BOOL",0);
	 SWIG_RegisterMapping("_BOOLAPI","_unsigned_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_signed_int",0);
	 SWIG_RegisterMapping("_BOOLAPI","_int",0);
	 SWIG_RegisterMapping("_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_long","_ULONG",0);
	 SWIG_RegisterMapping("_long","_LONG",0);
	 SWIG_RegisterMapping("_long","_DWORD",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_LPCTSTR","_char_p",0);
	 SWIG_RegisterMapping("_LPCTSTR","_LPCSTR",0);
	 SWIG_RegisterMapping("_ULONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_ULONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_ULONG","_long",0);
	 SWIG_RegisterMapping("_ULONG","_DWORD",0);
	 SWIG_RegisterMapping("_ULONG","_LONG",0);
	 SWIG_RegisterMapping("_WORD","_unsigned_short",0);
	 SWIG_RegisterMapping("_WORD","_short",0);
	 SWIG_RegisterMapping("_LPCSTR","_LPCTSTR",0);
	 SWIG_RegisterMapping("_LPCSTR","_char_p",0);
	 SWIG_RegisterMapping("_char_p","_LPCTSTR",0);
	 SWIG_RegisterMapping("_char_p","_LPCSTR",0);
	 SWIG_RegisterMapping("_unsigned_long","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_unsigned_long","_ULONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_LONG",0);
	 SWIG_RegisterMapping("_unsigned_long","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_signed_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_unsigned_long",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_DWORD",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_LONG",0);
	 SWIG_RegisterMapping("_INT_HANDLE","_ULONG",0);
	 SWIG_RegisterMapping("_BOOL","_BOOLAPI",0);
	 SWIG_RegisterMapping("_BOOL","_int",0);
	 SWIG_RegisterMapping("_BOOL","_signed_int",0);
	 SWIG_RegisterMapping("_BOOL","_unsigned_int",0);
	 SWIG_RegisterMapping("_signed_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_signed_int","_BOOL",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_WORD",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_DWORD","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_DWORD","_ULONG",0);
	 SWIG_RegisterMapping("_DWORD","_LONG",0);
	 SWIG_RegisterMapping("_DWORD","_unsigned_long",0);
	 SWIG_RegisterMapping("_DWORD","_long",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_LONG","_INT_HANDLE",0);
	 SWIG_RegisterMapping("_LONG","_ULONG",0);
	 SWIG_RegisterMapping("_LONG","_long",0);
	 SWIG_RegisterMapping("_LONG","_signed_long",0);
	 SWIG_RegisterMapping("_LONG","_unsigned_long",0);
	 SWIG_RegisterMapping("_LONG","_DWORD",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_unsigned_int","_BOOL",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_WORD",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_BOOLAPI",0);
	 SWIG_RegisterMapping("_int","_BOOL",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
