// This file contains some hacks for supporting LARGE_INTEGERS.

// The basic strategy is thus:

// @doc

// @object LARGE_INTEGER|A Python object used wherever a COM LARGE_INTEGER is used.
// @comm Please see <om pywintypes.ULARGE_INTEGER> for a description.

// @object ULARGE_INTEGER|A Python object used wherever a COM ULARGE_INTEGER is used.

// @comm When passed into a Python function, this will always be a single object.
// It will either be an integer, or a long integer, depending on the size.
// When passed into a Pythoncom function, either a single integer object or a tuple of
// integers is supported.
// @todo Note that you can not pass a long integer into Pythoncom.  This needs
// to be fixed.  A work around is to pass a (int, int) tuple.

// This code was given to me by Curt Hagenlocher.  It relies on
// internal knowledge of a Python long.

// Hopefully Python will formalise an API for this?

#include "windows.h"
#include "Python.h"
#include "PyWinTypes.h"

//#include <comcat.h>

#include <longintrepr.h>

#define ABS(x) ((x) < 0 ? -(x) : (x))

PyLongObject *PyLong_Normalize(register PyLongObject *v)
{
 int j = ABS(v->ob_size);
 register int i = j;

 while (i > 0 && v->ob_digit[i-1] == 0)
  --i;
 if (i != j)
  v->ob_size = (v->ob_size < 0) ? -(i) : i;
 return v;
}

PyLongObject *alloclongobject(int size)
{
 return PyObject_NEW_VAR(PyLongObject, &PyLong_Type, size);
}

PyObject *PyLong_FromI64(__int64 ival)
{
 int i;

 /* A 64-bit value should fit in 5 'digits' */
 int n = 5;
 PyLongObject *v = alloclongobject(n);
 if (v == NULL)
  return NULL;

 if (ival < 0)
 {
  ival = -ival;
  v->ob_size = -(v->ob_size);
 }

 unsigned __int64 uval = (unsigned __int64)ival;
 for (i = 0; i < n; i++)
 {
  v->ob_digit[i] = (unsigned short)(uval & MASK);
  uval = (uval >> SHIFT);
 }
 v = PyLong_Normalize(v);

 return (PyObject*)v;
}

PyObject *PyLong_FromTwoInts(int hidword, unsigned lodword)
{
 __int64 ival = hidword;
 ival = (ival << 32) + lodword;
 return PyLong_FromI64(ival);
}

BOOL PyWinObject_AsLARGE_INTEGER(PyObject *ob, LARGE_INTEGER *pResult)
{
	if (PyInt_Check(ob)) {
		// 32 bit integer value.
		LISet32(*pResult, PyInt_AsLong(ob));
	} else {
		long hiVal, loVal;
		if (!PyArg_ParseTuple(ob, "ll", &hiVal, &loVal)) {
			PyErr_SetString(PyExc_TypeError, "LARGE_INTEGER must be 'int', or '(int, int)'");
			return FALSE;
		}
		pResult->HighPart = hiVal;
		pResult->LowPart = loVal;
	}
	return TRUE;
}

BOOL PyWinObject_AsULARGE_INTEGER(PyObject *ob, ULARGE_INTEGER *pResult)
{
	if (PyInt_Check(ob)) {
		// 32 bit integer value.
		ULISet32(*pResult, PyInt_AsLong(ob));
	} else {
		long hiVal, loVal;
		if (!PyArg_ParseTuple(ob, "ll", &hiVal, &loVal)) {
			PyErr_SetString(PyExc_TypeError, "ULARGE_INTEGER must be 'int', or '(int, int)'");
			return FALSE;
		}
		pResult->HighPart = hiVal;
		pResult->LowPart = loVal;
	}
	return TRUE;
}
PyObject *PyWinObject_FromLARGE_INTEGER(LARGE_INTEGER &val)
{
	if (val.HighPart==0)
		return PyInt_FromLong(val.LowPart);
	else
		return PyLong_FromTwoInts(val.HighPart, val.LowPart);
}
PyObject *PyWinObject_FromULARGE_INTEGER(ULARGE_INTEGER &val)
{
	if (val.HighPart==0)
		return PyInt_FromLong(val.LowPart);
	else
		return PyLong_FromTwoInts(val.HighPart, val.LowPart);
}

