# A Test Program for pipeTestService.py
#
# Install and start the Pipe Test service, then run this test
# either from the same machine, or from another using the "-s" param.
#
# Eg: pipeTestServiceClient.py -s server_name Hi There
# Should work.

from win32pipe import *
from win32file import *
from win32event import *
import pywintypes
import win32api
import winerror

def GetHPipe(fn, args):
	ret = None
	retryCount = 0
	while retryCount < 8:	# Keep looping until user cancels.
		retryCount = retryCount + 1
		try:
			ret = apply(fn, args)
			break
		except win32api.error, (rc, fnerr, msg):
			if rc==winerror.ERROR_PIPE_BUSY:
				win32api.Sleep(5000)
				continue
			else:
				raise win32api.error, (rc, fnerr, msg)
	if ret is None:
		raise RuntimeError, "Could not make a connection to the server"
	return ret

def testClient(server,msg):
	data = GetHPipe(CallNamedPipe, ("\\\\%s\\pipe\\PyPipeTest" % server, msg, 256, NMPWAIT_WAIT_FOREVER))
	print "Server sent back '%s'" % data

def stressThread(server, numMessages, wait):
	try:
		hPipe = GetHPipe(CreateFile, ("\\\\%s\\pipe\\PyPipeTest" % server, GENERIC_READ | GENERIC_WRITE, 0, None, OPEN_EXISTING, 0, 0))
		for i in xrange(numMessages):
			WriteFile(hPipe, "*" * 255)
			r = ReadFile(hPipe, 512)
		CloseHandle(hPipe)
	finally:
		SetEvent(wait)

def stressTestClient(server, numThreads, numMessages):
	import thread
	thread_waits = []
	for t_num in xrange(numThreads):
		wait = CreateEvent(None, 0, 0, None)
		thread_waits.append(wait)
		thread.start_new_thread(stressThread, (server,numMessages, wait))
	# Wait for all threads to finish.
	WaitForMultipleObjects(thread_waits, 1, INFINITE)
		
def main():
	import sys, getopt, string
	server = "."
	thread_count = 0
	msg_count = 500
	try:
		opts, args = getopt.getopt(sys.argv[1:], 's:t:m:')
		for o,a in opts:
			if o=='-s':
				server = a
			if o=='-m':
				msg_count = string.atoi(a)
			if o=='-t':
				thread_count = string.atoi(a)
		msg = string.join(args)
	except getopt.error, msg:
		print msg
		my_name = os.path.split(argv[0])[1]
		print "Usage: %s [-s server] [-t thread_count=0] [-m msg_count=500] msg ..." % my_name
		print "       Specifying a value for -t will stress test using that many threads."
	testClient(server, msg)
	if thread_count > 0:
		print "Spawning %d threads each sending %d messages..." % (thread_count, msg_count)
		stressTestClient(server, thread_count, msg_count)

if __name__=='__main__':
	main()
