# Kills a process by process name
#
# Uses the Performance Data Helper to locate the PID, then
# kills it.

# Instead of just the PID, this technique allows you to get all sorts of
# information about a running process.

import win32api, win32pdhutil, sys

def doit():
	if len(sys.argv)==1:
		print "Usage: killprocname procname ..."
		return 
	for procname in sys.argv[1:]:
		pids = win32pdhutil.FindPerformanceAttributesByName(procname)
		# If _my_ pid in there, remove it!
		try:
			pids.remove(win32api.GetCurrentProcessId())
		except ValueError:
			pass
		if len(pids)==0:
			print "Cant find %s" % procname
		elif len(pids)>1:
			print "Found too many %s's - pids=`%s`" % (procname, pids)
		else:
			import win32con
			handle = win32api.OpenProcess(win32con.PROCESS_TERMINATE, 0, pids[0])
			win32api.TerminateProcess(handle,0)
			win32api.CloseHandle(handle)
			print "%s killed!" % procname

doit()
