import win32evtlog, traceback
import win32api, win32con

from win32evtlogutil import *

def test():
	# check if running on Windows NT, if not, display notice and terminate
	if win32api.GetVersion() & 0x80000000:
		print "This sample only runs on NT"
		return
	logType = "Application"

	appName = "PyTest"

	dll = win32api.GetModuleFileName(win32api.GetModuleHandle("win32evtlog.pyd"))
	AddSourceToRegistry(appName, dll)

	ReportEvent(appName, 1, strings=["The message text"], data = "Raw\0Data")
	ReportEvent(appName, 2, strings=["The message text for event 2"], data = "Raw\0Data")
	ReportEvent(appName, 1, eventType=win32evtlog.EVENTLOG_WARNING_TYPE, strings=["A warning"], data = "Raw\0Data")
	ReportEvent(appName, 1, eventType=win32evtlog.EVENTLOG_INFORMATION_TYPE, strings=["An info"], data = "Raw\0Data")

	# Now read the entire log back.
	h=win32evtlog.OpenEventLog(None, logType)
	numRecords = win32evtlog.GetNumberOfEventLogRecords(h)
	print "There are %d records" % numRecords
	
	num=0
	while 1:
		objects = win32evtlog.ReadEventLog(h, win32evtlog.EVENTLOG_BACKWARDS_READ|win32evtlog.EVENTLOG_SEQUENTIAL_READ, 0)
		if not objects:
			break
		for object in objects:
			# get it for testing purposes, but dont print it.
			msg = str(SafeFormatMessage(object, logType))
		num = num + len(objects)

	if numRecords != num:
		print "Could get all records - reported %d, but found %d" % (numRecords, num)

	win32evtlog.CloseEventLog(h)

if __name__=='__main__':
	test()

