// win32win.h - support for Python/MFC Windows objects.

// fwd delcare some classes.
class PYW_EXPORT CPythonView;
//
// Window Objects
//
class PYW_EXPORT PyCWnd : public PyCCmdTarget{
public:	// probably shouldnt be, but...
	MAKE_PY_CTOR(PyCWnd)
	CMapWordToPtr *pMessageHookList;
	CMapWordToPtr *pKeyHookList;
	PyObject      *obKeyStrokeHandler;
	BOOL bDidSubclass;

	// ensure that the pointer is permanent
	static PyCWnd *make( ui_type_CObject &makeType, CWnd *pSearch, HWND wnd=NULL );
protected:
	PyCWnd();
	~PyCWnd();
	virtual void DoKillAssoc( BOOL bDestructing = FALSE );
public:
	static CWnd *GetPythonGenericWnd(PyObject *self, ui_type_CObject *pType = &type);
	static PyObject *get_active_window(PyObject *self, PyObject *args);
	static PyObject *get_window(PyObject *self, PyObject *args);
	static PyObject *get_top_window(PyObject *self, PyObject *args);

	static PyObject *FindWindow(PyObject *self, PyObject *args);
	static PyObject *FindWindowEx(PyObject *self, PyObject *args);
	static PyObject *CreateWindowFromHandle(PyObject *self, PyObject *args);
	static PyObject *CreateControl(PyObject *self, PyObject *args);
	static PyObject *GetActiveWindow(PyObject *self, PyObject *args);

	// virtuals for Python support
	virtual CString repr();

	BOOL check_key_stroke(UINT ch);

	static ui_type_CObject type;
};

//
// Hack to get around protected members
//
class CProtectedView : public CView
{
public:
	void SetDocument(CDocument *pDoc) {m_pDocument = pDoc;}
	BOOL BaseOnQueryNewPalette() \
		{return CView::OnQueryNewPalette();}
	void BaseOnActivateView( BOOL bActivate, CView* pActivateView, CView* pDeactiveView ) \
		{CView::OnActivateView(bActivate,pActivateView,pDeactiveView );}
	BOOL BasePreCreateWindow(CREATESTRUCT &cs) {return CView::PreCreateWindow(cs);}
};

//
// views
//
class PYW_EXPORT PyCView : public PyCWnd {
protected:
	PyCView() {}
	~PyCView(){}
public:
	static CView *GetViewPtr(PyObject *self);
	static ui_type_CObject type;
};

class PYW_EXPORT PyCScrollView : public PyCView {
protected:
	PyCScrollView() {}
	~PyCScrollView(){}
public:
	static PyObject *create(PyObject *self, PyObject *args);
	static CPythonView *GetViewPtr(PyObject *self);
	static ui_type_CObject type;
	MAKE_PY_CTOR(PyCScrollView)
};

class PYW_EXPORT PyCFormView : public PyCView {
protected:
public:
	static PyObject *create(PyObject *self, PyObject *args);
	static ui_type_CObject type;
	MAKE_PY_CTOR(PyCFormView)
};

//
// frame windows
//
class PYW_EXPORT PyCFrameWnd : public PyCWnd {
protected:
	PyCFrameWnd() {}
	~PyCFrameWnd(){}
public:
	MAKE_PY_CTOR(PyCFrameWnd)
	static ui_type_CObject type;
};

class PYW_EXPORT PyCMDIFrameWnd : public PyCFrameWnd {
protected:
	PyCMDIFrameWnd() {return;}
public:
	MAKE_PY_CTOR(PyCMDIFrameWnd)
	static ui_type_CObject type;
};

class PYW_EXPORT PyCMDIChildWnd : public PyCFrameWnd {
protected:
	PyCMDIChildWnd() {return;}
public:
	MAKE_PY_CTOR(PyCMDIChildWnd)
//	static PyObject *create(PyObject *self, PyObject *args);
	static ui_type_CObject type;
};

extern PYW_EXPORT CWnd *GetWndPtr(PyObject *);
