/*
  python GDI class

	Access to a CGdiObject.

Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc

*/

#include "stdafx.h"
#include "win32gdi.h"

void *PyCGdiObject::GetGoodCppObject(ui_type *ui_type_check) const
{
	CGdiObject *pGDI = (CGdiObject *)ui_assoc_CObject::GetGoodCppObject(ui_type_check);
	if (pGDI==NULL)
		RETURN_ERR("There is no GDI object associated with the object");
	if (!IsGdiHandleValid(pGDI->m_hObject))
    	RETURN_ERR("The associated object is invalid");
	return pGDI;
}

// utility functions.
// according to MFC2 sources, these pointers are permanent.
CGdiObject *PyCGdiObject::GetGdiObject (PyObject *self, DWORD gtype)
{
	CGdiObject *pGdi = (CGdiObject *)ui_assoc_object::GetGoodCppObject( self, &type);
	if (gtype && !IsWin32s() && pGdi->m_hObject && ::GetObjectType(pGdi->m_hObject) != gtype)
		RETURN_ERR("The associated GDI object is not of the required type");
	return pGdi;
}

void PyCGdiObject::DoKillAssoc( BOOL bDestructing /*= FALSE*/ )
{
  CGdiObject *pGDI;
  if (m_deleteObject && (pGDI = GetGdiObject()))
	{
	  m_deleteObject = FALSE;
	  delete pGDI;
	}
  ui_assoc_object::DoKillAssoc(bDestructing);
}

PyCGdiObject::~PyCGdiObject()
{
  DoKillAssoc(TRUE);
}

CString PyCGdiObject::repr()
{
	return ui_assoc_object::repr() + CString(m_deleteObject ? ", delObject=1" : ", delObject=0");
}

// @object PyCGdiObject|A class which encapsulates an MFC CGdiObject.
static struct PyMethodDef ui_gdi_methods[] = {
	{NULL,			NULL}		// sentinel
};

ui_type_CObject PyCGdiObject::type("gdi object", 
								   &ui_assoc_CObject::type, 
								   RUNTIME_CLASS(CGdiObject), 
								   sizeof(PyCGdiObject), 
								   ui_gdi_methods, 
								   NULL);
