// Pythonview.h : header file
//
#ifndef __PYTHONVIEW_H__
#define __PYTHONVIEW_H__

/////////////////////////////////////////////////////////////////////////////
// CPythonViewTemp
template <class P> class CPythonViewTemp : public P
{
public:
	CPythonViewTemp();
	CPythonViewTemp(UINT);
	CPythonViewTemp(LPCTSTR);
	virtual ~CPythonViewTemp();

	virtual BOOL OnCmdMsg( UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo );
	virtual BOOL OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);

	virtual BOOL OnPreparePrinting (CPrintInfo *pInfo);
	virtual void OnPrepareDC (CDC *pDC, CPrintInfo *pInfo);
	virtual void OnInitialUpdate();
	virtual void OnActivateView( BOOL bActivate, CView* pActivateView, CView* pDeactiveView );
	virtual void OnDraw( CDC *pDC );
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);

	virtual BOOL PreCreateWindow(CREATESTRUCT &cs);

};

class CPythonView : public CPythonViewTemp<CScrollView>
{
	DECLARE_DYNCREATE(CPythonView)
public:
	CPythonView();			// protected constructor used by dynamic creation

// Operations
public:
	virtual BOOL OnPreparePrinting (CPrintInfo *pInfo);
	virtual void OnPrepareDC (CDC *pDC, CPrintInfo *pInfo);
	BOOL SetDynamicScrollBars (BOOL dynamic);
	virtual ~CPythonView();

	// Generated message map functions
	//{{AFX_MSG(CPythonView)
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg void OnPaletteIsChanging(CWnd* pRealizeWnd);
	afx_msg void OnWinIniChange(LPCTSTR lpszSection);
	afx_msg void OnSysColorChange();
	afx_msg BOOL OnQueryNewPalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CPythonListView : public CPythonViewTemp<CListView>
{
	DECLARE_DYNCREATE(CPythonListView)
public:
	CPythonListView();
	~CPythonListView();
// Operations
	virtual void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );

public:
	// Generated message map functions
	//{{AFX_MSG(CPythonListView)
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg void OnPaletteIsChanging(CWnd* pRealizeWnd);
	afx_msg void OnWinIniChange(LPCTSTR lpszSection);
	afx_msg void OnSysColorChange();
	afx_msg BOOL OnQueryNewPalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CPythonTreeView : public CPythonViewTemp<CTreeView>
{
	DECLARE_DYNCREATE(CPythonTreeView)
public:
	CPythonTreeView();
	~CPythonTreeView();
// Operations
	virtual void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );

public:
	// Generated message map functions
	//{{AFX_MSG(CPythonTreeView)
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg void OnPaletteIsChanging(CWnd* pRealizeWnd);
	afx_msg void OnWinIniChange(LPCTSTR lpszSection);
	afx_msg void OnSysColorChange();
	afx_msg BOOL OnQueryNewPalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CPythonFormView : public CPythonViewTemp<CFormView>
{
	DECLARE_DYNCREATE(CPythonFormView)
public:
	CPythonFormView( UINT templ );
	CPythonFormView( LPCTSTR templ );
public:
	// Generated message map functions
	//{{AFX_MSG(CPythonListView)
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg void OnPaletteIsChanging(CWnd* pRealizeWnd);
	afx_msg void OnWinIniChange(LPCTSTR lpszSection);
	afx_msg void OnSysColorChange();
	afx_msg BOOL OnQueryNewPalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif // __filename_h__
/////////////////////////////////////////////////////////////////////////////
