// padview.h : interface of the CPythonEditView class
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// QuickHelp and/or WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.



#ifndef __PADVIEW_H__
#define __PADVIEW_H__

#include <afxdlgs.h>
#include <afxext.h>

class CPythonEditView : public CEditView
{
	DECLARE_DYNCREATE(CPythonEditView)

// Construction
	CPythonEditView();
	BOOL PreCreateWindow(CREATESTRUCT& cs);

// Attributes
public:
	// static init/term...
	static void Initialize();
	static void Terminate();

// Operations
public:
	void SetDocument( CDocument *pDocument );
	// Word wrap...
	BOOL IsWordWrap() const;
	BOOL SetWordWrap(BOOL bWordWrap);

	// Printing...
	virtual void OnInitialUpdate();
	virtual void OnPrint(CDC* pDC, CPrintInfo *pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnScrollTo(CDC* pDC, CPrintInfo* pInfo, POINT point);

// Implementation
public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual void PostNcDestroy();
	virtual BOOL OnCmdMsg( UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo );
	virtual BOOL OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);

protected:
	static BOOL bHaveInit;
	BOOL m_bRecreating;         // ==TRUE during recreation of the window

	static LOGFONT m_lfDefFont;
	static LOGFONT m_lfDefFontOld;
	CFont m_font;

	static LOGFONT m_lfDefPrintFont;
	static LOGFONT m_lfDefPrintFontOld;
	CFont m_fontPrint;

	static UINT m_nDefTabStops;
	static UINT m_nDefTabStopsOld;
	static BOOL m_bDefWordWrap;
	static BOOL m_bDefWordWrapOld;

	UINT m_nPreviewPage;
	CTime m_timeHeader;
	CTime m_timeFooter;

	//{{AFX_MSG(CPythonEditView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSetTabStops();
	afx_msg void OnChooseFont();
	afx_msg void OnUpdateWordWrap(CCmdUI* pCmdUI);
	afx_msg void OnChoosePrintFont();
	afx_msg void OnMirrorDisplayFont();
	afx_msg void OnUpdateMirrorDisplayFont(CCmdUI* pCmdUI);
	afx_msg void OnUpdateChoosePrintFont(CCmdUI* pCmdUI);
	afx_msg void OnPageSetup();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif  // __PADVIEW_H__

/////////////////////////////////////////////////////////////////////////////
