// pythondlg.cpp : implementation file
//
// Note that this source file contains embedded documentation.
// This documentation consists of marked up text inside the
// C comments, and is prefixed with an '@' symbol.  The source
// files are processed by a tool called "autoduck" which
// generates Windows .hlp files.
// @doc

#include "stdafx.h"
#include "pythonwin.h"
#include "pythondlg.h"

#include "win32ui.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonDlg dialog
IMPLEMENT_DYNAMIC(CPythonDlg, CDialog);

CPythonDlg::CPythonDlg()
	: CDialog()
{
	//{{AFX_DATA_INIT(CPythonDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}
CPythonDlg::~CPythonDlg()
{
// currently this is deleted by Python object going out of scope.
//	Python_delete_assoc( this );
}
void CPythonDlg::PostNcDestroy(void)
{
}
void CPythonDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	Python_do_exchange( this, pDX );
	//{{AFX_DATA_MAP(CPythonDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

void CPythonDlg::OnOK()
{
	// @pyvirtual int|PyCDialog|OnOK|Called by the MFC architecture when the user selects the OK button.
	// @comm The procedure is expected to dismiss the window with the <om PyCDialog.EndDialog> method.
	// The base implementation (which dismisses the dialog) is not called if a handler exists.  This can be
	// done via <om PyCDialog.OnOK>.
	// @xref <om PyCDialog.OnOK>
	CVirtualHelper helper( "OnOK", this );
	if (!helper.HaveHandler()) {
		if (m_lpDialogTemplate == NULL && m_hDialogTemplate == NULL)
			// non modal dialog.
			DestroyWindow();
		else
			CDialog::OnOK();
	} else {
		helper.call();
	}
}

BOOL CPythonDlg::OnInitDialog()
{
	// @pyvirtual int|PyCDialog|OnInitDialog|Override to augment dialog-box initialization.
	// @comm The base implementation is not called if a handler exists.  This can be
	// done via <om PyCDialog.OnInitDialog>.
	// @xref <om PyCDialog.OnInitDialog>
	BOOL result = FALSE;
	CVirtualHelper helper( "OnInitDialog", this );
	if (!helper.HaveHandler()) {
		result = CDialog::OnInitDialog();
	} else {
		if (helper.call())
			helper.retval(result);
	}
	return result;
	// @rdesc Specifies whether the application has set the input focus to 
	// one of the controls in the dialog box. If OnInitDialog returns 
	// nonzero, Windows sets the input focus to the first control 
	// in the dialog box. The application can return 0/None only if 
	// it has explicitly set the input focus to one of the controls in the 
	// dialog box.
}

void CPythonDlg::OnCancel()
{
	// @pyvirtual int|PyCDialog|OnCancel|Called by the MFC architecture when the user selects the Cancel button.
	// @comm The procedure is expected to dismiss the window with the <om PyCDialog.EndDialog> method.
	// The base implementation (which dismisses the dialog) is not called if a handler exists.  This can be
	// done via <om PyCDialog.OnCancel>.
	// @xref <om PyCDialog.OnCancel>
	CVirtualHelper helper( "OnCancel", this );
	BOOL bCallDefault;
	if (!helper.HaveHandler()) {
		bCallDefault = TRUE;
	} else {
		bCallDefault = !helper.call(); // DO call default on exception, else dialog may never come down!
	}
	if (bCallDefault) {
		if (m_lpDialogTemplate == NULL && m_hDialogTemplate == NULL)
			DestroyWindow();
		else
			CDialog::OnCancel();
	}
}

BOOL
CPythonDlg::OnCmdMsg (UINT nID, int nCode,
			   void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo)
{
  // yield to Python first
  if (Python_OnCmdMsg (this, nID, nCode, pExtra, pHandlerInfo))
    return TRUE;
  else
    return CDialog::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
}

BOOL 
CPythonDlg::OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
  // yield to Python first
  if (Python_OnNotify (this, wParam, lParam, pResult))
    return TRUE;
  else
    return CDialog::OnNotify (wParam, lParam, pResult);
}

LRESULT CPythonDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// @pyvirtual int|PyCDialog|WindowProc|Default message handler.
	// @xref <om PyCDialog.WindowProc>
	LRESULT res;
	CVirtualHelper helper( "WindowProc", this );
	if (!helper.HaveHandler() || !helper.call(message, wParam, lParam) || !helper.retval(res))
		return CDialog::WindowProc(message, wParam, lParam);
	return res;
}

BEGIN_MESSAGE_MAP(CPythonDlg, CDialog)
	//{{AFX_MSG_MAP(CPythonDlg)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPythonDlg message handlers

BOOL CPythonDlg::OnEraseBkgnd(CDC* pDC) 
{
	// @pyvirtual tuple|PyCDialog|OnEraseBkgnd|Called for the WN_ERASEBACKGROUND message.
	// @xref <om PyCDialog.OnEraseBkgnd>
	CVirtualHelper helper( "OnEraseBkgnd", this );
	if (!helper.HaveHandler())
		return CDialog::OnEraseBkgnd(pDC);
	BOOL bRet;
	helper.call(pDC);
	helper.retval(bRet);
	return bRet;
}

void CPythonDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// @pyvirtual tuple|PyCDialog|OnPaint|Called when the dialog should be drawn.
	CVirtualHelper helper( "OnPaint", this );
	// @pyparm <o PyCDC>|dc||The DC object.
	helper.call(&dc);
	// Do not call CDialog::OnPaint() for painting messages
}

HCURSOR CPythonDlg::OnQueryDragIcon() 
{
	// @pyvirtual tuple|PyCDialog|OnQueryDragIcon|Called for the WN_QUERYDRAGICON message.
	// @xref <om PyCDialog.OnQueryDragIcon>
	CVirtualHelper helper( "OnQueryDragIcon", this );
	if (!helper.HaveHandler())
		return CDialog::OnQueryDragIcon();
	int ret;
	helper.call();
	helper.retval(ret);
	return (HCURSOR)ret;
}
