# The MFCish window classes.
import object
import win32ui
import win32con

class Wnd(object.CmdTarget):
	def __init__(self, initobj):
		object.CmdTarget.__init__(self, initobj)
		if self._obj_: self._obj_.HookMessage(self.OnDestroy, win32con.WM_DESTROY)
	def OnDestroy(self, msg):
		pass

# Note - to process all messages for your window, add the following method
# to a derived class.  This code provides default message handling (ie, is
# identical, except presumably in speed, as if the method did not exist at
# all, so presumably will be modified to test for specific messages to be 
# useful!
#	def WindowProc(self, msg, wParam, lParam):
#		rc, lResult = self._obj_.OnWndMsg(msg, wParam, lParam)
#		if not rc: lResult = self._obj_.DefWindowProc(msg, wParam, lParam)
#		return lResult

class FrameWnd(Wnd):
	def __init__(self, wnd):
		Wnd.__init__(self, wnd)

class MDIChildWnd(FrameWnd):
	def __init__(self, template, doc):
		wnd=template._obj_.CreateNewFrame(doc)
		FrameWnd.__init__(self, wnd)
	def OnCreateClient(self, cp, context):
		context.template.CreateView(self, context)

class MDIFrameWnd(FrameWnd):
	def __init__(self):
		wnd=win32ui.CreateMDIFrame()
		FrameWnd.__init__(self, wnd)
		self.HookMessage(self.OnDestroy, win32con.WM_DESTROY)
