// Win32uiHostGlue.h : Defines a connection between win32ui and its

class Win32uiHostGlue : public CObject {
public:
	Win32uiHostGlue();
	~Win32uiHostGlue();

#ifndef LINK_WITH_WIN32UI
	// This will dynamically attach to win32ui.pyd.
	BOOL DynamicApplicationInit(const char *cmd = NULL, const char *additionalPaths = NULL);
#else
	BOOL ApplicationInit(const char *cmd = NULL, const char *additionalPaths = NULL);
#endif
	// These are called by Win32ui at the relevant time.
	virtual const char *RegisterInstanceHandler( char * /*cmdPrefix*/, HWND /*hWnd*/ )
		{return NULL;} // error message or null.
	// placeholder in case application want to provide custom status text.
	virtual void SetStatusText(const char * /*cmd*/, int /*bForce*/) {return;}
	// Helper class, to register _any_ HMODULE as a module name.
	// This allows modules built into .EXE's, or in differently
	// named DLL's etc.  This requires admin priveliges on some machines, so
	// a program should not refuse to start if this fails, but calling it
	// each time means the app is guaranteed to work when moved.
	BOOL RegisterModule(HMODULE hModule, const char *moduleName);
	// or if you know the file name
	BOOL RegisterModule(const char *fileName, const char *moduleName);

	// These must be called by Host Application at the relevant time.
	BOOL InitInstance(void) 
		{return pfnInitInstance ? (*pfnInitInstance)() : FALSE;}
	int ExitInstance(void) \
		{return pfnExitInstance ? (*pfnExitInstance)() : -1;}
	BOOL OnCmdMsg(CCmdTarget *pT, UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo ) \
		{return pfnOnCmdMsg ? (*pfnOnCmdMsg)(pT, nID, nCode, pExtra, pHandlerInfo) : FALSE;}	
	BOOL PreTranslateMessage(MSG *pMsg) \
		{return pfnPreTranslateMessage ? (*pfnPreTranslateMessage)(pMsg) : FALSE;}
	BOOL OnIdle( LONG lCount ) \
		{return pfnOnIdle ? (*pfnOnIdle)(lCount) : FALSE;}

	BOOL OnInstanceHandler( char *cmd ) \
		{return pfnOnInstanceHandler ? (*pfnOnInstanceHandler)(cmd) : FALSE;}

	// some helpers for this class.
	HKEY GetRegistryRootKey();

	// function pointers.
	BOOL (*pfnInitInstance)(void);
	int (*pfnExitInstance)(void);
	BOOL (*pfnOnCmdMsg)(CCmdTarget *, UINT, int, void*, AFX_CMDHANDLERINFO* );
	BOOL (*pfnPreTranslateMessage)(MSG *pMsg);
	BOOL (*pfnOnIdle)( LONG lCount );
	BOOL (*pfnOnInstanceHandler)( char *cmd );
};

inline 	Win32uiHostGlue::Win32uiHostGlue()
{
	pfnInitInstance = NULL;
	pfnExitInstance = NULL;
	pfnOnCmdMsg = NULL;
	pfnPreTranslateMessage = NULL;
	pfnOnIdle = NULL;
	pfnOnInstanceHandler = NULL;
}
inline 	Win32uiHostGlue::~Win32uiHostGlue()
{
}

inline HKEY Win32uiHostGlue::GetRegistryRootKey()
{
	// different for win32s.
	OSVERSIONINFO ver;
	ver.dwOSVersionInfoSize = sizeof(ver);
	GetVersionEx(&ver);
	return ver.dwPlatformId == VER_PLATFORM_WIN32s ? HKEY_CLASSES_ROOT : HKEY_LOCAL_MACHINE;
}

inline BOOL Win32uiHostGlue::RegisterModule(HMODULE hModule, const char *moduleName)
{
	char fname[MAX_PATH];
	if (GetModuleFileName(hModule, fname, sizeof(fname))==0) {
		TRACE("RegisterModule failed due to GetModuleFileName() error %d\n", GetLastError());
		return FALSE;
	}
	return RegisterModule(fname, moduleName);
}
inline BOOL Win32uiHostGlue::RegisterModule(const char *fname, const char *moduleName)
{
	const char *keyRootName = "Software\\Python\\PythonCore\\";
	char keyBuf[256];
	char version[10];
	strcpy(keyBuf, keyRootName);
	// Indirect through "CurrentVersion" - must read it.
	strcat(keyBuf, "CurrentVersion");
	long retSize = sizeof(version);
	HKEY hkey = GetRegistryRootKey();
	if (RegQueryValue(hkey, keyBuf, version, &retSize)!=ERROR_SUCCESS) {
		TRACE("RegisterModule failed due to RegQueryValue() error %d\n", GetLastError());
		return FALSE;
	}
	// Build key to write.
	strcpy(keyBuf, keyRootName);
	strcat(keyBuf, version);
	strcat(keyBuf, "\\Modules\\");
	strcat(keyBuf, moduleName);
	if (RegSetValue(hkey,
	                keyBuf, REG_SZ, 
					fname, strlen(fname))!=ERROR_SUCCESS) {
		TRACE("RegisterModule failed due to RegSetValue() error %d\n", GetLastError());
		return FALSE;
	}
	return TRUE;
}

#ifndef LINK_WITH_WIN32UI
inline BOOL Win32uiHostGlue::DynamicApplicationInit(const char *cmd, const char *additionalPaths)
{
	char path[_MAX_PATH];
	char keyName[256];
	char version[32];
	HINSTANCE hMod = NULL;

	// Indirect through "CurrentVersion"
	const char *keyRootName = "Software\\Python\\PythonCore\\";

	strcpy(keyName, keyRootName);
	strcat(keyName, "CurrentVersion");
	long retSize = sizeof(version);
	HKEY hkey = GetRegistryRootKey();
	BOOL bWasRegistered = FALSE;

	if (RegQueryValue(hkey, keyName, version, &retSize)==ERROR_SUCCESS) {
		// Do have "CurrentVersion.  Load Python dll first, to avoid path problems.
		HMODULE hModCore = NULL;
		strcpy(keyName, keyRootName);
		strcat(keyName, version);
		strcat(keyName, "\\Dll");
		retSize = sizeof(path);
		if (RegQueryValue(hkey, keyName, path, &retSize)==ERROR_SUCCESS) {
			TRACE("Located Python dll at %s.\n", path);
			hModCore = LoadLibrary(path);
			if (hModCore==NULL) {
				char buf[80];
				wsprintf(buf,"Warning - Core Python DLL registered, but module load failed (%d)\n", GetLastError());
				OutputDebugString(buf);
			}
		}

		strcpy(keyName, keyRootName);
		strcat(keyName, version);
		strcat(keyName, "\\Modules\\win32ui");
		retSize = sizeof(path);
		if (RegQueryValue(hkey, keyName, path, &retSize)==ERROR_SUCCESS) {
			TRACE("Located registered win32ui at %s.\n", path);
			hMod = LoadLibrary(path);
			if (hMod==NULL) {
				char buf[80];
				wsprintf(buf,"Warning - win32ui registered, but module load failed (%d)\n", GetLastError());
				OutputDebugString(buf);
			} else
				bWasRegistered = TRUE;
		}
		if (hModCore) // free my temp instance.
			FreeLibrary(hModCore);
	}
	const char *modName = "win32ui.pyd";
	if (hMod==NULL)
		hMod = LoadLibrary(modName);
	if (hMod==NULL) {
#ifdef _DEBUG
		hMod = LoadLibrary("WinDebug\\win32ui.pyd");
#else
		hMod = LoadLibrary("WinRel\\win32ui.pyd");
#endif
	}
	// just incase there is no registry available at all.
	if (hMod==NULL)
		hMod = LoadLibrary("Apps\\PyWin\\win32ui.pyd");
	if (hMod==NULL) {
		char buf[256];
		wsprintf(buf,"The application can not locate win32ui.pyd (%d)\n", GetLastError()); 
		int len = strlen(buf);
		int bufLeft = sizeof(buf) - len;
		FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(), 
			MAKELANGID(LANG_NEUTRAL,SUBLANG_NEUTRAL), buf+len, bufLeft, NULL);
		AfxMessageBox(buf);
		return FALSE;
	}
	// We located it - register it, to ensure Python loads it correctly.
	if (!bWasRegistered) {
		if (GetModuleFileName(hMod, path, sizeof(path))==0) {
			char buf[256];
			wsprintf(buf,"WARNING - win32uiHostGlue could not get the filename of the win32ui module (%d)\n", GetLastError()); 
			OutputDebugString(buf);
			FreeLibrary(hMod);
			return FALSE;
		}
		RegisterModule(path,"win32ui");
	}
	TRACE("Application attached to %s.\n", path);
	BOOL (__cdecl *pfnInit)(Win32uiHostGlue *, char *, const char *);

	pfnInit = (BOOL (__cdecl *)(Win32uiHostGlue *, char *, const char *))GetProcAddress(hMod, "Win32uiApplicationInit");
	BOOL rc;
	if (pfnInit)
		rc = (*pfnInit)(this, (char *)cmd, additionalPaths);
	else {
		OutputDebugString("WARNING - win32uiHostGlue could not load the entry point for ApplicationInit\n");
		rc = FALSE;
	}
	FreeLibrary(hMod);
	return rc;
}
#else

extern "C" __declspec(dllimport) BOOL Win32uiApplicationInit(Win32uiHostGlue *pGlue, char *cmd, const char *addnPaths);

inline BOOL Win32uiHostGlue::ApplicationInit(const char *cmd, const char *additionalPaths)
{
	return Win32uiApplicationInit(this, (char *)cmd,additionalPaths);
}

#endif