/*

	win32 virtuals manager/helper

	Created August 1994, Mark Hammond (MHammond@skippinet.com.au)

*/
#include "stdafx.h"
#include "win32win.h"
#include "win32dc.h"
#include "win32doc.h"
//////////////////////////////////////////////////////////////////////
//
// virtuals helper
//
//////////////////////////////////////////////////////////////////////

CVirtualHelper::CVirtualHelper(const char *iname, const void *iassoc)
{
	handler=NULL;
	py_ob = NULL;
	retVal=NULL;
	csHandlerName = iname;
	ui_assoc_object *py_bob = ui_assoc_object::handleMgr.GetAssocObject( iassoc );
	if (py_bob==NULL)
		return;
	if (!py_bob->is_uiobject( &ui_assoc_object::type)) {
		TRACE("CVirtualHelper::CVirtualHelper Error: Call object is not of required type\n");
		return;
	}
	// ok - have the python data type - now see if it has an override.
	if (py_bob->virtualInst) {
		PyObject *t, *v, *tb;
		PyErr_Fetch(&t,&v,&tb);
		handler = PyObject_GetAttrString(py_bob->virtualInst, (char *)iname);
		if (handler) {
			// explicitely check a method returned, else the classes
			// delegation may cause a circular call chain.
			if (!PyMethod_Check(handler)) {
				if (!PyCFunction_Check(handler)) {
					TRACE("Handler for object is not a method!\n");
				}
				DODECREF(handler);
				handler = NULL;
			}
		}
		PyErr_Restore(t,v,tb);
	}
	py_ob = py_bob;
	Py_INCREF(py_ob);
//	Py_XINCREF(handler);
}
CVirtualHelper::~CVirtualHelper()
{
	XDODECREF(retVal);
	XDODECREF(handler);
	XDODECREF(py_ob);
}
PyObject *CVirtualHelper::GetHandler()
{
	return handler;
}
BOOL CVirtualHelper::do_call(PyObject *args)
{
	XDODECREF(retVal);	// our old one.
	retVal = NULL;
	ASSERT(handler);	// caller must trap this.
	ASSERT(args);
	PyObject *result = gui_call_object(handler,args);
	DODECREF(args);
	if (result==NULL) {
		char msg[256];
		TRACE("CallVirtual : callback failed with exception\n");
		gui_print_error();
		PyObject *obRepr = PyObject_Repr(handler);
		char *szRepr = PyString_AsString(obRepr);
		wsprintf(msg, "%s() virtual handler (%s) raised an exception", (const char *)csHandlerName, szRepr);
		Py_XDECREF(obRepr);
		PyErr_SetString(ui_module_error, msg);
		gui_print_error();
		return FALSE;
	}
	retVal = result;
	return TRUE;
}

BOOL CVirtualHelper::call_args(PyObject *arglst)
{
	if (!handler) return FALSE;
	return do_call(arglst);
}

BOOL CVirtualHelper::call()
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("()");
	return do_call(arglst);
}
BOOL CVirtualHelper::call(int val)
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("(i)",val);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(int val1, int val2, int val3)
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("(iii)",val1, val2, val3);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(long val)
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("(l)",val);
	return do_call(arglst);
}

BOOL CVirtualHelper::call(const char *val)
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("(z)",val);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(const char *val, int ival)
{
	if (!handler) return FALSE;
	PyObject *arglst = Py_BuildValue("(zi)",val,ival);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(PyObject *ob)
{
	if (!handler) return FALSE;
	if (!ob)
		ob=Py_None;
	PyObject *arglst = Py_BuildValue("(O)",ob);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(PyObject *ob, PyObject *ob2)
{
	if (!handler) return FALSE;
	if (!ob)
		ob=Py_None;
	if (!ob2)
		ob2=Py_None;
	PyObject *arglst = Py_BuildValue("(OO)",ob, ob2);
	return do_call(arglst);
}
BOOL CVirtualHelper::call(PyObject *ob, PyObject *ob2, int i)
{
	if (!handler) return FALSE;
	if (!ob)
		ob=Py_None;
	if (!ob2)
		ob2=Py_None;
	PyObject *arglst = Py_BuildValue("(OOi)",ob, ob2, i);
	return do_call(arglst);
}

BOOL CVirtualHelper::call(CDC *pDC)
{
	if (!handler) return FALSE;
	PyObject *dc = (PyObject *) ui_assoc_object::make (ui_dc_object::type,
												   pDC)->GetGoodRet();
	if (!dc) return FALSE;
	PyObject *arglst = Py_BuildValue("(O)",dc);
	BOOL ret = do_call(arglst);
	DODECREF (dc); // the reference I created.
	return ret;
}
BOOL CVirtualHelper::call(CDC *pDC, CPrintInfo *)
{
	// for now, send None for CPrintInfo
	if (!handler) return FALSE;
	PyObject *dc = (PyObject *) ui_assoc_object::make (ui_dc_object::type,
												   pDC)->GetGoodRet();
	if (!dc) return FALSE;
	PyObject *arglst = Py_BuildValue("(Oz)",dc, NULL);
	BOOL ret = do_call(arglst);
	DODECREF (dc); // the reference I created.
	return ret;
}
BOOL CVirtualHelper::call(CWnd *pWnd)
{
	if (!handler) return FALSE;
	PyObject *wnd = (PyObject *) ui_assoc_object::make (PyCWnd::type,
												   pWnd)->GetGoodRet();
	if (!wnd) return FALSE;
	PyObject *arglst = Py_BuildValue("(O)",wnd);
	BOOL ret = do_call(arglst);
	DODECREF (wnd); // the reference I created.
	return ret;
}

BOOL CVirtualHelper::call(CView *pWnd, PyObject *ob)
{
	if (!handler) return FALSE;
	if (!ob)
		ob=Py_None;
	PyObject *wnd ;
	if (pWnd==NULL) {
		wnd = Py_None;
		DOINCREF(wnd);
	} else {
		wnd = ui_assoc_object::make (PyCView::type,
									   pWnd)->GetGoodRet();
		if (!wnd) return FALSE;
	}
	PyObject *arglst = Py_BuildValue("(OO)",wnd,ob);
	BOOL ret = do_call(arglst);
	DODECREF (wnd); // the reference I created.
	return ret;
}

BOOL CVirtualHelper::call(BOOL boolVal, CWnd *pWnd1, CWnd *pWnd2)
{
	if (!handler) return FALSE;
	PyObject *wnd1;
	if (pWnd1) {
		wnd1 = (PyObject *) ui_assoc_object::make (PyCWnd::type,
												   pWnd1)->GetGoodRet();
		if (!wnd1) return FALSE;
	} else {
		Py_INCREF(Py_None);
		wnd1 = Py_None;
	}
	PyObject *wnd2;
	if (pWnd2) {
		wnd2 = (PyObject *) ui_assoc_object::make (PyCWnd::type,
												   pWnd2)->GetGoodRet();
		if (!wnd2) return FALSE;
	} else {
		Py_INCREF(Py_None);
		wnd2 = Py_None;
	}
	PyObject *arglst = Py_BuildValue("(iOO)",boolVal, wnd1, wnd2);
	BOOL ret = do_call(arglst);
	DODECREF (wnd1); // the reference I created.
	DODECREF (wnd2); // the reference I created.
	return ret;
}

BOOL CVirtualHelper::call(CDocument *pDoc)
{
	if (!handler) return FALSE;
	PyObject *doc = (PyObject *) ui_assoc_object::make (PyCDocument::type,
												   pDoc)->GetGoodRet();
	if (!doc) return FALSE;
	PyObject *arglst = Py_BuildValue("(O)",doc);
	BOOL ret = do_call(arglst);
	DODECREF (doc); // ref I created.
	return ret;
}
BOOL CVirtualHelper::call(LPCREATESTRUCT lpcs, PyObject *ob)
{
	if (!handler) return FALSE;
	PyObject *cs = PyObjectFromCreateStruct(lpcs);
	if (!cs) return FALSE;
	PyObject *arglst = Py_BuildValue("(O,O)", cs, ob );
	BOOL ret = do_call(arglst);
	DODECREF(cs); // ref I created.
	return ret;
}
BOOL CVirtualHelper::call(LPCREATESTRUCT lpcs)
{
	if (!handler) return FALSE;
	PyObject *cs = PyObjectFromCreateStruct(lpcs);
	if (!cs) return FALSE;
	PyObject *arglst = Py_BuildValue("(O)", cs);
	BOOL ret = do_call(arglst);
	DODECREF(cs); // my reference.
	return ret;
}
BOOL CVirtualHelper::retnone()
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	return (retVal==Py_None);
}

BOOL CVirtualHelper::retval( int &ret )
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	if (retVal==Py_None) {
		ret = 0;
		return TRUE;
	}
	ret = PyInt_AsLong(retVal);
	return !PyErr_Occurred();
}
BOOL CVirtualHelper::retval( long &ret )
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	if (retVal==Py_None) {
		ret = 0;
		return TRUE;
	}
	ret = PyInt_AsLong(retVal);
	if (PyErr_Occurred()) {
		PyErr_Clear();
		return FALSE;
	}
	return TRUE;
}

BOOL CVirtualHelper::retval( char *&ret )
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	if (retVal==Py_None) {
		ret = NULL;
		return TRUE;
	}
	ret = PyString_AsString(retVal);
	if (PyErr_Occurred()) {
		PyErr_Clear();
		return FALSE;
	}
	return TRUE;
}

BOOL CVirtualHelper::retval( CString &ret )
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	if (retVal==Py_None) {
		ret.Empty();
		return TRUE;
	}
	ret = PyString_AsString(retVal);
	if (PyErr_Occurred()) {
		PyErr_Clear();
		return FALSE;
	}
	return TRUE;
}

BOOL CVirtualHelper::retval( _object* &ret )
{
	ASSERT(retVal);
	if (!retVal)
		return FALSE;	// failed - assume didnt work in non debug
	if (!PyArg_Parse(retVal, "O",&ret)) {
		PyErr_Clear();
		return FALSE;
	}
	return TRUE;
}

BOOL CVirtualHelper::retval( CREATESTRUCT &cs )
{
	ASSERT(retVal);
	if (!retVal || retVal==Py_None)
		return FALSE;	// failed - assume didnt work in non debug
	if (!CreateStructFromPyObject(&cs, retVal)) {
		char msgBuf[128];

		gui_print_error();
		wsprintf(msgBuf, "virtual %s: The return value can not be converted from a CREATESTRUCT tuple",
				(const char *)csHandlerName );
		PyErr_SetString(PyExc_TypeError, msgBuf);
		gui_print_error();
		return FALSE;
	}
	return TRUE;
}

