// -*- Mode: C++; tab-width: 4 -*-
//
//  Python brush wrapper.
//
//  Created Dec 1995, by Sam Rushing (rushing@nightmare.com)
//
// Note that this source file contains embedded documentation.
// This documentation consists of marked up text inside the
// C comments, and is prefixed with an '@' symbol.  The source
// files are processed by a tool called "autoduck" which
// generates Windows .hlp files.
// @doc


#include "stdafx.h"
#include "win32gdi.h"
#include "win32brush.h"

// this returns a pointer that should not be stored.
CBrush *PyCBrush::GetBrush(PyObject *self)
{
	return (CBrush *)ui_assoc_object::GetGoodCppObject( self, &type);
}

// @pymethod <o PyCBrush>|win32ui|CreateBrush|Creates a new brush object.
PyObject *
PyCBrush::create (PyObject *self, PyObject *args)
{
  int n_brush_style;
  int n_hatch;
  long cr_color;
  LOGBRUSH lp;
  
  if (!PyArg_ParseTuple (args, "iil",
						 &n_brush_style, // @pyparm int|style||The brush style.
						 &cr_color, // @pyparm int|color||The brush color.
						 &n_hatch)) {// @pyparm long|hatch||The brush hatching.
	return NULL;
  }
  lp.lbStyle = n_brush_style;
  lp.lbColor = cr_color;
  lp.lbHatch = n_hatch;

  CBrush *pBrush = new CBrush;
  if (!pBrush->CreateBrushIndirect (&lp)) {
	RETURN_ERR ("CreateBrushIndirect call failed");
  }
  return ui_assoc_object::make (PyCBrush::type, pBrush);
}

// @object PyCBrush|An object encapsulating an MFC PyCBrush class.
static struct PyMethodDef PyCBrush_methods[] = {
  {NULL,			NULL}
};

ui_type_CObject PyCBrush::type ("PyCBrush",
							 &PyCGdiObject::type,
							 RUNTIME_CLASS(CBrush),
							 sizeof(PyCBrush),
							 PyCBrush_methods,
							 GET_PY_CTOR(PyCBrush));
