@echo off
rem This file sets up an environment for test versions of Python/Pythonwin.

rem Default Python location is E:\SRC\PYTHON??? - use PYTHONDIR to override.
if "%pythondir%==" goto nopypath
echo Using envvar PYTHONDIR=%pythondir%
goto pyexpath
:nopypath
set pythondir=e:\src\python1.4
set pythonexe=%pythondir%\vc40\python.exe
set setpy=1

rem Default "Python Extensions" directory - use PYEXPATH to override.
:pyexpath
if "%pyexpath%==" goto nopyexpath
echo Using envvar PYEXPATH=%PYEXPATH%
goto checkver
:nopyexpath
set pyexpath=e:\src\pythonex
set setex=1

rem Check for "release" or "debug" version .pyd.
:checkver
if %1"==release" goto rel
if %1"==debug" goto debug
echo Assuming Debug (use "release" or "debug" to avoid this message)
pause

:debug
set debugrel=debug
goto doit

:rel
set debugrel=release
goto doit

:doit

set regsetup=%pythonexe% ..\win32\lib\regsetup.py
rem Register/Check the core engine.
%regsetup% %pythondir%  %pythondir%\vc40 .. %pythondir%\lib d:\temp\wordtemp ..\win32\lib ..\win32\Build\%debugrel%

rem Register the Pythonwin
rem Unregister first so it doesnt find existing entries.
%regsetup% --unpythonwin
%regsetup% --pythonwin Build\%debugrel% . lib 
%regsetup% --win32com %pyexpath% %pyexpath%\win32com

rem Check everything went OK
%pythonexe% ..\win32\lib\regcheck.py

rem Done!
goto xit

:badpypath
echo Python.exe can not be found at %pythonexe%
echo Please fix the environment variable PYTHONDIR, and try again.
goto xit

:xit
if not "%setpy% == " set pythondir=
if not "%setex% == " set pyexpath=
set setpy=
set setex=
set pydll=
set debugrel=
set pythonexe=
set regsetup=
