#include "stdafx.h"
#include "pythonwnd.h"

// Common routines for CWnd derived classes.
//

void PyWnd_OnSysColorChange(CWnd *pThis)
{
	// @pyvirtual |PyCWnd|OnSysColorChange|Called for all top-level windows when a change is made in the system color setting.
	// @comm The MFC base class is always called before the Python method.
	CVirtualHelper helper ("OnSysColorChange", pThis);
	helper.call();
}

void PyWnd_OnWinIniChange(CWnd *pThis, LPCTSTR lpszSection) 
{
	// @pyvirtual |PyCWnd|OnWinIniChange|Called when the system configuration changes.
	// @pyparm string|section||The section which changed.
	// @comm The MFC base class is always called before the Python method.
	CVirtualHelper helper ("OnWinIniChange", pThis);
	helper.call(lpszSection);
}

void PyWnd_OnPaletteIsChanging(CWnd *pThis, CWnd* pRealizeWnd) 
{
	// @pyvirtual |PyCWnd|OnPaletteIsChanging|Informs other applications when an application is going to realize its logical palette.
	CVirtualHelper helper( "OnPaletteIsChanging", pThis );
	// @pyparm <o PyCWnd>|realizeWnd||Specifies the window that is about to realize its logical palette.
	// @comm The MFC base class is always called before the Python method.
	helper.call(pRealizeWnd);
}

void PyWnd_OnPaletteChanged( CWnd *pThis, CWnd *pWnd )
{
	// @pyvirtual |PyCWnd|OnPaletteChanged|Called to allow windows that use a color palette to realize their logical palettes and update their client areas.
	CVirtualHelper helper( "OnPaletteChanged", pThis );
	// @pyparm <o PyCWnd>|focusWnd||The window that caused the system palette to change. 
	helper.call(pWnd);
}

