// pythonpsheet.cpp : implementation file
//
// Note that this source file contains embedded documentation.
// This documentation consists of marked up text inside the
// C comments, and is prefixed with an '@' symbol.  The source
// files are processed by a tool called "autoduck" which
// generates Windows .hlp files.
// @doc

#include "stdafx.h"
#include "pythonwin.h"
#include "win32ui.h"
#include "pythonpsheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonPropertySheet

IMPLEMENT_DYNAMIC(CPythonPropertySheet, CPropertySheet)

CPythonPropertySheet::CPythonPropertySheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

CPythonPropertySheet::CPythonPropertySheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

CPythonPropertySheet::~CPythonPropertySheet()
{
}

void CPythonPropertySheet::PostNcDestroy(void)
{
	// Loop over all pages, ensuring no Python association exists.
	// This is because some pages may never have had windows.
	for (int i = 0; i < m_pages.GetSize(); i++)
	{
		CPropertyPage* pPage = GetPage(i);
		delete pPage;
	}

	Python_delete_assoc(this);
	delete this;
}

BOOL
CPythonPropertySheet::OnCmdMsg (UINT nID, int nCode,
			   void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo)
{
  // yield to Python first
  if (Python_OnCmdMsg (this, nID, nCode, pExtra, pHandlerInfo))
    return TRUE;
  else
    return CPropertySheet::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
}

BOOL 
CPythonPropertySheet::OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
  // yield to Python first
  if (Python_OnNotify (this, wParam, lParam, pResult))
    return TRUE;
  else
    return CPropertySheet::OnNotify (wParam, lParam, pResult);
}

LRESULT CPythonPropertySheet::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// @pyvirtual int|PyCPropertySheet|WindowProc|Default message handler.
	LRESULT res;
	CVirtualHelper helper( "WindowProc", this );
	if (!helper.HaveHandler() || !helper.call(message, wParam, lParam) || !helper.retval(res))
		return CPropertySheet::WindowProc(message, wParam, lParam);
	return res;
}


BEGIN_MESSAGE_MAP(CPythonPropertySheet, CPropertySheet)
	//{{AFX_MSG_MAP(CPythonPropertySheet)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

#ifdef _DEBUG
void CPythonPropertySheet::Dump( CDumpContext &dc ) const
{
	CPropertySheet::Dump(dc);
	DumpAssocPyObject(dc, (void *)this);
}
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonPropertySheet message handlers
