// pythonppage.cpp : implementation file
//
// Note that this source file contains embedded documentation.
// This documentation consists of marked up text inside the
// C comments, and is prefixed with an '@' symbol.  The source
// files are processed by a tool called "autoduck" which
// generates Windows .hlp files.
// @doc

#include "stdafx.h"
#include "pythonwin.h"
#include "win32ui.h"

#include "pythonppage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonPropertyPage property page

IMPLEMENT_DYNAMIC(CPythonPropertyPage, CPropertyPage)

CPythonPropertyPage::CPythonPropertyPage(UINT id, UINT caption) : CPropertyPage(id, caption)
{
	CommonConstruct();
}

CPythonPropertyPage::CPythonPropertyPage(LPCTSTR id, UINT caption) : CPropertyPage(id, caption)
{
	CommonConstruct();
}

void CPythonPropertyPage::CommonConstruct()
{
//	hTemplate = 0;
	hSaved = 0;
	//{{AFX_DATA_INIT(CPythonPropertyPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CPythonPropertyPage::~CPythonPropertyPage()
{
	if (m_psp.pResource)
	{
		GlobalUnlock(hSaved);
		GlobalFree(hSaved);
	}
	Python_delete_assoc(this);
}

void CPythonPropertyPage::PostNcDestroy()
{
// 	delete this;
}

BOOL CPythonPropertyPage::SetTemplate(HGLOBAL tpl)
{
	hSaved = tpl;
//	if (m_psp.pResource!=NULL) {
//		PyErr_SetString(ui_module_error, "The template can only be assigned once");
//		return FALSE;
//	}
	m_psp.dwFlags |= PSP_DLGINDIRECT;

	m_psp.pResource = (const DLGTEMPLATE *)GlobalLock(tpl);

	// Set the caption if not already set
	if (m_strCaption.GetLength() == 0)
	{
		// use a LPWSTR because all resource are UNICODE
		LPCWSTR p = (LPCWSTR)((BYTE*)m_psp.pResource + sizeof(DLGTEMPLATE));
		// skip menu stuff
		p+= (*p == 0xffff) ? 2 : wcslen(p)+1;
		// skip window class stuff
		p+= (*p == 0xffff) ? 2 : wcslen(p)+1;
		// we're now at the caption
		m_strCaption = p;
	}
	return TRUE; //CreatePage();
}

// This is an indirect-specific implementaion of CreatePage
BOOL CPythonPropertyPage::CreatePage()
{
/*
	if (!CreateIndirect(hTemplate, m_pParentWnd))
		return FALSE; // Create() failed...

	// Must be a child for obvious reasons, and must be disabled to prevent
	// it from taking the focus away from the tab area during initialization...
	ASSERT((GetStyle() & (WS_DISABLED | WS_CHILD)) == (WS_DISABLED | WS_CHILD));
  */
	return TRUE;    // success
}

BOOL CPythonPropertyPage::OnKillActive()
{
	// @pyvirtual int|PyCPropertyPage|OnKillActive|Called when the page loses focus.
	// @rdesc The method should return TRUE if the page can be de-activated.
	// @comm Note - If you provide a handler, you must call the underlying MFC method (<om PyCPropertyPage.OnKillActive>) yourself
	// @xref <om PyCPropertyPage.OnKillActive>
	CVirtualHelper helper( "OnKillActive", this );
	if (!helper.HaveHandler())
		return CPropertyPage::OnKillActive();
	BOOL bOK = TRUE;
	if (helper.call())
		helper.retval(bOK);
	return bOK;
}

BOOL CPythonPropertyPage::OnSetActive()
{
	// @pyvirtual int|PyCPropertyPage|OnSetActive|Called when the page becomes active.
	// @rdesc The method should return TRUE if the page can be activated.
	// @comm Note - If you provide a handler, you must call the underlying MFC method (<om PyCPropertyPage.OnSetActive>) yourself
	// @xref <om PyCPropertyPage.OnSetActive>
	CVirtualHelper helper( "OnSetActive", this );
	if (!helper.HaveHandler())
		return CPropertyPage::OnSetActive();
	BOOL bOK = TRUE;
	if (helper.call())
		helper.retval(bOK);
	return bOK;
}

void CPythonPropertyPage::OnOK()
{
	// @pyvirtual |PyCPropertyPage|OnOK|Called when the user selects the OK button
	// @xref <om PyCPropertyPage.OnOK>
	CVirtualHelper helper( "OnOK", this );
	if (!helper.HaveHandler())
		CPropertyPage::OnOK();
	else
		helper.call();
}
void CPythonPropertyPage::OnCancel()
{
	// @pyvirtual |PyCPropertyPage|OnCancel|Called when the user selects the Cancel button
	// @xref <om PyCPropertyPage.OnCancel>
	CVirtualHelper helper( "OnCancel", this );
	if (!helper.HaveHandler())
		CPropertyPage::OnCancel();
	else
		helper.call();
}

BOOL
CPythonPropertyPage::OnCmdMsg (UINT nID, int nCode,
			   void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo)
{
  // yield to Python first
  if (Python_OnCmdMsg (this, nID, nCode, pExtra, pHandlerInfo))
    return TRUE;
  else
    return CPropertyPage::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
}

BOOL CPythonPropertyPage::OnInitDialog()
{
	// @pyvirtual int|PyCPropertyPage|OnInitDialog|Override to augment dialog-box initialization.
	// @comm The base implementation is not called if a handler exists.  This can be
	// done via <om PyCPropertyPage.OnInitDialog>.
	// @xref <om PyCPropertyPage.OnInitDialog>
	BOOL result = FALSE;
	CVirtualHelper helper( "OnInitDialog", this );
	if (!helper.HaveHandler()) {
		result = CDialog::OnInitDialog();
	} else {
		if (helper.call())
			helper.retval(result);
	}
	return result;
}
BOOL 
CPythonPropertyPage::OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
  // yield to Python first
  if (Python_OnNotify (this, wParam, lParam, pResult))
    return TRUE;
  else
    return CPropertyPage::OnNotify (wParam, lParam, pResult);
}

LRESULT CPythonPropertyPage::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// @pyvirtual int|PyCPropertyPage|WindowProc|Default message handler.
	LRESULT res;
	CVirtualHelper helper( "WindowProc", this );
	if (!helper.HaveHandler() || !helper.call(message, wParam, lParam) || !helper.retval(res))
		return CPropertyPage::WindowProc(message, wParam, lParam);
	return res;
}

void CPythonPropertyPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	Python_do_exchange( this, pDX );
	//{{AFX_DATA_MAP(CPythonPropertyPage)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPythonPropertyPage, CPropertyPage)
	//{{AFX_MSG_MAP(CPythonPropertyPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

#ifdef _DEBUG
void CPythonPropertyPage::Dump( CDumpContext &dc ) const
{
	CPropertyPage::Dump(dc);
	DumpAssocPyObject(dc, (void *)this);
}
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonPropertyPage message handlers
