import hierlist, string, regutil, os
import win32con, win32ui, win32api
import commctrl
import pwindialog
import glob

class HLIErrorItem(hierlist.HierListItem):
	def __init__(self, text):
		self.text = text
		hierlist.HierListItem.__init__(self)
	def GetText(self):
		return self.text

class HLIFileItem(hierlist.HierListItem):
	def __init__(self, path):
		hierlist.HierListItem.__init__(self)
		self.path = path
	def GetText(self):
		return os.path.split(self.path)[1]
	def IsExpandable(self):
		return 0
	def TakeDefaultAction(self):
		win32ui.GetApp().OpenDocumentFile( self.path )
	def GetBitmapColumn(self):
		col = 4 # Default
		try:
			if win32api.GetFileAttributes(self.path) & win32con.FILE_ATTRIBUTE_READONLY:
				col = 5
		except win32api.error:
			pass
		return col

class HLIDirectoryItem(hierlist.HierListItem):
	def __init__(self, path, displayName = None, bSubDirs = 0):
		hierlist.HierListItem.__init__(self)
		self.path = path
		self.bSubDirs = bSubDirs
		if displayName:
			self.displayName = displayName
		else:
			self.displayName = path
	def IsExpandable(self):
		return 1
	def GetText(self):
		return self.displayName
	def GetSubList(self):
		ret = []
		for filename in glob.glob(os.path.join(self.path,'*')):
			if self.bSubDirs and os.path.isdir(filename):
				ret.append(HLIDirectoryItem(filename, os.path.split(filename)[1]))
			else:
				if string.lower(os.path.splitext(filename)[1])=='.py':
					ret.append(HLIFileItem(filename))
		return ret

class HLIProjectRoot(hierlist.HierListItem):
	def __init__(self, projectName):
		hierlist.HierListItem.__init__(self)
		self.projectName = projectName
	def GetText(self):
		return self.projectName
	def IsExpandable(self):
		return 1
	def GetSubList(self):
		ret = []
		paths = regutil.GetRegisteredNamedPath(self.projectName)
		# Hack for "ni" packages.  If a directory with the same name exists, assume
		# its a package.
		try:
			ni_path = os.path.join(paths, self.projectName)
			os.stat(ni_path)
			num_ni_bits = len(string.split(ni_path,"\\"))
			# Looks like a "ni" path
			for filename in glob.glob(os.path.join(ni_path,'*')):
				if os.path.isdir(filename):
					dirName = string.join(string.split(filename,"\\")[num_ni_bits:],"\\")
					ret.append(HLIDirectoryItem(filename, dirName, 1))
				else:
					if string.lower(os.path.splitext(filename)[1])=='.py':
						ret.append(HLIFileItem(filename))
			# Complete and utter hack for win32com.
			if self.projectName=="win32com":
				# Looks like a "ni" path
				try:
					ni_path = win32api.GetFullPathName(os.path.join(ni_path, "..\\win32comext"))
					for filename in glob.glob(os.path.join(ni_path,'*')):
						if os.path.isdir(filename):
							dirName = string.join(string.split(filename,"\\")[num_ni_bits:],"\\")
						ret.append(HLIDirectoryItem(filename, dirName, 1))
				except win32api.error:
					pass

		except os.error:
			# no sub-dir - just normal entry
			if paths is None:
				ret.append(HLIErrorItem("The entry %s is not registered" % self.projectName))
			else:
				paths = string.split(paths,";")
				if length(paths)==1: # Single dir - dont bother putting the dir in
					ret = []
					for fname in glob.glob(	os.path.join(self.path, "*.py") ):
						ret.append(HLIFileItem(fname))
				else:
					for path in paths:
						ret.append(HLIDirectoryItem(path))
		return ret

		
class HLIRoot(hierlist.HierListItem):
	def __init__(self):
		hierlist.HierListItem.__init__(self)
	def IsExpandable(self):
		return 1
	def GetSubList(self):
		keyStr = regutil.BuildDefaultPythonKey() + "\\PythonPath"
		hKey = win32api.RegOpenKey(regutil.GetRootKey(), keyStr)
		try:
			ret = []
			index = 0
			while 1:
				try:
					ret.append(HLIProjectRoot(win32api.RegEnumKey(hKey, index)))
					index = index + 1
				except win32api.error:
					break
			return ret
		finally:
			win32api.RegCloseKey(hKey)

class dynamic_browser (pwindialog.Dialog):
    style = win32con.WS_OVERLAPPEDWINDOW | win32con.WS_VISIBLE
    cs = (
        win32con.WS_CHILD           |
        win32con.WS_VISIBLE         |
        commctrl.TVS_HASLINES       |
        commctrl.TVS_LINESATROOT    |
        commctrl.TVS_HASBUTTONS
        )

    dt = [
        ["Python Projects", (0, 0, 200, 200), style, None, (8, "MS Sans Serif")],
        ["SysTreeView32", None, win32ui.IDC_LIST1, (0, 0, 200, 200), cs]
        ]

    def __init__ (self, hli_root):
        pwindialog.Dialog.__init__ (self, self.dt)
        self.hier_list = hierlist.HierListWithItems (
            hli_root,
            win32ui.IDB_BROWSER_HIER
            )
        self.HookMessage (self.on_size, win32con.WM_SIZE)

    def OnInitDialog (self):
        self.hier_list.HierInit (self)
        return pwindialog.Dialog.OnInitDialog (self)

    def on_size (self, params):
        lparam = params[3]
        w = win32api.LOWORD(lparam)
        h = win32api.HIWORD(lparam)
        self.GetDlgItem (win32ui.IDC_LIST1).MoveWindow((0,0,w,h))

def Browse ():
    " Browse the argument, or the main dictionary "
    root = HLIRoot()
    if not root.IsExpandable():
        raise TypeError, "Browse() argument must have __dict__ attribute, or be a Browser supported type"
        
    dlg = dynamic_browser (root)
    dlg.CreateWindow()

