# App.py
# Application stuff.
# The application is responsible for managing the main frame window.
#
# We also grab the FileOpen command, to invoke our Python editor
" The PythonWin application code. Manages most aspects of MDI, etc "
# import ni; import mfc
import win32con
import win32api
import win32ui
import sys
import string
import os
import object
import window

# Hack for rename of the "dialog" module
import pwindialog
sys.modules['dialog'] = pwindialog
AppBuilder = None # A derived application class should set this object.
                  # The default startup will call it, and set the app.App var below.

App = None	# default - must end up a CApp derived class. 

# App Interface.
#

# Helpers

def AddIdleHandler(handler):
	return App.AddIdleHandler(handler)
def DeleteIdleHandler(handler):
	return App.DeleteIdleHandler(handler)

def SaveWindowSize(section,rect):
	""" Writes a rectangle to an INI file
	Args: section = section name in the applications INI file
	      rect = a rectangle in a (cy, cx, y, x) tuple 
	             (same format as CREATESTRUCT position tuples)."""	
	left, top, right, bottom = rect
	win32ui.WriteProfileVal(section,"left",left)
	win32ui.WriteProfileVal(section,"top",top)
	win32ui.WriteProfileVal(section,"right",right)
	win32ui.WriteProfileVal(section,"bottom",bottom)

def LoadWindowSize(section):
	""" Loads a section from an INI file, and returns a rect in a tuple (see SaveWindowSize)"""
	left = win32ui.GetProfileVal(section,"left",0)
	top = win32ui.GetProfileVal(section,"top",0)
	right = win32ui.GetProfileVal(section,"right",0)
	bottom = win32ui.GetProfileVal(section,"bottom",0)
	return (left, top, right, bottom)

def RectToCreateStructRect(rect):
	return (rect[3]-rect[1], rect[2]-rect[0], rect[1], rect[0] )
	
# Define FrameWindow and Application objects
class MainFrame(window.MDIFrameWnd):
	sectionPos = "Main Window"
	def PreCreateWindow(self, cc):
		cc = self._obj_.PreCreateWindow(cc)
		pos = LoadWindowSize(self.sectionPos)
		self.startRect = pos
		if pos[2] - pos[0]:
			rect = RectToCreateStructRect(pos)
			cc = cc[0], cc[1], cc[2], cc[3], rect, cc[5], cc[6], cc[7], cc[8]
		return cc

	def OnDestroy(self, msg):
		# use GetWindowPlacement(), as it works even when min'd or max'd
		rectNow = self.GetWindowPlacement()[4]
		if rectNow != self.startRect:
			SaveWindowSize(self.sectionPos, rectNow)
		return 0

class CApp(object.CmdTarget):
	" A class for the application "
	def __init__(self):
		self.oldCallbackCaller = None
		object.CmdTarget.__init__(self, win32ui.GetApp() )
		self.idleHandlers = []
		
	def InitInstance(self):
		" Called to crank up the app "
		numMRU = win32ui.GetProfileVal("Settings","Recent File List Size", 10)
		win32ui.LoadStdProfileSettings(numMRU)
		self._obj_.InitMDIInstance()
		if win32api.GetVersionEx()[0]<4:
			win32ui.SetDialogBkColor()
			win32ui.Enable3dControls()

		# install a "callback caller" - a manager for the callbacks
#		self.oldCallbackCaller = win32ui.InstallCallbackCaller(self.CallbackManager)
		self.LoadMainFrame()
		self.SetApplicationPaths()
		self.LoadSystemModules()
		
	def Shutdown(self):
		" Called as the app dies - too late to prevent it here! "
		win32ui.OutputDebug("Application shutdown\n")
		# Restore the callback manager, if any.
		try:
			win32ui.InstallCallbackCaller(self.oldCallbackCaller)
		except AttributeError:
			pass
		if self.oldCallbackCaller:
			del self.oldCallbackCaller
		self.frame=None	# clean Python references to the now destroyed window object.
		self.idleHandlers = []
		self._obj_.AttachObject(None)
		self._obj_ = None
		global App
		global AppBuilder
		App = None
		AppBuilder = None

	def AddIdleHandler(self, handler):
		self.idleHandlers.append(handler)
	def DeleteIdleHandler(self, handler):
		self.idleHandlers.remove(handler)
	def OnIdle(self, count):
		try:
			ret = 0
			handlers = self.idleHandlers[:] # copy list, as may be modified during loop
			for handler in handlers:
				try:
					thisRet = handler(handler, count)
				except:
					import traceback
					print "Idle handler %s failed" % (`handler`)
					traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)
					print "Idle handler removed from list"
					self.DeleteIdleHandler(handler)
					thisRet = 0
				ret = ret or thisRet
			return ret
		except KeyboardInterrupt:
			pass
	def CreateMainFrame(self):
		return MainFrame()

	def LoadMainFrame(self):
		" Create the main applications frame "
		# to assist us in debugging and reloading, we allow failure
		try:
			self.frame = self.CreateMainFrame()
			self.SetMainFrame(self.frame)
			self.frame.LoadFrame(win32ui.IDR_MAINFRAME, win32con.WS_OVERLAPPEDWINDOW)
			self.frame.DragAcceptFiles()	# we can accept these.
#			if (pos[2]-pos[0])!=0:
#				self.frame.MoveWindow(pos, 0)	# dont repaint-not shown yet
			self.frame.ShowWindow(win32ui.GetInitialStateRequest());
			self.frame.UpdateWindow();
			
		except win32ui.error:
			pass
		# but we do rehook, hooking the new code objects.
		self.HookCommands()
	

	def OnHelp(self,id, code):
		try:
			import regutil
			if id==win32ui.ID_HELP_GUI_REF:
				helpFile = regutil.GetRegisteredHelpFile("Pythonwin Reference")
				helpCmd = win32con.HELP_CONTENTS
			else:
				helpFile = regutil.GetRegisteredHelpFile("Main Python Documentation")
				helpCmd = win32con.HELP_FINDER
			if helpFile is None:
				win32ui.MessageBox("The help file is not registered!")
			else:
				import help
				help.OpenHelpFile(helpFile, helpCmd)
		except:
			win32ui.MessageBox("Internal error in help file processing\r\n%s: %s" % (sys.exc_type, sys.exc_value))
	
	def HookCommands(self):
		self.frame.HookMessage(self.OnDropFiles,win32con.WM_DROPFILES)
		self.frame.HookMessage(self.OnNCDestroy,win32con.WM_NCDESTROY)
		self.frame.HookCommand(self.HandleOnFileOpen,win32ui.ID_FILE_OPEN)
		self.frame.HookCommand(self.HandleOnFileNew,win32ui.ID_FILE_NEW)
		self.frame.HookCommand(self.OnFileMRU,win32ui.ID_FILE_MRU_FILE1)
		self.frame.HookCommand(self.OnFileMRU,win32ui.ID_FILE_MRU_FILE2)
		self.frame.HookCommand(self.OnFileMRU,win32ui.ID_FILE_MRU_FILE3)
#		self.frame.HookCommand(self.OnFileMRU,win32ui.ID_FILE_MRU_FILE4)
		self.frame.HookCommand(self.OnHelpAbout,win32ui.ID_APP_ABOUT)
		self.frame.HookCommand(self.OnHelp, win32ui.ID_HELP_PYTHON)
		self.frame.HookCommand(self.OnHelp, win32ui.ID_HELP_GUI_REF)
		# Hook for the right-click menu.
		self.frame.GetWindow(win32con.GW_CHILD).HookMessage(self.OnRClick,win32con.WM_RBUTTONDOWN)

	def SetApplicationPaths(self):
		# Load the users/application paths
		new_path = []
		apppath=string.splitfields(win32ui.GetProfileVal('Python','Application Path',''),';')
		for path in apppath:
			if len(path)>0:
				new_path.append(win32ui.FullPath(path))
		for extra_num in range(1,11):
			apppath=string.splitfields(win32ui.GetProfileVal('Python','Application Path %d'%extra_num,''),';')
			if len(apppath) == 0:
				break
			for path in apppath:
				if len(path)>0:
					new_path.append(win32ui.FullPath(path))
		sys.path = new_path + sys.path
		
	def LoadSystemModules(self):
		editorModuleName= win32ui.GetProfileVal("Editor","Module", "editor")
		self.DoLoadModules(editorModuleName+",bitmap")
	def LoadUserModules(self, moduleNames = None):
		if not moduleNames is None:
			self.DoLoadModules(moduleNames)
	def DoLoadModules(self, moduleNames): # ", sep string of module names.
		if not moduleNames: return
		modules = string.splitfields(moduleNames,",")
		for module in modules:
			try:
				exec "import "+module
			except ImportError:
				msg = 'Startup import of user module "%s" failed' % module
				print msg
				win32ui.MessageBox(msg)
	
	def OnRClick(self,params):
		" Handle right click message "
		# put up the entire FILE menu!
		menu = win32ui.LoadMenu(win32ui.IDR_TEXTTYPE).GetSubMenu(0)
		menu.TrackPopupMenu(params[5]) # track at mouse position.
		return 0

	def OnDropFiles(self,msg):
		" Handle a file being dropped from file manager "
		hDropInfo = msg[2]
		self.frame.SetActiveWindow()	# active us
		nFiles = win32api.DragQueryFile(hDropInfo)
		try:
			for iFile in range(0,nFiles):
				fileName = win32api.DragQueryFile(hDropInfo, iFile)
				win32ui.GetApp().OpenDocumentFile( fileName )
		finally:
			win32api.DragFinish(hDropInfo);

		return 0

	def CallbackManager( self, ob, args = () ):
		"""Manage win32 callbacks.  Trap exceptions, report on them, then return 'All OK'
		to the frame-work. """
		import traceback
		try:
			ret = apply(ob, args)
			return ret
		except:
			# take copies of the exception values, else other (handled) exceptions may get
			# copied over by the other fns called.
			win32ui.SetStatusText('An exception occured in a windows command handler.')
			traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback.tb_next)
			try:
				sys.stdout.flush()
			except (NameError, AttributeError):
				pass

	def OnNCDestroy( self,params ):
		" Called when the NonClient area is destroyed "
		self.Shutdown()

	# Command handlers.
	def OnFileMRU( self, id, code ):
		" Called when a File 1-n message is recieved "
		fileName = win32ui.GetRecentFileList()[id - win32ui.ID_FILE_MRU_FILE1]
		win32ui.GetApp().OpenDocumentFile(fileName)

	def HandleOnFileOpen( self, id, code ):
		" Called when FileOpen message is received "
		win32ui.GetApp().OnFileOpen()

	def HandleOnFileNew( self, id, code ):
		" Called when FileNew message is received "
		win32ui.GetApp().OnFileNew()

	def OnInstanceHandler(self, cmd):
		self.frame.ActivateFrame(win32con.SW_RESTORE)
		return 1

	def OnHelpAbout( self, id, code ):
		" Called when HelpAbout message is received.  Displays the About dialog. "
		win32ui.MessageBox("About a Python application")

def Win32RawInput(prompt=None):
	"Provide raw_input() for gui apps"
	# flush stderr/out first.
	try:
		sys.stdout.flush()
		sys.stderr.flush()
	except:
		pass
	import dialog
	if prompt is None: prompt = ""
	ret=dialog.GetSimpleInput(prompt)
	if ret==None:
		raise KeyboardInterrupt, "operation cancelled"
	return ret

def Win32Input(prompt=None):
	"Provide input() for gui apps"
	return eval(raw_input(prompt))

sys.modules['__builtin__'].raw_input=Win32RawInput
sys.modules['__builtin__'].input=Win32Input

def LocatePythonFile( fileName ):
	" Given a file name, return a fully qualified file name, or None "
	import nt
	# first look for the exact file as specified
	try:
		nt.stat( fileName )
	except nt.error:	# file not found...
		try:
			if fileName[0] == '/' or fileName[0]=='\\' or fileName[1]==':':
				baseName = fileName # Keep paths.... os.path.split(fileName)[1]
				if len(os.path.splitext(baseName)[1])==0:
					baseName = baseName + ".py"
			else:
				baseName = fileName
		except IndexError:
			baseName = fileName
		
		for path in sys.path:
			try:
				nt.stat( path + '/' + baseName )
				fileName = path + '/' + baseName
				break	# file exists.
			except nt.error:
				pass
		else:	# for not broken out of
			return None
	return win32ui.FullPath(fileName)

# The commands executed at import time...
#
# A special file open command for Python scripts.
def OpenPyFile( fileName, title = None ):
	""" Dont call this - use OpenFile instead! 
	Open a .py file - will search the Python path if not immediately found """
	newFileName = LocatePythonFile( fileName )
	if newFileName is None:
		win32ui.MessageBox( 'Python File not found\r\n' + fileName )
		return None
	if fileName <> newFileName:
		win32ui.SetStatusText('Located file ' + newFileName)
		# note - this call is recursive - but I know the file does exist at this
		# point.  This is to get the OpenFile normal handling on the new file name
	win32ui.GetApp().OpenDocumentFile(newFileName)

def HaveGoodGUI():
	"""Returns true if we currently have a good gui available.
	"""
	return sys.modules.has_key("startup")

def CreateDefaultGUI():
	"""Creates a default GUI environment
	"""
	global App
	import intpyapp # Bring in the default app - could be param'd later.
	App = AppBuilder() # Create the app.
	App.InitInstance() # InitInstance it	

def CheckCreateDefaultGUI():
	"""Checks and creates if necessary a default GUI environment.
	"""
	rc = HaveGoodGUI()
	if not rc:
		CreateDefaultGUI()
	return rc

# handle 8.3 filenames.
##### Win32s no longer released.
#if win32ui.IsWin32s():
#	import fatimp


