# ocxserialtest.py
#
# Sample that uses the mscomm OCX to talk to a serial
# device.

# Very simple -  queries a modem for ATI responses

import dialog
import win32ui, win32uiole
import win32con

SERIAL_SETTINGS = '19200,n,8,1'
SERIAL_PORT = 2

import mscomm32 # Generated by makepy


def MakeDlgTemplate():
    style = win32con.DS_MODALFRAME | win32con.WS_POPUP \
            | win32con.WS_VISIBLE | win32con.WS_CAPTION \
            | win32con.WS_SYSMENU | win32con.DS_SETFONT
    cs = win32con.WS_CHILD | win32con.WS_VISIBLE
    dlg = [ ["Very Basic Terminal",
             (0, 0, 350, 180), style, None, (8, "MS Sans Serif")], ]
    s = win32con.WS_TABSTOP | cs
    dlg.append(["RICHEDIT", None, 132, (5, 5, 340, 170),win32con.WS_TABSTOP | win32con.WS_VISIBLE | win32con.ES_WANTRETURN | win32con.ES_MULTILINE | win32con.ES_AUTOVSCROLL | win32con.WS_VSCROLL])
    return dlg


####################################
#
# Serial Control
#
class MySerialControl(mscomm32.OCXMSComm):
	def __init__(self, parent):
		mscomm32.OCXMSComm.__init__(self)
		self.parent = parent
	def OnComm(self):
		self.parent.OnComm()

class TestSerDialog(dialog.Dialog):
	def OnComm(self):
		event = self.olectl.CommEvent
		if event == mscomm32.OnCommConstants.comEvReceive:
			self.editwindow.ReplaceSel(self.olectl.Input)

	def OnKey(self, key):
		self.olectl.Output = chr(key)

	def OnInitDialog(self):
		print "OnInitDialog"
		rc = dialog.Dialog.OnInitDialog(self)
		self.editwindow = self.GetDlgItem(132)
		self.editwindow.HookAllKeyStrokes(self.OnKey)

		self.olectl = MySerialControl(self)
		self.olectl.CreateControl("OCX",
		                          win32con.WS_TABSTOP | win32con.WS_VISIBLE,
		                          (7,43,500,300), self._obj_, 131)
		self.olectl.Settings = SERIAL_SETTINGS
		self.olectl.CommPort = SERIAL_PORT
		self.olectl.RThreshold = 1
		self.olectl.PortOpen = 1
		return rc

	def OnDestroy(self, msg):
		self.olectl.PortOpen = 0
		return dialog.Dialog.OnDestroy(self, msg)

def test():
    d = TestSerDialog(MakeDlgTemplate() )
    d.DoModal()

if __name__ == "__main__":
    test()
