#include "stdafxole.h"

#include "win32dlg.h"
#include "win32oleDlgs.h"
#include "win32template.h"
#include "PythonCOM.h"

// Sorry about this - OLE support needs MFC private header.
// Adding MFC source path to include path causes grief!
#include "d:\msdev\mfc\src\occimpl.h"

// @doc

class WndHack : public CWnd {
public:
	COleControlSite *GetCtrlSite() {return m_pCtrlSite;}
};

// @pymethod <o PyIDispatch>|win32uiole|GetIDispatchForWindow|Gets an OCX IDispatch pointer, if the window has one!
static PyObject *
win32uiole_GetIDispatchForWindow(PyObject *self, PyObject *args)
{
	PyObject *obWnd;
	if (!PyArg_ParseTuple(args, "O:GetIDispatchForWindow", &obWnd))
		return NULL;
	WndHack *pWnd = (WndHack *)GetWndPtr(obWnd);
	if (!pWnd)
		return NULL;
	COleControlSite *pSite = pWnd->GetCtrlSite();
	if (pSite==NULL || pSite->m_pObject==NULL) {
		RETURN_ERR("There is no OLE object available");

	}
	IDispatch *disp = NULL;
	SCODE sc = pSite->m_pObject->QueryInterface(IID_IDispatch, (void**)&disp);
	if (FAILED(sc) || disp == NULL)
		RETURN_ERR("The OLE object does not support IDispatch");
	return PyCom_PyObjectFromIUnknown(disp, IID_IDispatch, FALSE);
}

// @pymethod int|win32uiole|OleGetUserCtrl|Returns the application name.
PyObject *
win32uiole_get_user_ctrl(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":OleGetUserCtrl"))
		return NULL;
	return Py_BuildValue("i", AfxOleGetUserCtrl());
}

// @pymethod int|win32uiole|OleSetUserCtrl|Sets or clears the user control flag.
PyObject *
win32uiole_set_user_ctrl(PyObject *self, PyObject *args)
{
	BOOL flag;
	if (!PyArg_ParseTuple(args,"i:OleSetUserCtrl", &flag))
		// @pyparm int|bUserCtrl||Specifies whether the user-control flag is to be set or cleared.
		return NULL;
	AfxOleSetUserCtrl(flag);
	RETURN_NONE;
}

// @module win32uiole|A module, encapsulating the Microsoft Foundation Classes OLE functionality.
static struct PyMethodDef uiole_functions[] = {
	{"CreateInsertDialog",   PyCOleInsertDialog::create, 1}, // @pymeth CreateInsertDialog|Creates a InsertObject dialog.
	{"GetIDispatchForWindow",win32uiole_GetIDispatchForWindow,1}, // @pymeth GetIDispatchForWindow|Gets an OCX IDispatch pointer, if the window has one!
	{"OleGetUserCtrl",          win32uiole_get_user_ctrl, 1}, // @pymeth OleGetUserCtrl|Retrieves the current user-control flag.
	{"OleSetUserCtrl",          win32uiole_set_user_ctrl, 1}, // @pymeth OleSetUserCtrl|Sets the current user-control flag.
	{NULL,			NULL}
};

extern "C" __declspec(dllexport) void
initwin32uiole(void)
{
  Py_InitModule("win32uiole", uiole_functions);
}
