/*

	first hack at a UI module, built using MFC V2.0 (on NT)

Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc

*/
#include "stdafx.h"
#include "win32uiHostGlue.h"
#include "win32win.h"
#include "win32control.h"
#include "win32doc.h"
#include "win32menu.h"
#include "win32dlg.h"
#include "win32dc.h"
#include "win32gdi.h"
#include "win32brush.h"
#include "win32bitmap.h"
#include "win32font.h"
#include "win32dll.h"
#include "win32splitter.h"
#include "win32toolbar.h"
#include "win32prop.h"
#include "win32template.h"
#include "win32pen.h"
#include "win32RichEdit.h"
#include "win32RichEditDocTemplate.h"
#ifdef HIER_LIST
#include "win32hl.h"
#endif
#ifdef _DEBUG_HEAP
#	include "malloc.h"		// for _heapchk
#endif

#include "sysmodule.h"

extern "C" int PyCallable_Check(PyObject *);	// python - object.c
extern DWORD DebuggerThreadFunc( LPDWORD lpdwWhatever );

static char BASED_CODE uiModName[] = "win32ui";
static char BASED_CODE errorName[] = "win32ui";

PYW_EXPORT PyObject *ui_module_error;
Win32uiHostGlue *pHostGlue = NULL;

PyObject *ReturnAPIError(const char *fn)
{
    CString msg=GetAPIErrorString((char *)fn);
    PyErr_SetString(ui_module_error,msg.GetBuffer(0));
    return NULL;
}

/////////////////////////////////////////////////////////////////////////
//
// Windows API Hook
// This is used to trap a DESTROY message.  I use this, rather than
// the Translate functions, so that a non CWnd window can still be used.
// For example, in the future, the common dialog boxes may have Python
// support, so it is critical we know when they have been destroyed.

// max speed for hook function (even when debugging!!)
#pragma optimize("2", on)
// Windows hook.
static HHOOK hhook = 0;
LRESULT CALLBACK CallWndProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	// hooking seems to slow down the system alot - go for speed
	// (but still gotta follow the rules!)
	if (nCode==HC_ACTION) {	// I can process it.
	    CWPSTRUCT *cwp = (CWPSTRUCT *)lParam;
		MSG msg;
		msg.message = cwp->message;
		msg.hwnd = cwp->hwnd;
		msg.lParam=cwp->lParam;
		msg.wParam=cwp->wParam;
		msg.time=0 ; // set these to zero - better value?
		msg.pt.x = msg.pt.y = 0;
		Python_check_message(&msg);

		if (cwp->message==WM_NCDESTROY) {	// seems to be last decent message
			CWnd *wnd=CWnd::FromHandlePermanent(cwp->hwnd);
			if (wnd)
				Python_delete_assoc( wnd );
		}
	}
	return CallNextHookEx(hhook, nCode,wParam, lParam);
}
// back to default.
#pragma optimize("", on)

BOOL HookWindowsMessages()
{
	hhook = SetWindowsHookEx(WH_CALLWNDPROC, CallWndProc,
                            (HINSTANCE) NULL, GetCurrentThreadId());
	if (!hhook)
		TRACE("Hooking windows messages failed\n");

	return (hhook!=0);
}

/////////////////////////////////////////////////////////////////////
//
// ui_type object
//
//////////////////////////////////////////////////////////////////////
struct PyMethodDef ui_base_class::empty_methods[] = {
	{NULL,	NULL}
};

ui_type ui_base_class::type( "base class", 
							NULL, 
							sizeof(ui_base_class), 
							ui_base_class::empty_methods, 
							NULL);

CMapStringToPtr *ui_type::typemap = NULL;
ui_type::ui_type( const char *name, ui_type *pBase, int typeSize, struct PyMethodDef* methodList, ui_base_class * (* thector)() )
{
// originally, this copied the typeobject of the parent, but as it is impossible
// to gurantee order of static object construction, I went this way.  This is 
// probably better, as is forces _all_ python objects have the same type sig.
	static PyTypeObject type_template = {
		PyObject_HEAD_INIT(&PyType_Type)
		0,													/*ob_size*/
		"template",											/*tp_name*/
		sizeof(ui_base_class), 								/*tp_size*/
		0,													/*tp_itemsize*/
		/* methods */
		(destructor) ui_base_class::sui_dealloc, 			/*tp_dealloc*/
		0,													/*tp_print*/
		(getattrfunc) ui_base_class::sui_getattr, 			/*tp_getattr*/
		(setattrfunc) ui_base_class::sui_setattr,			/*tp_setattr*/
		0,													/*tp_compare*/
		(reprfunc)ui_base_class::sui_repr,					/*tp_repr*/
    	0,													/*tp_as_number*/
	};

	*((PyTypeObject *)this) = type_template;
	methods = methodList;
	// cast away const, as Python doesnt use it.
	tp_name = (char *)name;
	tp_basicsize = typeSize;
	base = pBase;
	ctor = thector;
	if (!typemap) typemap = new CMapStringToPtr;
	typemap->SetAt(name, this);
}
ui_type::~ui_type()
{
	typemap->RemoveKey(tp_name);
	if (typemap->IsEmpty()) {
		delete typemap;
		typemap = NULL;
	}
}

/////////////////////////////////////////////////////////////////////
//
// base class object
//
//////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
IMPLEMENT_DYNAMIC(ui_base_class, CObject);
#endif

ui_base_class::ui_base_class()
{
	strcpy(sig, SIG);
}
ui_base_class::~ui_base_class()
{
#ifdef TRACE_LIFETIMES
	TRACE("Destructing a '%s' at %p\n", ob_type->tp_name, this);
#endif
}

ui_base_class *ui_base_class::make( ui_type &makeTypeRef)
{
	ui_type *makeType = &makeTypeRef; // use to pass ptr as param!
	if (makeType->ctor==NULL) {
		RETURN_ERR("Internal error - the type does not declare a win32ui constructor");
	}
	
	ui_base_class *pNew = (*makeType->ctor)();
	pNew->ob_type = makeType;
	_Py_NewReference(pNew);
#ifdef _DEBUG	// this is really only for internal errors, and they should be ironed out!
	if (!pNew->is_uiobject(makeType))
		RETURN_ERR("Internal error - created type isnt what was requested!");
#endif
#ifdef TRACE_LIFETIMES
	TRACE("Constructing a '%s' at %p\n",pNew->ob_type->tp_name, pNew);
#endif
	return pNew;
}
/*static*/ BOOL ui_base_class::is_uiobject(PyObject *&o, ui_type *which)
{
	ui_base_class *ob = (ui_base_class *)o;
	if (ob==NULL || ob==Py_None)
		return FALSE;
	// quick fasttrack.
	if ((ui_type *)ob->ob_type==which)
		return TRUE;
	// if Python instance, my be able to derive the paired Python type.
	if (PyInstance_Check(ob)) {
		PyObject *obattr= PyObject_GetAttrString(ob, "_obj_");
		if (obattr==NULL) {
			PyErr_Clear();
			TRACE("is_uiobject fails due to object being an instance without an _obj_ attribute!\n");
			return FALSE;
		}
		if (obattr==Py_None) {
			TRACE("is_uiobject fails due to object being an instance with _obj_==None\n");
			return FALSE;
		}
		o = obattr;
		ob = (ui_base_class *)o;
	}
	if (memcmp(ob->sig, SIG, sizeof(SIG))) {
		TRACE("is_uiobject fails due to sig failure!\n");
		return FALSE;
	}
	return is_nativeuiobject(ob, which);
}

/*static*/BOOL ui_base_class::is_nativeuiobject(PyObject *ob, ui_type *which)
{
	// check for inheritance.
	ui_type *thisType = (ui_type *)ob->ob_type;
	while (thisType) {
		if (which==thisType)
			return TRUE;
		thisType = thisType->base;
	}
	return FALSE;
}
BOOL ui_base_class::is_uiobject(ui_type *which)
{
	PyObject *cpy = this;
	BOOL ret = is_uiobject(cpy,which);
#ifdef _DEBUG
	return ret && (cpy==this);
#endif
	return ret;
}

PyObject *
ui_base_class::sui_getattr(PyObject *self, char *name)
{
	return ((ui_base_class *)self)->getattr(name);
}

PyObject *
ui_base_class::getattr(char *name)
{
	// implement inheritance.
	PyObject *retMethod = NULL;
	ui_type *thisType = (ui_type *)ob_type;
	while (thisType) {
		retMethod = Py_FindMethod(thisType->methods, (PyObject *)this, name);
		if (retMethod)
			break;
		thisType = thisType->base;
		if (thisType)
			PyErr_Clear();
	}
	return retMethod;
}
int
ui_base_class::sui_setattr(PyObject *op, char *name, PyObject *v)
{
	ui_base_class* bc = (ui_base_class *)op;
	return bc->setattr(name,v);
}
int ui_base_class::setattr(char *name, PyObject *v)
{
	char buf[128];
	sprintf(buf, "%s has read-only attributes", ob_type->tp_name );
	PyErr_SetString(PyExc_TypeError, buf);
	return -1;
}
/*static*/ PyObject *
ui_base_class::sui_repr( PyObject *op )
{
	ui_base_class* w = (ui_base_class *)op;
	CString ret = w->repr();
	return Py_BuildValue("s",(const char *)ret);
}
CString ui_base_class::repr()
{
	CString csRet;
	char *buf = csRet.GetBuffer(50);
	sprintf(buf, "object '%s'", ob_type->tp_name);
	csRet.ReleaseBuffer();
	return csRet;
}
void ui_base_class::cleanup()
{
	CString rep = repr();
	const char *szRep = rep;
	TRACE("cleanup detected %s, refcount = %d\n",szRep,ob_refcnt);
}

/*static*/ void ui_base_class::sui_dealloc(PyObject *window)
{
	delete (ui_base_class *)window;
}

#ifdef _DEBUG
void DumpAssocPyObject( CDumpContext &dc , void *object )
{
	ui_assoc_object *py_bob = ui_assoc_object::handleMgr.GetAssocObject( object );
	if (py_bob==NULL)
		dc << ", have no attached Python object";
	else {
#if !defined(_MAC) && !defined(_AFX_PORTABLE)
	try
#endif
	{
		dc << ", Python object ";
		if (AfxIsValidAddress(py_bob, sizeof(ui_assoc_object))) {
			dc << py_bob << " with refcounf " << 
			py_bob->ob_refcnt;
		} else
			dc  << "<at invalid address!>";
	}
#if !defined(_MAC) && !defined(_AFX_PORTABLE)
		catch(int code) {
			// short form for trashed objects
			afxDump << "<Bad! (" << code << ")>";
		}
		catch(...) {
			// short form for trashed objects
			afxDump << "<Bad!>";
		}
#endif
	}
}

void ui_base_class::Dump( CDumpContext &dc ) const
{
	CObject::Dump(dc);
	dc << "ref_cnt=" << ob_refcnt;
}
#endif

/////////////////////////////////////////////////////////////////////
//
// Helpers for the application.  Avoid pulling python headers everywhere.
//
/////////////////////////////////////////////////////////////////////
extern "C" void	PySys_SetPath(char *);
void PYW_EXPORT Python_addpath( const char *paths )
{
	char workBuf[MAX_PATH+20];
	char fullThisPath[MAX_PATH+20];
	char fullWorkBuf[MAX_PATH+20];
	
	PyObject *p = PySys_GetObject("path");
	if (!PyList_Check(p))
		return;

	int posFirst = 0;
	int posLast = 0;
	while (paths[posLast]) {
		// skip all ';'
		while (paths[posFirst]==';')
			posFirst++;
		posLast = posFirst;
		while (paths[posLast]!='\0' && paths[posLast]!=';')
			posLast++;
		int len = min(sizeof(workBuf)-1,posLast - posFirst);
		if (len>0) {
			strncpy(workBuf, paths+posFirst, len );
			workBuf[len]='\0';
			// Check if it is already on the path...
			if (!GetFullPath(fullWorkBuf, workBuf)) // not a valid path
				continue;	// ignore it.
			int listLen = PyList_Size(p);
			int itemNo;
			for (itemNo=0;itemNo<listLen;itemNo++) {
				char *thisPath = PyString_AsString(PyList_GetItem(p, itemNo));
				if (thisPath==NULL) return; // Serious error!!!
				if (GetFullPath(fullThisPath, thisPath) && strcmpi(fullThisPath, fullWorkBuf)==0) {
					// is there!
					break;
				}
			}
			if (itemNo>=listLen) { // not in list
				// Need to add it.
				PyObject *add = PyString_FromString(fullWorkBuf);
				if (add) {
					PyList_Insert(p, 0, add);
					Py_DECREF(add);
				}
			}
		}
		posFirst = posLast;
	}
}
int Python_run_command_with_log(const char *command, const char * logFileName)
{
	PyObject *m, *d, *v;
	m = PyImport_AddModule("__main__");
	if (m == NULL)
		return -1;
	d = PyModule_GetDict(m);
	v = PyRun_String((char *)command, file_input, d, d);
	if (v == NULL) {
		PyObject *fo = PyFile_FromString((char *)logFileName, "w" );
		if (fo==NULL)
			return -1;
        PyObject *old = PySys_GetObject( "stderr" );
		if (old==NULL)
			return -1;
		Py_INCREF(old);
		PySys_SetObject( "stderr", fo );
		PyErr_Print();
		PySys_SetObject( "stderr", old );
		Py_DECREF(old);
		Py_XDECREF(fo);
		return 1;	// indicate failure, with valid log.
	}
	DODECREF(v);
	return 0;
}

int Python_run_script(const CString &fileName)
{
	CStdioFile script;
	const char *name = fileName;
	int rc;
	if (!script.Open(fileName, CFile::modeRead))
	{
		TRACE("File not found running script '%s'\n", name);
		rc = 1;
	}
	else
		rc = PyRun_SimpleFile(script.m_pStream, (char *)name);
#ifdef _DEBUG
	if (rc)
		TRACE("run_script returned %d\n",rc);
#ifdef _DEBUG_HEAP
	// this can help track objects that I forget to Py_INCREF!!
	if (_heapchk()!=_HEAPOK)
		TRACE("Warning-heap corrupt after script %s\n",name);
#endif
#endif
	return rc;
}
void Python_delete_assoc( void *ob )
{
	// Notify Python object of my attached object removal.
	// Important that the Virtual helper does not destruct until
	// the KillAssoc has completed.
	CVirtualHelper helper ("OnAttachedObjectDeath", ob);
	helper.call();
	ui_assoc_object *pObj;
	if (pObj=ui_assoc_object::GetPyObject(ob)) {
		pObj->KillAssoc();
	}
}

void Python_set_error(const char *msg)
{
	PyErr_SetString(ui_module_error, (char *)msg);
	gui_print_error();
}
void Python_set_type_error(const char *msg)
{
	PyErr_SetString(PyExc_TypeError, (char *)msg);
	gui_print_error();
}
// In DEBUG builds, access voilations will normally trip my debugger, and
// hence I dont want them trapped.  Stack Overflows normally mean runaway Python
// code, and I dont really want these trapped.
#ifdef _DEBUG
static int bTrapAccessViolations = FALSE;
#endif

// exception handler.
static DWORD FilterFunc (DWORD dwExceptionCode) {

	// Assume that we do not know how to handle the exception
	// by telling the system to continue to search for an SEH
	// handler.
	DWORD dwRet = EXCEPTION_CONTINUE_SEARCH;
	switch (dwExceptionCode) {
		case STATUS_STACK_OVERFLOW:
			OutputDebugString("win32ui has stack overflow!\n");
			PyErr_SetString(PyExc_SystemError,"Stack Overflow");
			dwRet = EXCEPTION_EXECUTE_HANDLER;
			break;
		case EXCEPTION_ACCESS_VIOLATION:
			OutputDebugString("win32ui has access vln!\n");
#ifdef _DEBUG
			if (!bTrapAccessViolations)
				return dwRet;
#endif // _DEBUG
			PyErr_SetString(PyExc_SystemError,"Access Violation");
			dwRet = EXCEPTION_EXECUTE_HANDLER;
			break;
		default:
			break;
	}
	return(dwRet);
}

// Thread control.  Before _any_ callback into the Python interpreter,
// we must get the interpreter lock.
// BOOL bHaveSetThread = 0;	// recursion control.
PyObject *gui_call_object(PyObject *themeth, PyObject *thearglst)
{
//	BOOL bDidISetThread = !bHaveSetThread;
//	if (!bHaveSetThread) {
//		PyEval_RestoreThread(NULL);
//		bHaveSetThread = TRUE;
//	}

	PyObject *result;
//	try {
		result = PyEval_CallObject(themeth,thearglst);
//	}
/**
I think that such unconditional traps can prevent stuff like
stack traces, etc

	catch (int code) {
		TRACE("Handling exception 0x%x\n", code);
		PyErr_SetString(PyExc_SystemError,"Unhandled win32 exception");
		result = NULL;
		code; // stop unref warning in rel model
		// the exception was handled.
	}
	catch (...) {
//		TRACE("Handling exception ...\n"); ?? Fails ??
		PyErr_SetString(PyExc_SystemError,"Unhandled win32 exception");
		result = NULL;
		// the exception was handled.
	}
/*
	PyObject *result;
	__try {
		result = PyEval_CallObject(themeth,thearglst);
	}
	__except (FilterFunc(GetExceptionCode())) {
		result = NULL;
		// the exception was handled.
	}
*/
//	if (bDidISetThread) {
//		PyEval_SaveThread();
//		bHaveSetThread = FALSE;
//	}
	return result;
}

void gui_print_error(void)
{
//	BOOL bDidISetThread = !bHaveSetThread;
//	if (!bHaveSetThread) {
//		PyEval_RestoreThread(NULL);
//		bHaveSetThread = TRUE;
//	}

	// basic recursion control.
	static BOOL bInError = FALSE;
	if (bInError) return;
	bInError=TRUE;
	PyErr_Print();
	bInError=FALSE;
//	if (bDidISetThread) {
//		PyEval_SaveThread();
//		bHaveSetThread = FALSE;
//	}

}
/*void gui_decref(PyObject *ob)
{
	BOOL bDidISetThread = !bHaveSetThread;
	if (!bHaveSetThread) {
		PyEval_RestoreThread(NULL);
		bHaveSetThread = TRUE;
	}
	Py_DECREF(ob);
	if (bDidISetThread) {
		PyEval_SaveThread();
		bHaveSetThread = FALSE;
	}
}*/

// A Python program can install a callback notifier, to make all
// callbacks!
static PyObject *pCallbackCaller = NULL;
PyObject *Python_do_callback(PyObject *themeth, PyObject *thearglst)
{
	PyObject *result;
	if (pCallbackCaller) {
		PyObject *newarglst = Py_BuildValue("(OO)",themeth,thearglst);
		result = gui_call_object( pCallbackCaller, newarglst );
		DODECREF(newarglst);
	} else
		result = gui_call_object( themeth, thearglst );
	DODECREF(thearglst);
	if (result==NULL) {
		TRACE("Python_do_callback: callback failed with exception\n");
		gui_print_error();
	}
	return result;
}

int Python_do_int_callback(PyObject *themeth, PyObject *thearglst)
{
	int retVal=UINT_MAX;	// an identifiable, but unlikely genuine value.
	BOOL isError = FALSE;
	PyObject *result = Python_do_callback(themeth, thearglst);
	if (result==NULL)
		return retVal;
	if (result==Py_None)	// allow for None==0
		retVal = 0;
	else if (result != Py_None && (!PyArg_Parse(result,"i",&retVal))) {
		TRACE("Python_do_int_callback: callback had bad return type\n");
		PyErr_SetString(ui_module_error, "Callback must return an integer, or None");
		gui_print_error();
	}
#ifdef _DEBUG_HEAP	// perform some diagnostics.  May help trap reference errors.
	if (_heapchk()!=_HEAPOK)
		TRACE("**** Warning-heap corrupt after application callback ****\n");
#endif
	DODECREF(result);
	return retVal;
}
int Python_callback(PyObject *method, int val)
{
	PyObject *meth = method;
	PyObject *thearglst = Py_BuildValue("(i)",val);
	return Python_do_int_callback(meth,thearglst);
}
int Python_callback(PyObject *method, int val1, int val2)
{
	PyObject *meth = method;
	PyObject *arglst = Py_BuildValue("(ii)",val1,val2);
	return Python_do_int_callback(meth,arglst);
}

int Python_callback(PyObject *method)
{
	PyObject *meth = method;
	PyObject *arglst = Py_BuildValue("()");
	return Python_do_int_callback(meth,arglst);
}
int Python_callback(PyObject *method, const MSG *msg)
{
	PyObject *meth = method;
	PyObject *arglst = Py_BuildValue("((iiiii(ii)))",msg->hwnd,msg->message,msg->wParam,msg->lParam,msg->time,msg->pt.x,msg->pt.y);
	return Python_do_int_callback(meth,arglst);
}
int Python_callback(PyObject *method, PyObject *object)
{
	PyObject *meth = method;
	PyObject *arglst = Py_BuildValue("(O)", object);
	return Python_do_int_callback(meth,arglst);
}


/////////////////////////////////////////////////////////////////////
//
// Helpers for the methods.
//
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
//
// Python Functions etc.
//
/////////////////////////////////////////////////////////////////////
// @pymethod |win32ui|PrintTraceback|Prints a traceback using the internal Python mechanism.
PyObject *
ui_python_print_traceback( PyObject *self, PyObject *args )
{
	PyObject *tb, *output;
	// @pyparm object|tb||The traceback to print.
	// @pyparm object|output||The object to write the traceback to.
	if (!PyArg_ParseTuple(args, "OO:PrintTraceback", &tb, &output))
		return NULL;
	PyTraceBack_Print(tb,output);
	RETURN_NONE;
}

// @pymethod |win32ui|OutputDebugString|Sends a string to the Windows debugging device.
static PyObject *
ui_output_debug(PyObject *self, PyObject *args)
{
	char *msg;
	// @pyparm string|msg||The string to write.
	if (!PyArg_ParseTuple(args, "s:OutputDebugString", &msg))
		return NULL;
	GUI_BGN_SAVE;
#ifdef BULLSHIT_BUG
	CString csuiod;
	char *uiod_base = csuiod.GetBuffer(strlen(msg));
	char *uiod = uiod_base;

	while (*msg)
	{
		// not sure what's going on here.  NT seems to add a \n each call..
		// Im sure msvc16 doesnt...(well, I _think_ Im sure..:)
		while (*msg && *msg!='\n')
			*uiod++ = *msg++;
		*uiod='\0';	// replace with NULL;
		if (*msg) {	// must be \n
			uiod=uiod_base;
			OutputDebugString(uiod) ;
			++msg;
		}
	}
#else
	OutputDebugString(msg);
#endif
	GUI_END_SAVE;
	RETURN_NONE;
}

/////////////////////////////////////////////////////////////////////
//
// Python Methods etc.
//
/////////////////////////////////////////////////////////////////////
// @pymethod <o PyCMDIChildWnd>|win32ui|CreateMDIFrame|Creates an MDI Frame window.
static PyObject *
ui_create_mdi_frame(PyObject *self, PyObject *args)
{
	// @comm An MDI Frame Window is usually the main application window.
	// Therefore there is uaually only one of these windows per application.
	CHECK_NO_ARGS2(args,CreateMDIFrame);
	CWinApp *pApp = GetApp();
	if (pApp==NULL) return NULL;
	CPythonMainFrame* pMainFrame = new CPythonMainFrame;
	return ui_assoc_object::make(PyCMDIFrameWnd::type, pMainFrame)->GetGoodRet();
	// @rdesc The window object created.  An exception is raised if an error occurs.
	// @comm An application can only hae one main window.  This method will fail if the application
	// window already exists.
}
// @pymethod int|win32ui|Enable3dControls|Enables 3d controls for the application.
PyObject *
ui_enable_3d_controls(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,Enable3dControls);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	return Py_BuildValue("i", pApp->Enable3dControls());
	// @rdesc True if 3d controls could be enabled, false otherwise.
}

// @pymethod string|win32ui|GetCommandLine|Returns the application's command line.
PyObject *
ui_get_command_line (PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetCommandLine);
	return Py_BuildValue("s", ::GetCommandLine()); // @pyseeapi GetCommandLine
}

// @pymethod int|win32ui|GetInitialStateRequest|Returns the requested state that the application start in.  This is the same as the paramaters available to <om PyCWnd.ShowWindow>
PyObject *
ui_get_initial_state_request(PyObject *self, PyObject *args)
{
	// @comm In some cases, it may not be possible to start in the requested mode.  An application
	// may start in its default mode, then set its mode to match the value returned from this method.
	CHECK_NO_ARGS2(args,GetInitialStateRequest);
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;
	return Py_BuildValue("i", pApp->m_nCmdShow );
}
// @pymethod string|win32ui|GetName|Returns the name of the current executable.
PyObject *
ui_get_name(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetName);
	// MFC AppName gives title, ExeName gives module name!
	char fileName[MAX_PATH+1];

	GetModuleFileName( GetModuleHandle(NULL), fileName, sizeof(fileName));
	return Py_BuildValue("s", fileName );
}

// @pymethod tuple|win32ui|GetRect|Returns the rectangle of the main application frame.  See <om PyCWnd.GetWindowRecr> for further details.
static PyObject *
ui_get_rect(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetRect);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	CWnd *pFrame = pApp->GetMainFrame();
	if (!pFrame)
		RETURN_ERR("The frame does not exist");

	CRect rect;
	pFrame->GetWindowRect( &rect );
	return Py_BuildValue("(iiii)",rect.left, rect.top, rect.right, rect.bottom);
	// @rdesc A tuple of integers with (left, top, right, bottom)
}
// @pymethod |win32ui|WriteProfileVal|Writes a value to the application's INI file.
static PyObject *
ui_write_profile_val(PyObject *self, PyObject *args)
{
	char *sect, *entry, *strVal;
	int intVal;
	// @pyparm string|section||The section in the INI file to write to.
	// @pyparm string|entry||The entry within the section in the INI file to write to.
	// @pyparm int/string|value||The value to write. The type of this parameter determines the method's return type.
	BOOL bHaveInt = TRUE;
	if (!PyArg_ParseTuple(args, "ssi:WriteProfileVal", &sect, &entry, &intVal)) {
		bHaveInt = FALSE;
		PyErr_Clear();
		if (!PyArg_ParseTuple(args, "ssz", &sect, &entry, &strVal)) {
			// set my own error
			PyErr_Clear();
			RETURN_TYPE_ERR("WriteProfileVal must have format (ssi) or (ssz)");
		}
	}
	BOOL rc;
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;

	if (bHaveInt) {
//		TRACE("Write profile value (int)[%s] - %s=%d\n",sect,entry,intVal);
		rc = pApp->WriteProfileInt( sect, entry, intVal );
	}
	else {
//		TRACE("Write profile value (str)[%s] - %s=%s\n",sect,entry,strVal?strVal:"<NULL>");
		rc = pApp->WriteProfileString( sect, entry, strVal );
	}
	if (!rc)
		RETURN_ERR("WriteProfileInt/String failed");
	return Py_BuildValue("i",rc);
}
// @pymethod int/string|win32ui|GetProfileVal|Returns a value from the application's INI file.
static PyObject *
ui_get_profile_val(PyObject *self, PyObject *args)
{
	char *sect, *entry, *strDef;
	int intDef;
	BOOL bHaveInt = TRUE;
	// @pyparm string|section||The section in the INI file to read from.
	// @pyparm string|entry||The entry within the section in the INI file to read.
	// @pyparm int/string|defValue||The default value.  The type of this parameter determines the method's return type.
	if (!PyArg_ParseTuple(args, "ssi", &sect, &entry, &intDef)) {
		bHaveInt = FALSE;
		PyErr_Clear();
		if (!PyArg_ParseTuple(args, "sss:GetProfileVal", &sect, &entry, &strDef)) {
			// set my own error
			PyErr_Clear();
			RETURN_TYPE_ERR("GetProfileVal must have format (ssi) or (sss)");
		}
	}
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;
	if (bHaveInt)
		return Py_BuildValue("i",pApp->GetProfileInt(sect, entry, intDef ));
	else {
		CString res = pApp->GetProfileString(sect, entry, strDef );
		return Py_BuildValue("s",(const char *)res);
	}
}
// @pymethod |win32ui|SetProfileFilename|Sets the name of the INI file used by the application.
static PyObject *
ui_set_profile_filename(PyObject *self, PyObject *args)
{
	char *filename;
	// @pyparm string|filename||The name of the ini file.
	if (!PyArg_ParseTuple(args, "s:SetProfileFilename", &filename))
		return NULL;
	// this is a memory leak!
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;

	char *newBuf = strdup(filename);
	pApp->m_pszProfileName = newBuf;
	RETURN_NONE;
}
// @pymethod string|win32ui|GetProfileFileName|Returns the name of the INI file used by the application.
static PyObject *
ui_get_profile_filename(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetProfileFileName);
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;
	return Py_BuildValue("s", pApp->m_pszProfileName);
}
// @pymethod |win32ui|LoadStdProfileSettings|Loads MFC standard settings from the applications INI file.  This includes the Recent File List, etc.
static PyObject *
ui_load_std_profile_settings(PyObject *self, PyObject *args)
{
	int maxFiles = _AFX_MRU_COUNT;
	// @pyparm int|maxFiles|_AFX_MRU_COUNT|The maximum number of files to maintain on the Recently Used File list.
	if (!PyArg_ParseTuple(args, "|i:LoadStdProfileSettings", &maxFiles))
		return NULL;
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	// @comm This function can only be called once in an applications lifetime, else an exception is raised.
	if (pApp->HaveLoadStdProfileSettings())
		RETURN_ERR("The profile settings have already been loaded.");
	pApp->LoadStdProfileSettings(maxFiles);
	RETURN_NONE;
}

// @pymethod |win32ui|SetStatusText|Sets the text in the status bar of the application.
static PyObject *
ui_set_status_text(PyObject *self, PyObject *args)
{
	char *msg;
	BOOL bForce = FALSE;
	// @pyparm string|msg||The message to write to the status bar.
	// @pyparm int|bForce|0|A flag indicating if the message should be forced to the status bar, or written in idle time.
	if (!PyArg_ParseTuple(args,"s|i:SetStatusText",&msg, &bForce))
		return NULL;
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	CWnd *pWnd = pApp->GetMainFrame();
	if (pWnd==NULL)
		RETURN_ERR("There is no main window");
	if (pWnd->IsKindOf(RUNTIME_CLASS(CPythonMainFrame))) {
		CWnd &statusBar = ((CPythonMainFrame *)pWnd)->m_wndStatusBar;
		if (!::IsWindow(statusBar.m_hWnd))
			RETURN_ERR("The status bar window is invalid");
		statusBar.SetWindowText(msg);
		if (bForce) {
			statusBar.InvalidateRect(NULL);
			statusBar.UpdateWindow();
		}
	} else {
		if (pHostGlue)
			pHostGlue->SetStatusText(msg, bForce);
	}
	RETURN_NONE;
}

// @pymethod list|win32ui|GetRecentFileList|Returns the entries in the applications Recent File List.
static PyObject *
ui_get_recent_file_list(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetRecentFileList);
	PyObject *list = PyList_New(_AFX_MRU_COUNT);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	for (int i=0;i<_AFX_MRU_COUNT;i++) {
		CString csFile(pApp->GetRecentFileName(i));
		// hack to non-const for Python
		char *name = (char *)(const char *)csFile;
		PyList_SetItem(list,i,PyString_FromString(name));
	}
	return list;
	// @rdesc A list of strings containing the fully qualified file names.
}
// @pymethod |win32ui|AddToRecentFileList|Adds an entry to the applications Recent File List.
static PyObject *
ui_add_to_recent_file_list(PyObject *self, PyObject *args)
{
	// @pyparm string|fileName||The file name to be added to the list.
	char *msg;
	if (!PyArg_ParseTuple(args,"s:AddToRecentFileList",&msg))
		return NULL;
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;
    pApp->AddToRecentFileList(msg); // @pyseemfc CWinApp|AddToRecentFileList
	RETURN_NONE;
}
// @pymethod <o PyCWnd>|win32ui|GetMainFrame|Returns a window object for the main application frame.
static PyObject *
ui_get_main_frame(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetMainFrame);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	CWnd *pFrame = pApp->GetMainFrame();
	if (!pFrame)
		RETURN_ERR("The frame does not exist");
	// Do some RTTI on the object.
	ui_type &makeType = UITypeFromCObject(pFrame);
	return ui_assoc_object::make(makeType, pFrame)->GetGoodRet();
}

// @pymethod |win32ui|StartDebuggerPump|Starts a recursive message loop, waiting for an application close message.
int bIsPumping = FALSE;
BOOL bDebuggerPumpStopRequested = FALSE;
static PyObject *
ui_start_debugger_pump(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,StartDebuggerPump);
	if (bIsPumping)
		RETURN_ERR("Error starting debugger pumper - already pumping");
	bIsPumping = TRUE;
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	pApp->PumpForDebugger();
	RETURN_NONE;
	// @comm This function is used by the debugger.  It allows the debugger to
	// interact with the user, even while the Python code is stopped.
	// As the Python code may be responding to a Windows Event, this function
	// works around the inherent message queue problems.
}
// @pymethod |win32ui|StopDebuggerPump|Stops the debugger pump.  See <om win32ui.StartDebuggerPump>.
static PyObject *
ui_stop_debugger_pump(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,StopDebuggerPump);
	if (!bIsPumping)
		RETURN_ERR("Error stopping debugger pumper - pump not started");
	bIsPumping = FALSE;
	bDebuggerPumpStopRequested = TRUE; // Set this BEFORE QuitMessage
	PostQuitMessage(0);
	RETURN_NONE;
}
// @pymethod |win32ui|PumpIdle|Pumps all idle messages.
static PyObject *
ui_pump_idle(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,PumpIdle);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	pApp->PumpIdle();
	RETURN_NONE;
}

// @pymethod |win32ui|PumpWaitingMessages|Recursively start a new message dispatching loop while any message remain in the queue.
static PyObject *
ui_pump_waiting_messages(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,PumpWaitingMessages);
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	pApp->PumpWaitingMessages();
	RETURN_NONE;
	// @comm This allows an application which is performing a long operation to dispatch paint messages during the operation.
}
// @pymethod |win32ui|CreateDebuggerThread|Starts a debugging thread (ie, creates the "break" button).
static PyObject *
ui_create_debugger_thread(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,CreateDebuggerThread);
	extern HWND hwndDebugger;
	hwndDebugger = 0;
	DWORD tid;
	DWORD param = 0;
	::CreateThread(NULL, NULL, (LPTHREAD_START_ROUTINE)DebuggerThreadFunc, &param, 0, &tid );
	RETURN_NONE;
	// @comm This allows an application which is performing a long operation to dispatch paint messages during the operation.
}

// @pymethod int|win32ui|MessageBox|Display a message box.
static PyObject *
ui_message_box(PyObject * self, PyObject * args)
{
  char *message;
  long style = MB_OK;
  const char *title = NULL;
  // @pyparm string|message||The message to be displayed in the message box.
  // @pyparm string/None|title|None|The title for the message box.  If None, the applications title will be used.
  // @pyparm int|style|win32con.MB_OK|The style of the message box.
  if (!PyArg_ParseTuple(args, "s|zl:MessageBox", &message, &title, &style))
    return NULL;
  CWinApp *pApp = GetApp();
  if (pApp==NULL) return NULL;

  if (title==NULL)
  	title = pApp->m_pszAppName;
  int rc;
  GUI_BGN_SAVE;
  rc = ::MessageBox(pApp->m_pMainWnd->GetSafeHwnd(), message, title, style);
  GUI_END_SAVE;
  return Py_BuildValue("i",rc);
  // @rdesc An integer identifying the button pressed to dismiss the dialog.
}

// @pymethod string|win32ui|FullPath|Return the fully qualified path of a file name.
static PyObject *
ui_full_path(PyObject * self, PyObject * args)
{
	char *path;

	// @pyparm string|path||The path name.
	if (!PyArg_ParseTuple(args, "s:FullPath", &path))
		return NULL;
	char szOutPath[_MAX_PATH];
	if (!GetFullPath(szOutPath, path))
		RETURN_ERR("The file name is invalid");
	return Py_BuildValue("s", szOutPath);
}

// @pymethod int|win32ui|ComparePath|Compares 2 paths.
static PyObject *
ui_compare_path(PyObject * self, PyObject * args)
{
	BOOL AFXAPI AfxComparePath(LPCTSTR lpszPath1, LPCTSTR lpszPath2);
	char *path1, *path2;
	// @pyparm string|path1||The path name.
	// @pyparm string|path2||The path name.
	if (!PyArg_ParseTuple(args, "ss:ComparePath", &path1, &path2))
		return NULL;
	return Py_BuildValue("i", AfxComparePath(path1, path2));
}

// @pymethod string|win32ui|GetFileTitle|Given a file name, return its title
static PyObject *
ui_get_file_title(PyObject * self, PyObject * args)
{
	UINT AFXAPI AfxGetFileTitle(LPCTSTR lpszPathName, LPTSTR lpszTitle, UINT nMax);
	char *fname;
	// @pyparm string|fileName||The file name.
	if (!PyArg_ParseTuple(args, "s:GetFileTitle", &fname))
		return NULL;
	char buf[_MAX_FNAME+1];
	if (AfxGetFileTitle(fname, buf, sizeof(buf))!=0)
		RETURN_ERR("AfxGetFileTitle failed");
	return PyString_FromString(buf);
}


// @pymethod |win32ui|DoWaitCursor|Dispay a wait cursor.
static PyObject *
ui_do_wait_cursor(PyObject * self, PyObject * args)
{
  int code;
  // @pyparm int|code||If this parameter is 0, the original cursor is restored. If 1, a wait cursor appears. If -1, the wait cursor ends.
  if (!PyArg_ParseTuple(args, "i:DoWaitCursor", &code))
    return NULL;
  CWinApp *pApp = GetApp();
  if (!pApp) return NULL;

  GUI_BGN_SAVE;
  pApp->DoWaitCursor(code);
  GUI_END_SAVE;
  RETURN_NONE;
}

// @pymethod object|win32ui|InstallCallBackCaller|Install a Python method which will dispatch all callbacks into Python.
static PyObject *
ui_install_callback_caller(PyObject *self, PyObject *args)
{
	PyObject *caller = NULL;
	if (!PyArg_ParseTuple(args,"|O:InstallCallBackCaller",&caller))
		return NULL;
	PyObject *retval = pCallbackCaller;
	if (caller==Py_None)
		caller = NULL;
	Py_XDECREF(pCallbackCaller);
	if (caller) {
		if (!PyCallable_Check(caller))
			RETURN_ERR("Argument must be a callable object");
		pCallbackCaller = caller;
		Py_INCREF(caller);
	} else
		pCallbackCaller = NULL;
	if (retval)
		return Py_BuildValue("O", retval);
	else
		RETURN_NONE;
	// @rdesc The previous callback caller.
}

// @pymethod int|win32ui|IsWin32s|Determines if the application is running under Win32s.
static PyObject *
ui_is_win32s(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,IsWin32s);
	return Py_BuildValue("i", IsWin32s());
}
// @pymethod int|win32ui|IsObject|Determines if the passed object is a win32ui object.
static PyObject *
ui_is_object(PyObject *self, PyObject *args)
{
  PyObject *obj;
  // @pyparm object|o||The object to check.
  if (!PyArg_ParseTuple(args, "O:IsObject", &obj))
    return NULL;
  return Py_BuildValue("i", ui_base_class::is_nativeuiobject(obj,&ui_base_class::type) ? 1 : 0 );
}

// @pymethod <o PyDLL>|win32ui|GetResource|Retrieve the object associated with the applications resources.
static PyObject *
ui_get_resource(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,GetResource);
	HINSTANCE dll = AfxGetResourceHandle();
	dll_object *ret = (dll_object *)ui_assoc_object::make(dll_object::type, dll)->GetGoodRet();
	return ret;
}
// @pymethod <o PyDLL>|win32ui|SetResource|Specifies the default DLL object for application resources.
static PyObject *
ui_set_resource(PyObject *self, PyObject *args)
{
	PyObject *obDLL;
	HINSTANCE hMod;
	if (!PyArg_ParseTuple(args,"O:SetResource",
	           &obDLL)) // @pyparm <o PyDll>|dll||The dll object to use for default resources.
		return NULL;
	if (!ui_base_class::is_uiobject(obDLL, &dll_object::type))
		RETURN_TYPE_ERR("passed object must be a PyDLL");
	hMod = ((dll_object *)obDLL)->GetDll();
	if (hMod==NULL)
		RETURN_ERR("Can not set resource to an uninitialised DLL object");
	// setup for return value
	HINSTANCE oldDll = AfxGetResourceHandle();
	dll_object *ret = (dll_object *)ui_assoc_object::make(dll_object::type, oldDll)->GetGoodRet();
	AfxSetResourceHandle(hMod);
	return ret;
	// @rdesc The previous default DLL object.
}

// @pymethod |win32ui|WinHelp|Invokes the Windows Help system.
static PyObject *
ui_win_help( PyObject *self, PyObject *args )
{
	UINT cmd = HELP_CONTEXT;
	PyObject *dataOb;
	DWORD data;
	if (!PyArg_ParseTuple(args, "isi|i:WinHelp",
			  &dataOb,   // @pyparm int/string|data|0|Additional data specific to the help call.
			  &cmd))    // @pyparm int|cmd|win32con.HELP_CONTEXT|The type of help.  See the api for full details.
		return NULL;
	if (PyString_Check(dataOb))
		data = (DWORD)PyString_AsString(dataOb);
	else if (PyInt_Check(dataOb))
		data = (DWORD)PyInt_AsLong(dataOb);
	else {
		RETURN_TYPE_ERR("First argument must be a string or an integer.");
	}
	CWinApp *pApp = GetApp();
	if (!pApp) return NULL;
		
	pApp->WinHelp(data, cmd);
	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |win32ui|SetRegistryKey|Causes application settings to be stored in the registry instead of INI files.
static PyObject *
ui_set_registry_key(PyObject *self, PyObject *args)
{
	char *szKey;
	if (!PyArg_ParseTuple(args,"s:SetRegistryKey",&szKey)) // @pyparm string|key||A string containing the name of the key.
		return NULL;
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	pApp->SetRegistryKey(szKey);
	// @comm Causes application settings to be stored in the registry instead of INI files. This function sets m_pszRegistryKey, which
	// is then used by the GetProfileXXX and WriteProfileXXX member functions of CWinApp. If this function has been
	// called, the list of most recently-used (MRU) files is also stored in the registry. The registry key is usually the name of a
	// company. It is stored in a key of the following form:
	// HKEY_CURRENT_USER\\Software\\\<company name\>\\\<application name\>\\\<section name\>\\\<value name\>.
	RETURN_NONE;
}

// @pymethod int|win32ui|SetDialogBkColor|Sets the default background and text color for dialog boxes and message boxes within the application.
PyObject *
ui_set_dialog_bk_color(PyObject *self, PyObject *args)
{
	int clrCtlBk = RGB(192, 192, 192);
	int clrCtlText = RGB(0, 0, 0);

	// @pyparm int|clrCtlBk|win32ui.RGB(192, 192, 192)|The color for the controls background.
	// @pyparm int|clrCtlText|win32ui.RGB(0, 0, 0)|The color for the controls text.
	if (!PyArg_ParseTuple(args,"|ii:SetDialogBkColor", &clrCtlBk, &clrCtlText))
		return NULL;
	CProtectedWinApp *pApp = GetProtectedApp();
	if (!pApp) return NULL;
	pApp->SetDialogBkColor(clrCtlBk, clrCtlText);
	RETURN_NONE;
	// @pyseemfc CWinApp|SetDialogBkColor
}

// @pymethod int|win32ui|RegisterInstanceHandler|Registers a specific instance as able to process remote command lines.
PyObject *
ui_reg_instance_handler(PyObject *self, PyObject *args)
{
	char *cmdPrefix;
	HWND hwnd;

	// @pyparm string|cmdLinePrefix||The command line prefix that this instance can accept.
	// @pyparm int|hWnd||The main window handle to receive the notification.
	if (!PyArg_ParseTuple(args,"si:RegisterInstanceHandler", &cmdPrefix, (int *)(&hwnd) ))
		return NULL;
	if (!IsWindow(hwnd))
		RETURN_ERR("The window handle is not valid");
	if (pHostGlue==NULL)
		RETURN_ERR("There is no host application");
	const char *ret = pHostGlue->RegisterInstanceHandler(cmdPrefix, hwnd);
	if (ret)
		RETURN_ERR((char *)ret);
	RETURN_NONE;
}

// @pymethod int|win32ui|EnableControlContainer|Enables support for containment of OLE controls.
PyObject *
ui_enable_control_container(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":EnableControlContainer"))
		return NULL;
	AfxEnableControlContainer();
	RETURN_NONE;
}

// @pymethod int|win32ui|GetAppName|Returns the application name.
PyObject *
ui_get_app_name(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":GetAppName"))
		return NULL;
	return Py_BuildValue("s", AfxGetAppName());
}

// @pymethod int|win32ui|IsDebug|Returns a flag indicating if the current win32ui build is a DEBUG build.
PyObject *
ui_is_debug(PyObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,":IsDebug"))
		return NULL;
#ifdef _DEBUG
	return PyInt_FromLong(1);
#else
	return PyInt_FromLong(0);
#endif
	// @comm This should not normally be of relevance to the Python
	// programmer.  However, under certain circumstances Python code may
	// wish to detect this.
}


extern PyObject *ui_get_dialog_resource( PyObject *, PyObject *args );
extern PyObject *ui_create_app( PyObject *, PyObject *args );
extern PyObject *ui_get_app( PyObject *, PyObject *args );
extern PyObject *PyCButton_create(PyObject *self, PyObject *args);
extern PyObject *PyCImageList_Create(PyObject *self, PyObject *args);
extern PyObject *PyCRichEditCtrl_create(PyObject *self, PyObject *args);

/* List of functions exported by this module */

// @module win32ui|A module, encapsulating the Microsoft Foundation Classes.
static struct PyMethodDef ui_functions[] = {
	{"AddToRecentFileList",		ui_add_to_recent_file_list,	1}, // @pymeth AddToRecentFileList|Add a file name to the Recent File List.
	{"ComparePath",				ui_compare_path,	1}, // @pymeth ComparePath|Compares 2 paths.
	{"CreateMDIFrame",			ui_create_mdi_frame,	1}, // @pymeth CreateMDIFrame|Creates an MDI Frame window.
	{"CreateBitmap",			ui_bitmap::create,	1}, // @pymeth CreateBitmap|Create a bitmap object.
	{"CreateBitmapFromHandle",	ui_bitmap::create_from_handle,	1}, // @pymeth CreateBitmapFromHandle|Creates a bitmap object from a HBITMAP.
	{"CreateBrush",             PyCBrush::create, 1}, // @pymeth CreateBrush|Creates a new GDI brush object.  Returns a <o PyCBrush> object.
	{"CreateButton",            PyCButton_create, 1}, // @pymeth CreateButton|Creates a button object.  <om PyCButton.CreateWindow> creates the actual control.
	{"CreateColorDialog",       PyCColorDialog::create, 1}, // @pymeth CreateColorDialog|Creates a color selection dialog box.
	{"CreateControl",           PyCWnd::CreateControl, 1}, // @pymeth CreateControl|Creates an OLE control.
	{"CreateDC",                ui_dc_object::create_dc, 1}, // @pymeth CreateDC|Creates a <o PyCDC> object.
	{"CreateDialog",			PyCDialog::create,	1}, // @pymeth CreateDialog|Creates a <o PyCDialog> object.
	{"CreateDialogIndirect",	PyCDialog::createIndirect, 1}, // @pymeth CreateDialogIndirect|Creates a <o PyCDialog> object from a template.
	{"CreateDocTemplate",       PyCDocTemplate::create, 1}, // @pymeth CreateDocTemplate|Create a <o PyCDocTemplate> object.
	{"CreateFileDialog",		PyCFileDialog::ui_file_dialog_create,	1}, // @pymeth CreateFileDialog|Creates a FileOpen common dialog.
	{"CreateFontDialog",		PyCFontDialog::ui_font_dialog_create,	1}, // @pymeth CreateFontDialog|Creates a font selection dialog box.
	{"CreateFormView",			PyCFormView::create,	1}, // @pymeth CreateFormView|Creates a form view object.
#ifdef HIER_LIST
	{"CreateHierList",			ui_hierlist_object::create,	1}, // @pymeth CreateHierList|Creates a hierarchical listbox.
#endif
	{"CreateImageList",			PyCImageList_Create,	1}, // @pymeth CreateImageList|Creates an <o PyCImageList> object.
	{"CreateListView",			PyCListView::create,	1}, // @pymeth CreateListView|Creates a <o PyCListView> object.
	{"CreateTreeView",			PyCTreeView::create,	1}, // @pymeth CreateTreeView|Creates a <o PyCTreeView> object.
	{"CreatePopupMenu",			PyCMenu::create_popup,	1}, // @pymeth CreatePopupMenu|Creates a popup menu.
	{"CreateMenu",				PyCMenu::create_menu,	1}, // @pymeth CreateMenu|Creates a menu
	{"CreatePen",				ui_pen_object::create,	1}, // @pymeth CreatePen|Creates a <o PyCPen> object.
	{"CreatePropertyPage",		PyCPropertyPage::create,		1}, // @pymeth CreatePropertyPage|Creates a <o PyCPropertyPage> object.
	{"CreatePropertyPageIndirect", PyCPropertyPage::createIndirect, 1}, // @pymeth CreatePropertyPageIndirect|Creates a <o PyCPropertyPage> object from a template.
	{"CreatePropertySheet",		PyCPropertySheet::create,	1}, // @pymeth CreatePropertySheet|Creates a <o PyCPropertySheet> object
	{"CreateRichEditCtrl",	    PyCRichEditCtrl_create,	1}, // @pymeth CreateRichEditCtrl|Creates a rich edit control.
	{"CreateRichEditDocTemplate", PyCRichEditDocTemplate::create, 1}, // @pymeth CreateRichEditDocTemplate|Create a <o PyCRichEditDocTemplate> object.
	{"CreateRichEditView",		PyCRichEditView::create,	1}, // @pymeth CreateRichEditView|Creates a <o PyCRichEditView> object.
	{"CreateSplitter",			PyCSplitterWnd::create,	1}, // @pymeth CreateSplitter|Creates a splitter window.
	{"CreateFont",				PyCFont::create,	1}, // @pymeth CreateFont|Creates a <o PyCFont> object.
	{"CreateToolBar",			PyCToolBar::create,	1}, // @pymeth CreateToolBar|Creates a toolbar object.
	{"CreateView",				PyCScrollView::create,		1}, // @pymeth CreateView|Creates a <o Pyiew> object.
	{"CreateEditView",			PyCEditView::create,	1}, // @pymeth CreateEditView|Creates an <o PyCEditView> object.
	{"CreateDebuggerThread",    ui_create_debugger_thread, 1}, // @pymeth CreateDebuggerThread|Starts a debugging thread.
	{"CreateWindowFromHandle",  PyCWnd::CreateWindowFromHandle, 1}, // @pymeth CreateWindowFromHandle|Creates a <o PyCWnd> from an integer containing a HWND
	{"DoWaitCursor",			ui_do_wait_cursor,	1}, // @pymeth DoWaitCursor|Changes the cursor to/from a wait cursor.
	{"Enable3dControls",		ui_enable_3d_controls, 1 }, // @pymeth Enable3dControls|Enables 3d controls for the application.
	{"FindWindow",				PyCWnd::FindWindow,	1}, // @pymeth FindWindow|Searches for the specified top-level window
	{"FindWindowEx",			PyCWnd::FindWindowEx,	1}, // @pymeth FindWindowEx|Searches for the specified top-level or child window
	{"FullPath",				ui_full_path,	1}, // @pymeth FullPath|Returns the full path name of the file.
	{"GetActiveWindow",			PyCWnd::GetActiveWindow, 1}, // @pymeth GetActiveWindow|Retrieves the active window.
	{"GetApp",                  ui_get_app, 1 },    // @pymeth GetApp|Retrieves the application object.
	{"GetAppName",              ui_get_app_name, 1 },    // @pymeth GetAppName|Retrieves the name of the current application.
	{"GetCommandLine",			ui_get_command_line,	1}, // @pymeth GetCommandLine|Returns the command line for hte application.
	{"GetFileTitle",            ui_get_file_title, 1}, // @pymeth GetFileTitle|Given a file name, return its title
	{"GetInitialStateRequest",	ui_get_initial_state_request,	1}, // @pymeth GetInitialStateRequest|Returns the requested state that the application start in.  This is the same as the paramaters available to <om PyCWnd.ShowWindow>
	{"GetMainFrame",            ui_get_main_frame,	1}, // @pymeth GetMainFrame|Returns a window object for the main application frame.
	{"GetName",					ui_get_name,	1}, // @pymeth GetName|Returns the name of the current application.
	{"GetProfileFileName",		ui_get_profile_filename,	1}, // @pymeth GetProfileFileName|Returns the name of the INI file used by the application.
	{"GetProfileVal",			ui_get_profile_val,	1}, // @pymeth GetProfileVal|Returns a value from the applications INI file.
	{"GetRecentFileList",		ui_get_recent_file_list,	1}, // @pymeth GetRecentFileList|Returns the recent file list.
	{"GetResource",				ui_get_resource,		1}, // @pymeth GetResource|Gets a resource.
    {"InstallCallbackCaller",	ui_install_callback_caller,	1}, // @pymeth InstallCallbackCaller|Installs a callback caller.
	{"IsDebug",				    ui_is_debug, 1}, // @pymeth IsDebug|Returns a flag indicating if the current win32ui build is a DEBUG build.
	{"IsWin32s",				ui_is_win32s, 1}, // @pymeth IsWin32s|Determines if the application is running under Win32s.
	{"IsObject",				ui_is_object, 1}, // @pymeth IsObject|Determines if the passed object is a win32ui object.
	{"LoadDialogResource",		ui_get_dialog_resource,		1}, // @pymeth LoadDialogResource|Loads a dialog resource, and returns a list detailing the objects.
    {"LoadLibrary",				dll_object::create,	1}, // @pymeth LoadLibrary|Creates a <o PyDLL> object.
	{"LoadMenu",				PyCMenu::load_menu,	1}, // @pymeth LoadMenu|Loads a menu.
	{"LoadStdProfileSettings",	ui_load_std_profile_settings,	1}, // @pymeth LoadStdProfileSettings|Loads standard application profile settings.
	{"MessageBox",				ui_message_box,	1}, // @pymeth MessageBox|Displays a message box.
	{"OutputDebug",				ui_output_debug,	1},
	{"OutputDebugString",		ui_output_debug,	1}, // @pymeth OutputDebugString|Writes output to the Windows debugger.
	{"EnableControlContainer",  ui_enable_control_container, 1, }, // @pymeth EnableControlContainer|Call this function in your application object's InitInstance function to enable support for containment of OLE controls.
	{"PrintTraceback", 			ui_python_print_traceback,	1}, // @pymeth PrintTraceback|Prints a Traceback using the default Python traceback printer.
	{"PumpWaitingMessages",		ui_pump_waiting_messages, 1}, // @pymeth PumpWaitingMessages|Pumps all waiting messages to the application.
	{"PumpIdle",                ui_pump_idle,         1}, // @pymeth PumpIdle|Pumps idle messages.
	{"RegisterInstanceHandler", ui_reg_instance_handler, 1}, // @pymeth RegisterInstanceHandler|Registers a specific instance as able to process remote command lines.
	{"SetDialogBkColor",        ui_set_dialog_bk_color, 1}, // @pymeth SetDialogBkColor|Sets the default background and text color for dialog boxes and message boxes within the application.
	{"SetProfileFileName",		ui_set_profile_filename,	1}, // @pymeth SetProfileFileName|Sets the INI file name used by the application.
	{"SetRegistryKey",          ui_set_registry_key, 1 }, // @pymeth SetRegistryKey|Causes application settings to be stored in the registry instead of INI files.
	{"SetResource",				ui_set_resource,		1}, // @pymeth SetResource|Specifies the default DLL object for application resources.
	{"SetStatusText",			ui_set_status_text,	1}, // @pymeth SetStatusText|Sets the text in the status bar.
	{"StartDebuggerPump",		ui_start_debugger_pump,	1}, // @pymeth StartDebuggerPump|Starts the debugger message pump.
	{"StopDebuggerPump",		ui_stop_debugger_pump,	1}, // @pymeth StopDebuggerPump|Stops the debugger message pump.
	{"WinHelp",					ui_win_help,	1}, // @pymeth WinHelp|Invokes the Window Help engine.
	{"WriteProfileVal",			ui_write_profile_val,	1}, // @pymeth WriteProfileVal|Writes a value to the INI file.

	{NULL,			NULL}
};

/* Initialize this module. */
int AddConstant(PyObject *dict, char *key, int value)
{
	PyObject *okey = PyString_FromString(key);
	PyObject *oval = PyInt_FromLong(value);
	if (!okey || !oval) {
		XDODECREF(okey);
		XDODECREF(oval);
		return 1;
	}
	int rc = PyDict_SetItem(dict,okey, oval);
	DODECREF(okey);
	DODECREF(oval);
	return rc;
}
/* Initialize this module. */
int AddConstant(PyObject *dict, char *key, long value)
{
	PyObject *okey = PyString_FromString(key);
	PyObject *oval = PyLong_FromLong(value);
	if (!okey || !oval) {
		XDODECREF(okey);
		XDODECREF(oval);
		return 1;
	}
	int rc = PyDict_SetItem(dict,okey, oval);
	DODECREF(okey);
	DODECREF(oval);
	return rc;
}
#define ADD_CONSTANT(tok) if (rc=AddConstant(dict,#tok, tok)) return rc
#define ADD_ENUM(parta, partb) if (rc=AddConstant(dict,#parta "_" #partb, parta::partb)) return rc
#define ADD_ENUM3(parta, partb, partc) if (rc=AddConstant(dict,#parta "_" #partb "_" #partc, parta::partb::partc)) return rc

int AddConstants(PyObject *dict)
{
	int rc;
	ADD_CONSTANT(AFX_IDW_PANE_FIRST); // @const win32ui|AFX_IDW_PANE_FIRST|Id of the first splitter pane
	ADD_CONSTANT(AFX_IDW_PANE_LAST);  // @const win32ui|AFX_IDW_PANE_LAST|Id of the last splitter pane
	ADD_CONSTANT(FWS_ADDTOTITLE);     // @const win32ui|FWS_ADDTOTITLE|MFC Frame Window style extension.  Add document title to window title.
	ADD_CONSTANT(FWS_PREFIXTITLE);    // @const win32ui|FWS_PREFIXTITLE|MFC Frame Window style extension.
	ADD_CONSTANT(FWS_SNAPTOBARS);     // @const win32ui|FWS_SNAPTOBARS|MFC Frame Window style extension.

	ADD_CONSTANT(IDD_ABOUTBOX);       // @const win32ui|IDD_ABOUTBOX|Id of built in 'About Box' dialog
	ADD_CONSTANT(IDD_DUMMYPROPPAGE);  // @const win32ui|IDD_DUMMYPROPPAGE|Id of built in dummy property page
	ADD_CONSTANT(IDD_FILE_TYPE);	  // @const win32ui|IDD_FILE_TYPE|Id of built in 'File Type' dialog
	ADD_CONSTANT(IDD_PROPDEMO1);	  // @const win32ui|IDD_PROPDEMO1|Id of built in Property Page demo dialog 1
	ADD_CONSTANT(IDD_PROPDEMO2);	  // @const win32ui|IDD_PROPDEMO2|Id of built in Property Page demo dialog 2
	ADD_CONSTANT(IDB_HIERFOLDERS);	  // @const win32ui|IDB_HIERFOLDERS|Id of built in bitmap for default hierarchical list
	ADD_CONSTANT(IDB_BROWSER_HIER);	  // @const win32ui|IDB_BROWSER_HIER|Id of built in bitmap for the browser
	ADD_CONSTANT(IDD_GENERAL_STATUS); // @const win32ui|IDD_GENERAL_STATUS|Id of a general status dialog box (fairly small, 3 static controls, minimize box)
	ADD_CONSTANT(IDD_LARGE_EDIT);	  // @const win32ui|IDD_LARGE_EDIT|Id of built in 'Large Edit' dialog (dialog box with a large edit control)
	ADD_CONSTANT(IDD_TREE);	  // @const win32ui|IDD_TREE|Id of built in dialog with a tree control.
	ADD_CONSTANT(IDD_TREE_MB);// @const win32ui|IDD_TREE_MB|Id of built in dialog with a tree control with multiple buttons.
	ADD_CONSTANT(IDD_RUN_SCRIPT);	  // @const win32ui|IDD_RUN_SCRIPT|Id of built in 'Run Script' dialog
	ADD_CONSTANT(IDD_SIMPLE_INPUT);	  // @const win32ui|IDD_SIMPLE_INPUT|Id of built in 'Simple Input' dialog
	ADD_CONSTANT(IDD_SET_TABSTOPS);  // @const win32ui|IDD_SET_TABSTOPS|Id of built in 'Set Tab Stops' dialog
	ADD_CONSTANT(IDC_ABOUT_COPYRIGHT);// @const win32ui|IDC_ABOUT_COPYRIGHT|Id of 'Python Copyright' control
	ADD_CONSTANT(IDC_ABOUT_COPYRIGHT_GUI); // @const win32ui|IDC_ABOUT_COPYRIGHT_GUI|Id of 'GUI Copyright' control
	ADD_CONSTANT(IDC_BUTTON1);		  // @const win32ui|IDC_BUTTON1|
	ADD_CONSTANT(IDC_BUTTON2);		  // @const win32ui|IDC_BUTTON2|
	ADD_CONSTANT(IDC_BUTTON3);		  // @const win32ui|IDC_BUTTON3|
	ADD_CONSTANT(IDC_EDIT1);		  // @const win32ui|IDC_EDIT1|
	ADD_CONSTANT(IDC_EDIT2);// @const win32ui|IDC_EDIT2|
	ADD_CONSTANT(IDC_EDIT3);// @const win32ui|IDC_EDIT3|
	ADD_CONSTANT(IDC_EDIT4);// @const win32ui|IDC_EDIT4|
	ADD_CONSTANT(IDC_EDIT_TABS);// @const win32ui|IDC_EDIT_TABS|
	ADD_CONSTANT(IDC_LIST_FILETYPES);// @const win32ui|IDC_LIST_FILETYPES|
	ADD_CONSTANT(IDC_LIST1);// @const win32ui|IDC_LIST1|
	ADD_CONSTANT(IDC_PROMPT_TABS);// @const win32ui|IDC_PROMPT_TABS|
	ADD_CONSTANT(IDC_PROMPT1);// @const win32ui|IDC_PROMPT1|
	ADD_CONSTANT(IDC_PROMPT2);// @const win32ui|IDC_PROMPT2|
	ADD_CONSTANT(IDC_PROMPT3);// @const win32ui|IDC_PROMPT3|
	ADD_CONSTANT(IDC_PROMPT4);// @const win32ui|IDC_PROMPT4|
	ADD_CONSTANT(ID_FILE_NEW);// @const win32ui|ID_FILE_NEW|
    ADD_CONSTANT(ID_FILE_OPEN);// @const win32ui|ID_FILE_OPEN|
    ADD_CONSTANT(ID_FILE_CLOSE);// @const win32ui|ID_FILE_CLOSE|
	ADD_CONSTANT(ID_FILE_RUN);// @const win32ui|ID_FILE_RUN|
	ADD_CONSTANT(ID_FILE_IMPORT);// @const win32ui|ID_FILE_IMPORT|
    ADD_CONSTANT(ID_FILE_LOCATE);// @const win32ui|ID_FILE_LOCATE|
    ADD_CONSTANT(ID_FILE_SAVE);// @const win32ui|ID_FILE_SAVE|
    ADD_CONSTANT(ID_FILE_SAVE_AS);// @const win32ui|ID_FILE_SAVE_AS|
    ADD_CONSTANT(ID_FILE_PAGE_SETUP);// @const win32ui|ID_FILE_PAGE_SETUP|
    ADD_CONSTANT(ID_FILE_PRINT_SETUP);// @const win32ui|ID_FILE_PRINT_SETUP|
    ADD_CONSTANT(ID_FILE_PRINT);// @const win32ui|ID_FILE_PRINT|
    ADD_CONSTANT(ID_FILE_PRINT_PREVIEW);// @const win32ui|ID_FILE_PRINT_PREVIEW|
	ADD_CONSTANT(ID_HELP_PYTHON);// @const win32ui|ID_HELP_PYTHON|
	ADD_CONSTANT(ID_HELP_GUI_REF);// @const win32ui|ID_HELP_GUI_REF|
	ADD_CONSTANT(ID_HELP_OTHER);// @const win32ui|ID_HELP_OTHER|
    ADD_CONSTANT(ID_APP_ABOUT);// @const win32ui|ID_APP_ABOUT|
    ADD_CONSTANT(ID_APP_EXIT);// @const win32ui|ID_APP_EXIT|
    ADD_CONSTANT(ID_FILE_MRU_FILE1);// @const win32ui|ID_FILE_MRU_FILE1|
    ADD_CONSTANT(ID_FILE_MRU_FILE2);// @const win32ui|ID_FILE_MRU_FILE2|
    ADD_CONSTANT(ID_FILE_MRU_FILE3);// @const win32ui|ID_FILE_MRU_FILE3|
    ADD_CONSTANT(ID_FILE_MRU_FILE4);// @const win32ui|ID_FILE_MRU_FILE4|
    ADD_CONSTANT(ID_VIEW_BROWSE);// @const win32ui|ID_VIEW_BROWSE|
    ADD_CONSTANT(ID_VIEW_INTERACTIVE);// @const win32ui|ID_VIEW_INTERACTIVE|
    ADD_CONSTANT(ID_NEXT_PANE);// @const win32ui|ID_NEXT_PANE|
    ADD_CONSTANT(ID_PREV_PANE);// @const win32ui|ID_PREV_PANE|
    ADD_CONSTANT(ID_WINDOW_NEW);// @const win32ui|ID_WINDOW_NEW|
    ADD_CONSTANT(ID_WINDOW_ARRANGE);// @const win32ui|ID_WINDOW_ARRANGE|
    ADD_CONSTANT(ID_WINDOW_CASCADE);// @const win32ui|ID_WINDOW_CASCADE|
    ADD_CONSTANT(ID_WINDOW_TILE_HORZ);// @const win32ui|ID_WINDOW_TILE_HORZ|
    ADD_CONSTANT(ID_WINDOW_TILE_VERT);// @const win32ui|ID_WINDOW_TILE_VERT|
    ADD_CONSTANT(ID_WINDOW_SPLIT);// @const win32ui|ID_WINDOW_SPLIT|
    ADD_CONSTANT(ID_EDIT_CLEAR);// @const win32ui|ID_EDIT_CLEAR|
    ADD_CONSTANT(ID_EDIT_CLEAR_ALL);// @const win32ui|ID_EDIT_CLEAR_ALL|
    ADD_CONSTANT(ID_EDIT_COPY);// @const win32ui|ID_EDIT_COPY|
    ADD_CONSTANT(ID_EDIT_CUT);// @const win32ui|ID_EDIT_CUT|
    ADD_CONSTANT(ID_EDIT_FIND);// @const win32ui|ID_EDIT_FIND|
    ADD_CONSTANT(ID_EDIT_PASTE);// @const win32ui|ID_EDIT_PASTE|
    ADD_CONSTANT(ID_EDIT_REPEAT);// @const win32ui|ID_EDIT_REPEAT|
    ADD_CONSTANT(ID_EDIT_REPLACE);// @const win32ui|ID_EDIT_REPLACE|
    ADD_CONSTANT(ID_EDIT_SELECT_ALL);// @const win32ui|ID_EDIT_SELECT_ALL|
    ADD_CONSTANT(ID_EDIT_SELECT_BLOCK);// @const win32ui|ID_EDIT_SELECT_BLOCK|
    ADD_CONSTANT(ID_EDIT_UNDO);// @const win32ui|ID_EDIT_UNDO|
    ADD_CONSTANT(ID_EDIT_REDO);// @const win32ui|ID_EDIT_REDO|
    ADD_CONSTANT(ID_VIEW_TOOLBAR);// @const win32ui|ID_VIEW_TOOLBAR|
    ADD_CONSTANT(ID_VIEW_STATUS_BAR);// @const win32ui|ID_VIEW_STATUS_BAR|
    ADD_CONSTANT(ID_SEPARATOR);// @const win32ui|ID_SEPARATOR|

	ADD_CONSTANT(IDR_PYTHONTYPE_CNTR_IP);// @const win32ui|IDR_PYTHONTYPE_CNTR_IP|
    ADD_CONSTANT(IDR_MAINFRAME);// @const win32ui|IDR_MAINFRAME|
    ADD_CONSTANT(IDR_PYTHONTYPE);// @const win32ui|IDR_PYTHONTYPE|
    ADD_CONSTANT(IDR_PYTHONCONTYPE);// @const win32ui|IDR_PYTHONCONTYPE|
    ADD_CONSTANT(IDR_TEXTTYPE);// @const win32ui|IDR_TEXTTYPE|
    ADD_ENUM(CDocTemplate,windowTitle);// @const win32ui|CDocTemplate_windowTitle|
    ADD_ENUM(CDocTemplate,docName);// @const win32ui|CDocTemplate_docName|
    ADD_ENUM(CDocTemplate,fileNewName);// @const win32ui|CDocTemplate_fileNewName|
    ADD_ENUM(CDocTemplate,filterName);// @const win32ui|CDocTemplate_filterName|
    ADD_ENUM(CDocTemplate,filterExt);// @const win32ui|CDocTemplate_filterExt|
    ADD_ENUM(CDocTemplate,regFileTypeId);// @const win32ui|CDocTemplate_regFileTypeId|
    ADD_ENUM(CDocTemplate,regFileTypeName);// @const win32ui|CDocTemplate_regFileTypeName|

    ADD_ENUM3(CDocTemplate, Confidence, noAttempt); // @const win32ui|CDocTemplate_Confidence_noAttempt|
    ADD_ENUM3(CDocTemplate, Confidence, maybeAttemptForeign); // @const win32ui|CDocTemplate_Confidence_maybeAttemptForeign|
    ADD_ENUM3(CDocTemplate, Confidence, maybeAttemptNative); // @const win32ui|CDocTemplate_Confidence_maybeAttemptNative|
    ADD_ENUM3(CDocTemplate, Confidence, yesAttemptForeign); // @const win32ui|CDocTemplate_Confidence_yesAttemptForeign|
    ADD_ENUM3(CDocTemplate, Confidence, yesAttemptNative); // @const win32ui|CDocTemplate_Confidence_yesAttemptNative|
    ADD_ENUM3(CDocTemplate, Confidence, yesAlreadyOpen); // @const win32ui|CDocTemplate_Confidence_yesAlreadyOpen|

    ADD_ENUM(CRichEditView,WrapNone);// @const win32ui|CRichEditView_WrapNone|
    ADD_ENUM(CRichEditView,WrapToWindow);// @const win32ui|CRichEditView_WrapToWindow|
    ADD_ENUM(CRichEditView,WrapToTargetDevice);// @const win32ui|CRichEditView_WrapToTargetDevice|

/**
	ADD_CONSTANT();
***/
	return rc;
}

extern "C" __declspec(dllexport) void
initwin32ui(void)
{
  PyObject *dict, *module;
  module = Py_InitModule(uiModName, ui_functions);
  dict = PyModule_GetDict(module);
  ui_module_error = PyString_FromString(errorName);
  PyDict_SetItemString(dict, "error", ui_module_error);
  HookWindowsMessages();	// need to be notified of certain events...
  AddConstants(dict);
}


// Utilities for glue support.
BOOL Win32uiInitInstance(void)
{
	CVirtualHelper helper("InitInstance", GetApp());
	return helper.call(); 
}

BOOL Win32uiExitInstance(void)
{
	CVirtualHelper helper("ExitInstance", GetApp());
	BOOL ret = helper.call();
	// These are primarily here as a debugging aid.  Destroy what I created
	// to help MFC detect usefull memory leak reports
	ui_assoc_object::handleMgr.cleanup();
//	PyCWinApp::cleanup();
	return ret;
}

BOOL Win32uiPreTranslateMessage(MSG *pMsg)
{
	BOOL ret = FALSE;
	switch (pMsg->message) {
		case WM_CHAR:
			ret=Python_check_key_message(pMsg);
			break;
		// these messages are (seem to be!) trapped by both the hook and this, so
		// no need to waste lookups.
		case WM_SYSKEYDOWN:
		case WM_SYSKEYUP:
		case WM_SYSCHAR:
		case WM_MDIGETACTIVE:
			break;
		default:
			ret=Python_check_message(pMsg);
	}
	return ret;
}

BOOL Win32uiOnIdle( LONG lCount )
{
	CVirtualHelper helper("OnIdle", GetApp());
	if (!helper.call(lCount)) return FALSE;
	int ret;
	if (!helper.retval(ret))
		return FALSE;
	return ret;
}

BOOL Win32uiOnInstanceHandler( char *cmd )
{
	CVirtualHelper helper("OnInstanceHandler", GetApp());
	if (!helper.call(cmd)) return FALSE;
	int ret;
	if (!helper.retval(ret))
		return FALSE;
	return ret;
}

extern "C" PYW_EXPORT BOOL Win32uiApplicationInit(Win32uiHostGlue *pGlue, char *cmd, const char *additionalPaths)
{
#ifdef _DEBUG
	afxDump.SetDepth(1); // deep dump of objects at exit.
#endif
	if (GetApp()->m_pszProfileName)
		CPythonEditView::Initialize();

	// set up the glue class.
	pGlue->pfnInitInstance = Win32uiInitInstance;
	pGlue->pfnExitInstance = Win32uiExitInstance;
	pGlue->pfnOnCmdMsg = Python_OnCmdMsg;
	pGlue->pfnPreTranslateMessage = Win32uiPreTranslateMessage;
	pGlue->pfnOnIdle = Win32uiOnIdle;
	pGlue->pfnOnInstanceHandler = Win32uiOnInstanceHandler;
	pHostGlue = pGlue;
	if (additionalPaths)
		Python_addpath(additionalPaths);
	if (cmd==NULL)
		return TRUE;

	char fileName[MAX_PATH+20];
	GetTempPath( sizeof(fileName), fileName);
	int len = strlen(fileName);
	if (len && fileName[len-1]!='\\')
		strcat(fileName, "\\" );
	strcat( fileName, "python.log");
	int rc = Python_run_command_with_log(cmd, fileName);
	if (rc) {
		CString csMessage;
		if (rc==1)
			csMessage = CString("Importing startup script failed\r\nLog file ") + CString(fileName) + CString(" has been written");
		else
			csMessage = CString("Importing startup script failed\r\nNo details are available");
		AfxMessageBox((const char *)csMessage);
		return FALSE;
	}
	return TRUE;
}
