/* win32RichEdit : implementation file

	Created March 1996, Mark Hammond (MHammond@skippinet.com.au)

Note that this source file contains embedded documentation.
This documentation consists of marked up text inside the
C comments, and is prefixed with an '@' symbol.  The source
files are processed by a tool called "autoduck" which
generates Windows .hlp files.
@doc

*/
#include "stdafx.h"

#include "win32win.h"
#include "win32doc.h"
#include "win32control.h"
#include "win32RichEdit.h"

#include "pythonRichEdit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

class CProtectedRichEditView : public CRichEditView
{
public:
	void WrapChanged(void) {CRichEditView::WrapChanged();}
};

CRichEditView *GetRichEditViewPtr(PyObject *self)
{
	// need to only rtti check on CView, as CPythonEditView is not derived from CPythonView.
	return (CRichEditView *)PyCWnd::GetPythonGenericWnd(self, &PyCRichEditView::type);
}


/////////////////////////////////////////////////////////////////////
//
// Rich Edit Document
//
//////////////////////////////////////////////////////////////////////
// @pymethod |PyCRichEditDoc|OnCloseDocument|Call the MFC OnCloseDocument handler.
// This routine is provided so a document object which overrides this method
// can call the original MFC version if required.
static PyObject *
ui_re_doc_on_close(PyObject *self, PyObject *args)
{
	CHECK_NO_ARGS2(args,OnCloseDocument);
	CRichEditDoc *pDoc;
	if (!(pDoc=(CRichEditDoc *)PyCRichEditDoc::GetDoc(self)))
		return NULL;
	// @xref <vm PyCDocument.OnCloseDocument>
	pDoc->CRichEditDoc::OnCloseDocument(); // @pyseemfc CRichEditDoc|OnCloseDocument
	RETURN_NONE;
}

// @object PyCRichEditDoc|A class which implements a CRichEditView object.  Derived from <o PyCDocument>.
static struct PyMethodDef PyCRichEditDoc_methods[] = {
	{"OnCloseDocument",		ui_re_doc_on_close,		1},	// @pymeth OnCloseDocument|Call the MFC OnCloseDocument handler.
	{NULL, NULL}
};

ui_type_CObject PyCRichEditDoc::type("PyCRichEditDoc", 
									 &PyCDocument::type, 
									 RUNTIME_CLASS(CRichEditDoc),
									 sizeof(PyCRichEditDoc), 
									 PyCRichEditDoc_methods, 
									 GET_PY_CTOR(PyCRichEditDoc) );

/////////////////////////////////////////////////////////////////////
//
// Rich Edit View object
//
//////////////////////////////////////////////////////////////////////
// @pymethod <o PyCRichEditView>|win32ui|CreateRichEditView|Creates a PyRichEditView object.
PyObject * PyCRichEditView::create(PyObject *self, PyObject *args)
{
	PyObject *doc = Py_None;
	// @pyparm <o PyCDocument>|doc|None|The document to use with the view, or None for NULL.
	if (!PyArg_ParseTuple(args, "|O:CreateEditView", &doc))
		return NULL;
	CDocument *pDoc = NULL;
	if (doc != Py_None) {
		if (!ui_base_class::is_uiobject(doc, &PyCDocument::type))
			RETURN_TYPE_ERR("Argument must be a PyCDocument");
		pDoc = PyCDocument::GetDoc( doc );
		if (!pDoc) return NULL;
	}
	CPythonRichEditView *pView = new CPythonRichEditView();
	if (pDoc)
		pView->SetDocument(pDoc);
	return ui_assoc_object::make( PyCRichEditView::type, pView );
}

///////////////////////////////////////
//
// Rich Edit View Methods
//
// inherited from CtlView
//
///////////////////////////////////////
// @pymethod <o PyCRichEditCtrl>|PyCRichEditView|GetRichEditCtrl|Returns the underlying rich edit control object.
static PyObject *
PyCRichEditView_get_rich_edit_ctrl(PyObject *self, PyObject *args)
{
	CRichEditView *pView = GetRichEditViewPtr(self);
	if (!pView)
		return NULL;
	CRichEditCtrl &ed = pView->GetRichEditCtrl();
	return ui_assoc_object::make( UITypeFromCObject(&ed), &ed )->GetGoodRet();
}

// @pymethod None|PyCRichEditView|SetWordWrap|Sets the wordwrap state for the control.
static PyObject *
PyCRichEditView_set_word_wrap(PyObject *self, PyObject *args)
{
	CRichEditView *pView = GetRichEditViewPtr(self);
	if (!pView)
		return NULL;
	int wrap;
	// @pyparm int|wordWrap||The new word-wrap state.
	if (!PyArg_ParseTuple(args, "i:SetWordWrap", &wrap))
		return NULL;
	// @pyseemfc CRichEditCtrl|m_nWordWrap
	pView->m_nWordWrap = wrap;
	RETURN_NONE;
}

// @pymethod None|PyCRichEditView|WrapChanged|Calls the underlying WrapChanged method.
static PyObject *
PyCRichEditView_wrap_changed(PyObject *self, PyObject *args)
{
	CProtectedRichEditView *pView = (CProtectedRichEditView *)GetRichEditViewPtr(self);
	if (!pView)
		return NULL;
	if (!PyArg_ParseTuple(args, ":WrapChanged"))
		return NULL;
	pView->WrapChanged();
	// @pyseemfc CRichEditCtrl|WrapChanged
	RETURN_NONE;
}


// @object PyCRichEditView|A class which implementes a CRichEditView.  Derived from <o PyCRichEditView> and <o PyCRichEditCtrl>.
static struct PyMethodDef PyCRichEditView_methods[] = {
	{"GetRichEditCtrl",   PyCRichEditView_get_rich_edit_ctrl, 1 }, // @pymeth GetRichEditCtrl|Returns the underlying rich edit control object.
	{"SetWordWrap",       PyCRichEditView_set_word_wrap, 1}, // @pymeth SetWordWrap|Sets the wordwrap state for the control.
	{"WrapChanged",       PyCRichEditView_wrap_changed, 1}, // @pymeth WrapChanged|Calls the underlying WrapChanged method.
	{NULL, NULL}
};

PyCCtrlView_Type PyCRichEditView::type("PyCRichEditView", &PyCCtrlView::type, &PyCRichEditCtrl::type, RUNTIME_CLASS(CRichEditView), sizeof(PyCRichEditView), PyCRichEditView_methods, GET_PY_CTOR(PyCRichEditView));

