// pythonwin.cpp : Defines the class behaviors for the application.
//

#include "stdafxpw.h"
#include "pythonwin.h"
#include "win32uiHostGlue.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define UM_SWITCH_INST (WM_USER + 1024 + 16) // should be no conflict.

static char szMMFileName[] = "PWInsts";
static char szMutexName[] = "MutexPythonWin";
static HWND hRegisteredWnd = NULL;
HANDLE hMMFileMap = NULL;

#define II_CMD_SIZE 512
struct OneInstInfo {
	char cmdLinePrefix[II_CMD_SIZE];
	char nextInstCmd[II_CMD_SIZE];
	HWND hMainWnd;
};

struct AllInstInfo {
	int num;
	OneInstInfo infos[16];
	HANDLE hMutex;
};

// Utility functions
//
AllInstInfo *GetInstInfo(void)
{
	// create the semaphore.
	HANDLE hMutex = CreateMutex( NULL, TRUE, szMutexName );
	if (hMutex==NULL) {
		OutputDebugString("Could not create mutex!");
		return NULL;
	}

	if (WaitForSingleObject(hMutex, 5000)!=WAIT_OBJECT_0) {
		CloseHandle(hMutex);
		return NULL;
	}

	AllInstInfo *pai = (AllInstInfo *)MapViewOfFile(hMMFileMap,
              FILE_MAP_READ | FILE_MAP_WRITE, 0, 0, 0);
	if (pai==NULL) {
		OutputDebugString("WARNING - could not map view of mm file\n");
		// Must clear mutex.
		CloseHandle(hMutex);
	}
	pai->hMutex = hMutex;
	return pai;
}
void ReleaseInstInfo(AllInstInfo *pai)
{
	HANDLE hMutex = pai->hMutex;
	pai->hMutex = NULL;
	UnmapViewOfFile((LPVOID) pai);
	if (hMutex)
		CloseHandle(hMutex);
}
void DeleteInstInfo(AllInstInfo *pai, HWND hwnd)
{
	// first find hwnd;
	for (int inst=0;inst<pai->num && pai->infos[inst].hMainWnd!=hwnd;inst++)
		;
	if (inst<pai->num) {
		// now delete it.
		for (;inst<pai->num;inst++)
			memcpy(&(pai->infos[inst]), &(pai->infos[inst+1]), sizeof(OneInstInfo));
		pai->num--;
	}
}

// HostGlue class.
class PythonWinGlue : public Win32uiHostGlue{
	virtual const char *RegisterInstanceHandler( char *cmdPrefix, HWND hWnd );
};

const char *PythonWinGlue::RegisterInstanceHandler( char *cmdPrefix, HWND hWnd )
{
	AllInstInfo *pai = GetInstInfo();

	if (pai) {
		strncpy(pai->infos[pai->num].cmdLinePrefix, cmdPrefix, II_CMD_SIZE);
		pai->infos[pai->num].hMainWnd = hWnd;
		pai->num++;
		ReleaseInstInfo(pai);
		hRegisteredWnd = hWnd; // set a global to remember.
		return NULL;
	} else {
		return "Could not MapViewOfFile";
	}
}

////////////////////////////////////////////////////////////////////////////
// CPythonWinApp

BEGIN_MESSAGE_MAP(CPythonWinApp, CWinApp)
	//{{AFX_MSG_MAP(CPythonWinApp)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPythonWinApp construction

CPythonWinApp::CPythonWinApp()
{
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CPythonWinApp object

CPythonWinApp NEAR theApp;

// The one and only Glue object.
PythonWinGlue NEAR glue;

/////////////////////////////////////////////////////////////////////////////
// CPythonWinApp initialization
BOOL CPythonWinApp::InitApplication()
{
		// create mem mapped file for switching instances.
	hMMFileMap = CreateFileMapping((HANDLE) 0xFFFFFFFF, 
				NULL, PAGE_READWRITE, 0, sizeof(AllInstInfo), 
				szMMFileName);
	if (hMMFileMap==NULL)
		OutputDebugString("WARNING - could not create/open instance mem mapped file\n");
	else {
		BOOL mapExisted = GetLastError()==ERROR_ALREADY_EXISTS;
		AllInstInfo *pai = GetInstInfo();
		if (pai) {
			if (mapExisted) {
				char *cmdLine = GetCommandLine();
				if (cmdLine[0]=='"') ++cmdLine;
				// look for an instance we can use.
				for (int inst=0;inst<pai->num;inst++) {
					if (strnicmp(pai->infos[inst].cmdLinePrefix, cmdLine, strlen(pai->infos[inst].cmdLinePrefix))==0)
						break;
				}
				if (inst<pai->num) {
					// switch to it.
					strncpy(pai->infos[inst].nextInstCmd, cmdLine, II_CMD_SIZE);
					pai->infos[inst].nextInstCmd[II_CMD_SIZE-1] = '\0';
					HWND hwnd = pai->infos[inst].hMainWnd;
					if (IsWindow(hwnd)) {
						ReleaseInstInfo(pai);
						::PostMessage(hwnd, UM_SWITCH_INST, 0, (long)hwnd);
						return FALSE;
					} else {
						// this one is obviously no good.
						DeleteInstInfo(pai,hwnd);
						inst--; // decrement counter so loop doesnt skip one.
					}
				} 
				// else not found - skip.
			} else {
				// first instance at all - just initialise.
				pai->num = 0;
			}
            ReleaseInstInfo(pai);
		}
	}

	m_pDocManager = new CDocManager();
	if (!CWinApp::InitApplication())
		return FALSE;
	CString startup = GetProfileString("Settings","startup", "import startup");
	if (!glue.DynamicApplicationInit(startup,"Apps\\PyWin\\Scripts;win32"))
		return FALSE;
	return TRUE;
}

BOOL CPythonWinApp::InitInstance()
{
	glue.InitInstance(); // ignore errors
	if (m_pMainWnd==NULL) {
		// likely this means a different pyd was actually loaded by Python
		// than the one we were expecting.
		AfxMessageBox("The win32ui module did not initialise.\n\nIt is likely that 2 different win32ui.pyd files have been loaded\nor that the win32ui application object has\nnot correctly registered a main window.");
		return FALSE;
	}
	// dialog based apps dont have a message pump.
	return !m_pMainWnd->IsKindOf(RUNTIME_CLASS(CDialog));
}
int CPythonWinApp::ExitInstance()
{
	glue.ExitInstance(); // ignore errors
	
	if (hMMFileMap) {
		// delete this instance from the list.
		AllInstInfo *pai = GetInstInfo();
		if (pai) {
			DeleteInstInfo(pai, hRegisteredWnd);
			ReleaseInstInfo(pai);
		}
		CloseHandle(hMMFileMap);
	}
	return CWinApp::ExitInstance();
}

BOOL
CPythonWinApp::OnCmdMsg (UINT nID, int nCode,
			 void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo)
{
  // yield to Python first - send to the main frame, as there is no Python app object.
  if (glue.OnCmdMsg (m_pMainWnd, nID, nCode, pExtra, pHandlerInfo))
    return TRUE;
  else
    return CWinApp::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
}

BOOL CPythonWinApp::PreTranslateMessage(MSG *pMsg)
{
	if (pMsg->message==UM_SWITCH_INST) {
		AllInstInfo *pai = (AllInstInfo *)MapViewOfFile(hMMFileMap,
                  FILE_MAP_READ | FILE_MAP_WRITE, 0, 0, 0);
		if (pai) {
			HWND hwnd = (HWND)pMsg->lParam;
			for (int inst=0;inst<pai->num && pai->infos[inst].hMainWnd!=hwnd;inst++)
				;
			if (inst<pai->num) {
				char *cmd = pai->infos[inst].nextInstCmd;
				glue.OnInstanceHandler(cmd);
			}
			UnmapViewOfFile((LPVOID) pai);
		}
		return TRUE;
	}

	if (glue.PreTranslateMessage(pMsg))
		return TRUE;
	else
		return CWinApp::PreTranslateMessage(pMsg);

/*	BOOL ret=CWinApp::PreTranslateMessage(pMsg);
	BOOL ret2 = glue.PreTranslateMessage(pMsg);
	return ret||ret2;
*/
}

BOOL CPythonWinApp::OnIdle( LONG lCount )
{
	// call base class idle first
	if (CWinApp::OnIdle(lCount))
		return TRUE;
	return glue.OnIdle(lCount);
}

CDocument *CPythonWinApp::OpenDocumentFile(LPCTSTR lpszFileName)
{
#if 0 // win32s no longer supported
	ver.dwOSVersionInfoSize = sizeof(ver);
	GetVersionEx(&ver);
	ver.dwOSVersionInfoSize = sizeof(ver);
	GetVersionEx(&ver);
	if (ver.dwPlatformId == VER_PLATFORM_WIN32s) {
		OutputDebugString("Win32s - Searching templates!\n");
		POSITION posTempl = m_pDocManager->GetFirstDocTemplatePosition();
		CDocTemplate* pTemplate = m_pDocManager->GetNextDocTemplate(posTempl);
		if (pTemplate)
			return pTemplate->OpenDocumentFile(lpszFileName);
		else {
			AfxMessageBox("win32s error - There is no template to use");
			return NULL;
		}
	} else
#endif
		return CWinApp::OpenDocumentFile(lpszFileName);
}
/////////////////////////////////////////////////////////////////////////////
// CPythonWinApp commands

