// pythonframe.h : header file
//
#ifndef __PYTHONFRAME_H__
#define __PYTHONFRAME_H__

#ifndef Py_ALLOBJECTS_H
// fwd declare a Python object
struct PyObject;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonFrame frame
template <class P> class CPythonFrameTemp : public P
{
public:
	CPythonFrameTemp();
	~CPythonFrameTemp();

protected:
	// Operations
	virtual BOOL OnCreateClient(LPCREATESTRUCT cs, CCreateContext* pContext);
	virtual BOOL PreCreateWindow(CREATESTRUCT &cs);
	virtual BOOL OnCmdMsg( UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo );
	virtual BOOL OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual void GetMessageString( UINT nID, CString& rMessage ) const;
	virtual void ActivateFrame(int nCmdShow);
};

class CPythonFrame : public CPythonFrameTemp<CMDIChildWnd>
{
	DECLARE_DYNCREATE(CPythonFrame)
public:
	CPythonFrame();			// protected constructor used by dynamic creation
public:
// Implementation
	BOOL SetMenu(int id);
	BOOL SetMenu(HMENU newMenu, PyObject *ob);
protected:
	void FreeMenu(void);
	void SendMDISetMenu(void);
	virtual ~CPythonFrame();

	PyObject *pythonMenuObject;
	HMENU	hMenu;

	// Generated message map functions
	//{{AFX_MSG(CPythonFrame)
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

class CPythonMainFrame : public CPythonFrameTemp<CMDIFrameWnd>
{
	DECLARE_DYNAMIC(CPythonMainFrame)
public:
	CPythonMainFrame();
public:
	virtual ~CPythonMainFrame();

#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif

public:	// control bar embedded members
	CStatusBar	m_wndStatusBar;

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CPythonMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnUpdatePosIndicator(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif // __filename_h__
