// pythonframe.cpp : implementation file
//
// Note that this source file contains embedded documentation.
// This documentation consists of marked up text inside the
// C comments, and is prefixed with an '@' symbol.  The source
// files are processed by a tool called "autoduck" which
// generates Windows .hlp files.
// @doc
#include "stdafx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPythonFrame
#undef new
IMPLEMENT_DYNCREATE(CPythonFrame, CMDIChildWnd)

template <class P>
CPythonFrameTemp<P>::CPythonFrameTemp()
{
}

template <class P>
CPythonFrameTemp<P>::~CPythonFrameTemp()
{
	Python_delete_assoc(this); // frame dieing - make sure Python knows about it.
}

template <class P>
BOOL CPythonFrameTemp<P>::OnCmdMsg (UINT nID, int nCode,
			void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo)
{
  // yield to Python first
  if (Python_OnCmdMsg (this, nID, nCode, pExtra, pHandlerInfo))
    return TRUE;
  else
    return P::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
}

template <class P>
BOOL CPythonFrameTemp<P>::OnNotify (WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
  // yield to Python first
  if (Python_OnNotify (this, wParam, lParam, pResult))
    return TRUE;
  else
    return P::OnNotify (wParam, lParam, pResult);
}

template <class P>
LRESULT CPythonFrameTemp<P>::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// @pyvirtual int|PyCMDIChildWnd|WindowProc|Default message handler.
	LRESULT res;
	CVirtualHelper helper( "WindowProc", this );
	if (!helper.HaveHandler() || !helper.call(message, wParam, lParam) || !helper.retval(res))
		return P::WindowProc(message, wParam, lParam);
	return res;
}

template <class P>
BOOL CPythonFrameTemp<P>::OnCreateClient(LPCREATESTRUCT cs, CCreateContext* pContext)
{
	// @pyvirtual |PyCMDIChildWnd|OnCreateClient|Called by the framework during the execution of OnCreate.
	// @xref <om PyCMDIChildWnd.OnCreateClient>
	
	CVirtualHelper helper( "OnCreateClient", this );
	PythonCreateContext *pCC = (PythonCreateContext *)pContext;
	// @pyparm tuple|CREATESTRUCT||A tuple describing a CREATESTRUCT structure.
	// @pyparm object|object||A Python object initially passed to LoadFrame
	if (helper.HaveHandler() && !helper.call(cs, pCC->GetPythonObject()))
		return FALSE;
	// @rdesc The return value from this method is ignored, but an exception will prevent window.
	return P::OnCreateClient( cs, pContext );
}

template <class P>
BOOL CPythonFrameTemp<P>::PreCreateWindow(CREATESTRUCT &cs)
{
	// @pyvirtual BOOL|PyCMDIChildWnd|PreCreateWindow|Called by the framework before the creation of the Windows window attached to this PyCWnd object.
	// @pyparm tuple|CREATESTRUCT||A tuple describing a CREATESTRUCT structure.
	// @xref <om PyCMDIChildWnd.PreCreateWindow>
	CVirtualHelper helper("PreCreateWindow", this);
	if (helper.HaveHandler()) {
		if (!helper.call(&cs) || !helper.retval(cs))
			return FALSE;
		return TRUE;
	} else {
		return P::PreCreateWindow(cs);
	}
}

template <class P>
void CPythonFrameTemp<P>::ActivateFrame(int nCmdShow)
{
	// @pyvirtual |PyCMDIChildWnd|ActivateFrame|Called to activate the frame window.
	// @comm If a handler for this function exists, then the base MFC implementation will not be called.
	// If you wish to use the default functionality, <om PyCMDIFrameWnd.ActivateFrame> can be called.
	// <nl>If there is no handler, the base MFC implementation will be called.
	// @xref <om PyCMDIChildWnd.ActivateFrame>
	CVirtualHelper helper( "ActivateFrame", this );
	// @pyparm int|cmdShow||The paramater to be passed to <om PyCWnd.ShowWindow>
	if (helper.HaveHandler()) {
		helper.call(nCmdShow);
	} else {
		P::ActivateFrame(nCmdShow);
	}
}

template <class P>
void CPythonFrameTemp<P>::GetMessageString( UINT nID, CString& rMessage ) const
{
	// @pyvirtual string|PyCMDIChildWnd|GetMessageString|Gets the message string to use for a control specific ID.
	CVirtualHelper helper("GetMessageString", (void *)this);
	// @pyparm int|id||The command ID to retrieve the string for.
	// @xref <om PyCMDIChildWnd.GetMessageString>
	if (helper.call((int &)nID)) {
		char *ret;
		if (helper.retval(ret))
			rMessage = ret;
	}
	else
		P::GetMessageString(nID, rMessage);
}


CPythonFrame::CPythonFrame()
{
	hMenu = NULL;
	pythonMenuObject = NULL;
}

CPythonFrame::~CPythonFrame()
{
}

void CPythonFrame::SendMDISetMenu(void)
{
	ASSERT(hMenu);
	CMDIFrameWnd* pFrame = GetMDIFrame();
	// activating child, set parent menu
	::SendMessage(pFrame->m_hWndMDIClient, WM_MDISETMENU,
		(WPARAM)hMenu,
		(LPARAM)pFrame->GetWindowMenuPopup(hMenu));
	pFrame->DrawMenuBar();
}

// set to a predefined id - no Python object.
BOOL CPythonFrame::SetMenu(int id)
{
	HMENU newMenu = ::LoadMenu( AfxGetInstanceHandle(), MAKEINTRESOURCE(id));
	if (newMenu==NULL)
			return FALSE;
	FreeMenu();
	m_hMenuShared = NULL;	// tell MFC not to use one.
	hMenu = newMenu;
	SendMDISetMenu();
	return TRUE;
}
// set to a python menu object.
BOOL CPythonFrame::SetMenu(HMENU newMenu, PyObject *ob)
{
	if (newMenu==NULL || ob==NULL)
		return FALSE;
	FreeMenu();
	pythonMenuObject = ob;	// take copy
	Py_INCREF(ob);
	hMenu = newMenu;
	SendMDISetMenu();
	return TRUE;
}
void CPythonFrame::FreeMenu(void)
{
	if (pythonMenuObject) {
		DODECREF(pythonMenuObject);
		pythonMenuObject = NULL;
	} else {
		if (hMenu)
			::DestroyMenu(hMenu);
		hMenu = NULL;
	}
}

BEGIN_MESSAGE_MAP(CPythonFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CPythonFrame)
	ON_WM_MDIACTIVATE()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPythonFrame message handlers

void CPythonFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);

	if (hMenu != NULL && bActivate)
		SendMDISetMenu();
	else if (hMenu != NULL && !bActivate && pActivateWnd == NULL)
	{
		// destroying last child
		CMDIFrameWnd* pFrame = GetMDIFrame();
		HMENU hMenuLast = NULL;
		::SendMessage(pFrame->m_hWndMDIClient, WM_MDISETMENU,
			(WPARAM)pFrame->m_hMenuDefault, (LPARAM)hMenuLast);
		pFrame->DrawMenuBar();
	}

}

void CPythonFrame::OnDestroy()
{
	CMDIChildWnd::OnDestroy();
	FreeMenu();
}

int CPythonFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// @pyvirtual |PyCMDIChildWnd|OnCreate|Called as the window is created.
	// @comm The MFC base implementation is always called.
	CVirtualHelper helper( "OnCreate", this );
	int ret = 0;
	if (helper.call())
		helper.retval(ret);
	return ret;
}

/////////////////////////////////////////////////////////////////////////////
// CPythonMainFrame
IMPLEMENT_DYNAMIC(CPythonMainFrame, CMDIFrameWnd)
BEGIN_MESSAGE_MAP(CPythonMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CPythonMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_LINENUM, OnUpdatePosIndicator)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_COLNUM, OnUpdatePosIndicator)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
	ID_INDICATOR_LINENUM,
	ID_INDICATOR_COLNUM
};

static UINT BASED_CODE buttonsDebugger[] = {
	ID_DEBUGGER_STOP
};

/////////////////////////////////////////////////////////////////////////////
// CPythonMainFrame construction/destruction

CPythonMainFrame::CPythonMainFrame()
{
}

CPythonMainFrame::~CPythonMainFrame()
{
	TRACE("CPythonMainFrame::~CPythonMainFrame called\n");
}

int CPythonMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;		// fail to create
	}

//	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
//		CBRS_TOOLTIPS | CBRS_FLYBY);

	// @pyvirtual |PyCMDIFrameWnd|OnCreate|Called as the window is created.
	// @comm The MFC base implementation is always called.
	CVirtualHelper helper( "OnCreate", this );
	int ret = 0;
	if (helper.call())
		helper.retval(ret);
	return ret;
}

// Note: Im a wanker! (I just did something stupid, but its gone, now :-)
/////////////////////////////////////////////////////////////////////////////
// CPythonMainFrame diagnostics

#ifdef _DEBUG
void CPythonMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CPythonMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPythonMainFrame message handlers

void CPythonMainFrame::OnUpdatePosIndicator(CCmdUI* pCmdUI)
{
	CMDIChildWnd *pWnd = MDIGetActive();
	CWnd *pChild;
	long colNo = 0;
	long lineNo = 0;

	if (pWnd)
		pChild = pWnd->GetWindow(GW_CHILD); 
	if (pWnd && pChild) {
		if (pChild->IsKindOf(RUNTIME_CLASS(CEditView))) {
			int startChar, endChar;
			CEdit &edit = ((CEditView *)pChild)->GetEditCtrl();
			edit.GetSel( startChar, endChar );
			lineNo = edit.LineFromChar(startChar);
			colNo = endChar - edit.LineIndex(lineNo);
		} else if (pChild->IsKindOf(RUNTIME_CLASS(CRichEditView))) {
 			long startChar, endChar;
			CRichEditCtrl &edit = ((CRichEditView *)pChild)->GetRichEditCtrl();

			CRichEditView *pView = (CRichEditView *)pWnd->GetWindow(GW_CHILD);
			edit.GetSel( startChar, endChar );
			lineNo = edit.LineFromChar(startChar);
			colNo = endChar - edit.LineIndex(lineNo);
		}
	}
	int width = 5;
	long value;
	if (pCmdUI->m_nID==ID_INDICATOR_LINENUM)
		value = lineNo + 1;
	else if (pCmdUI->m_nID==ID_INDICATOR_COLNUM ) {	
		width = 3;
		value = colNo + 1;
	} else {
		TRACE0("Unknown ID in OnUpdatePosIndicator\n");
		ASSERT(0);
		return;
	}
	char resBuf[20];
	if (value)
		sprintf(resBuf,"%0*ld", width,value);
	else
		resBuf[0] = '\0';

	pCmdUI->SetText(resBuf);
	pCmdUI->Enable();
}
