# intpyapp.py  - Interactive Python application class
#
import win32con
import win32api
import win32ui
import __main__
import sys
import string
import app
import window
import afxres
import commctrl

version = '0.1.0'

class MainFrame(app.MainFrame):
	def OnCreate(self):
		style = win32con.WS_CHILD | win32con.WS_VISIBLE | \
		    afxres.CBRS_SIZE_DYNAMIC | afxres.CBRS_TOP | afxres.CBRS_TOOLTIPS | afxres.CBRS_FLYBY

		tb = win32ui.CreateToolBar (self, style)
		tb.LoadToolBar(win32ui.IDR_MAINFRAME)
		tb.EnableDocking(afxres.CBRS_ALIGN_ANY)
		tb.SetWindowText("Standard")
		self.EnableDocking(afxres.CBRS_ALIGN_ANY)
		self.DockControlBar(tb)
		self.LoadBarState("ToolbarDefault")
	def OnDestroy(self, msg):
		app.MainFrame.OnDestroy(self, msg)
		self.SaveBarState("ToolbarDefault")

class InteractivePythonApp(app.CApp):
	def HookCommands(self):
		app.CApp.HookCommands(self)
		self.frame.HookCommand(self.OnViewBrowse,win32ui.ID_VIEW_BROWSE)
		self.frame.HookCommand(self.OnFileImport,win32ui.ID_FILE_IMPORT)
		self.frame.HookCommand(self.OnFileRun,win32ui.ID_FILE_RUN)
		self.frame.HookCommand(self.OnFileLocate,win32ui.ID_FILE_LOCATE)
		self.frame.HookCommand(self.OnInteractiveWindow, win32ui.ID_VIEW_INTERACTIVE)
		self.frame.HookCommandUpdate(self.OnUpdateInteractiveWindow, win32ui.ID_VIEW_INTERACTIVE)
	def CreateMainFrame(self):
		return MainFrame()
	def InitInstance(self):
		win32ui.SetRegistryKey('Python') # MFC automatically puts the main frame caption on!
		app.CApp.InitInstance(self)
		try:
			win32ui.RegisterInstanceHandler(string.join(sys.appargv[:sys.appargvoffset]), self.frame.GetSafeHwnd())
		except:
			pass
		win32ui.CreateDebuggerThread()
		win32ui.EnableControlContainer()
		import interact
		interact.CreateInteractiveWindow()
		self.LoadUserModules()
		self.ProcessArgs(sys.argv)

	def ProcessArgs(self, args):
		if len(args)<2:
			return
		try:
			if args[1][0]!='/':
				argStart = 1
				argType = string.lower(win32ui.GetProfileVal("Python","Default Arg Type","/edit"))
			else:
				argStart = 2
				argType = args[1]
			if argStart >= len(args):
				raise TypeError, "The command line requires an additional arg."
			if argType=="/edit":
				# Load up the default application.
				win32ui.GetApp().OpenDocumentFile(args[argStart])
			elif argType=="/rundlg":
				# Load up the default application.
				import scriptutils
				scriptutils.RunScript(args[argStart], string.join(args[argStart+1:]))
			elif argType=="/run":
				# Load up the default application.
				import scriptutils
				scriptutils.RunScript(args[argStart], string.join(args[argStart+1:]), 0)
			else:
				raise TypeError, "Command line arguments not recognised"
		except:
			typ = sys.exc_type
			val = sys.exc_value
			tb = sys.exc_traceback
			print "There was an error processing the command line args"
			import traceback
			traceback.print_exception(typ, val, tb, None, sys.stdout)
			win32ui.OutputDebug("There was a problem with the command line args - %s: %s" % (`typ`,`val`))


	def LoadUserModules(self, moduleNames = None):
		# Load the users modules.
		if moduleNames is None:
			default = "sgrepmdi"
			moduleNames=win32ui.GetProfileVal('Python','Startup Modules',default)
		app.CApp.DoLoadModules(self, moduleNames)

	def OnViewBrowse( self, id, code ):
		" Called when ViewBrowse message is received "
		import dialog
		import browser
		obName = dialog.GetSimpleInput('Object', '__builtins__', 'Browse Python Object')
		if obName is None:
			return
		try:
			browser.Browse(eval(obName, __main__.__dict__, __main__.__dict__))
		except NameError:
			win32ui.MessageBox('This is no object with this name')
		except AttributeError:
			win32ui.MessageBox('The object has no attribute of that name')
		except:
			win32ui.MessageBox('This object can not be browsed')
		
	def OnFileImport( self, id, code ):
		" Called when a FileImport message is received. Import the current or specified file"
		import scriptutils
		scriptutils.ImportFile()

	def OnFileRun( self, id, code ):
		" Called when a FileRun message is received. "
		import scriptutils
		showDlg = win32api.GetKeyState(win32con.VK_SHIFT) >= 0
		scriptutils.RunScript(None, None, showDlg)

	def OnFileLocate( self, id, code ):
		import dialog
		import os
		name = ".py"
		# Loop until a good name, or cancel
		while 1:
			name = dialog.GetSimpleInput('File name', name, 'Locate Python File')
			if name is None: # Cancelled.
				break
			if len(os.path.splitext(name)[1])==0:	# check if no extension supplied, and give one.
				name = name + '.py'
			newName = app.LocatePythonFile( name )
			if newName is None:
				win32ui.MessageBox("The file '%s' can not be located" % name)
			else:
				win32ui.GetApp().OpenDocumentFile(newName)
				break

				
	def OnInteractiveWindow(self, id, code):
		# toggle the existing state.
		try:
			interact=sys.modules['interact']
			try:
				interact.edit.currentView.GetSafeHwnd()
				# Is currently open
				interact.edit.currentView.GetParent().DestroyWindow()
			except:
				interact.edit.Create()
		except KeyError:
				import interact
				interact.CreateInteractiveWindow()
	
	def OnUpdateInteractiveWindow(self, cmdui):
		try:
			interact=sys.modules['interact']
			try:
				interact.edit.currentView.GetSafeHwnd()
				state = 1
			except:
				state = 0
		except KeyError:
			state = 0
		cmdui.Enable()
		cmdui.SetCheck(state)
		# while I track down memory leaks...
		sys.last_traceback = None
		sys.last_type = None
		sys.last_value = None
			
	def OnHelpAbout( self, id, code ):
		" Called when HelpAbout message si received.  Displays the About dialog. "
		import dialog
		dlg = dialog.Dialog(win32ui.IDD_ABOUTBOX);
		dlg.AddDDX(win32ui.IDC_ABOUT_COPYRIGHT_GUI, 'gui');
		dlg.AddDDX(win32ui.IDC_ABOUT_COPYRIGHT, 'python');
		dlg['gui'] = 'Python for Win32 - %s' % version
		dlg['python'] = 'Python %s' % sys.version
		dlg.DoModal()
	def OnInstanceHandler(self, cmd):
		import cmdline
		self.frame.ActivateFrame(win32con.SW_RESTORE)
		self.ProcessArgs(cmdline.ParseArgs(cmd))
		return 1

app.AppBuilder = InteractivePythonApp


