// dllmain.

#include "stdafx.h"
#include "afxdllx.h"

#include "win32uiHostGlue.h"

static HWND GetConsoleHwnd(void);

static AFX_EXTENSION_MODULE extensionDLL;
static CDynLinkLibrary *pDLL = NULL;

BOOL PyWin_bIsWin32s; // global, and aint gunna change over 1 app lifetime!

CWinApp *pCreatedApp = NULL;

class CInProcApp : public CWinApp
{
public:
	CInProcApp(LPCTSTR lpszAppName);
	Win32uiHostGlue glue;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInProcApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInProcApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	virtual BOOL PreTranslateMessage(MSG *pMsg) {
			if (glue.PreTranslateMessage(pMsg))
				return TRUE;
			else
				return CWinApp::PreTranslateMessage(pMsg);
		}

	virtual int ExitInstance() {
			glue.ExitInstance(); // ignore errors
			return CWinApp::ExitInstance();
		}
	virtual BOOL OnIdle( LONG lCount) {
			// call base class idle first
			if (CWinApp::OnIdle(lCount))
				return TRUE;
			return glue.OnIdle(lCount);
		}
	BOOL OnCmdMsg (UINT nID, int nCode,
		       void* pExtra, AFX_CMDHANDLERINFO*pHandlerInfo) {
			// yield to Python first - send to the main frame, as there is no Python app object.
			if (glue.OnCmdMsg (m_pMainWnd, nID, nCode, pExtra, pHandlerInfo))
				return TRUE;
			else
				return CWinApp::OnCmdMsg (nID, nCode, pExtra, pHandlerInfo);
		}
};

/////////////////////////////////////////////////////////////////////////////
// CInProcApp

BEGIN_MESSAGE_MAP(CInProcApp, CWinApp)
	//{{AFX_MSG_MAP(CInProcApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInProcApp construction

CInProcApp::CInProcApp(LPCTSTR lpszAppName) :
	CWinApp(lpszAppName)
{
	// Place all significant initialization in InitInstance
	// if I have a console window, make it the main window.
	HWND main = GetConsoleHwnd();
	if (main) {
		CWnd *pWndMain = new CWnd();
		pWndMain->Attach(main);
		m_pMainWnd = pWndMain;
	}
	glue.DynamicApplicationInit();
}

/////////////////////////////////////////////////////////////////////////////
// CInProcApp initialization

BOOL CInProcApp::InitInstance()
{
	glue.InitInstance(); // ignore errors
	return TRUE;
}



extern "C" int APIENTRY 
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	if (dwReason == DLL_PROCESS_ATTACH) {
		// Get Win32s version, etc
		OSVERSIONINFO ver;
		ver.dwOSVersionInfoSize = sizeof(ver);
		GetVersionEx(&ver);
		PyWin_bIsWin32s = ver.dwPlatformId == VER_PLATFORM_WIN32s;

#ifdef _DEBUG
		char path[_MAX_PATH];
		GetModuleFileName(hInstance, path, sizeof(path));
		TRACE("Extension module %s initialising.\n", path);
#endif
		Py_Initialize();
		// If the host exports a special symbol, then
		// dont create a host app.
		HMODULE hModule = GetModuleHandle(NULL);
		BOOL hasSymbol = (GetProcAddress(hModule, "NoCreateWinApp") != NULL);
		if (AfxGetApp()==NULL && !hasSymbol) {
			// shared initialization
			pCreatedApp = new CInProcApp("win32ui module");

			// Do the WinMain thang...
			// AFX internal initialization
			if (!AfxWinInit(hInstance, NULL, "", SW_NORMAL))
				return 0;

			// App global initializations (rare)
			ASSERT_VALID(pCreatedApp);
			if (!pCreatedApp->InitApplication())
				return 0;

			// Perform specific initializations
			if (!pCreatedApp->InitInstance())
			{
				if (pCreatedApp->m_pMainWnd != NULL)
				{
					TRACE0("Warning: Destroying non-NULL m_pMainWnd\n");
					pCreatedApp->m_pMainWnd->DestroyWindow();
				}
				pCreatedApp->ExitInstance();
				return 0;
			}
			ASSERT_VALID(pCreatedApp);
			if (AfxGetApp()==NULL)
				OutputDebugString("Warning - still no CWinApp I can use!");
		}
		// Extension DLL one-time initialization 
		if (!AfxInitExtensionModule(extensionDLL, hInstance))
			return 0;
		// insert into resource chain.
		pDLL = new CDynLinkLibrary(extensionDLL);
	} else if (dwReason == DLL_PROCESS_DETACH) {
//		Py_Cleanup();
// NOT safe to cleanup here - other DLLs may have already been unloaded
		if (pCreatedApp) {
			Python_delete_assoc(pCreatedApp); // so Python wont try and use it.
			AfxWinTerm();
			afxCurrentWinApp = NULL; // So AfxGetApp fails from here.
			delete pCreatedApp;
			pCreatedApp = NULL;
		}
		delete pDLL;
	}
	return 1;   // ok
}

// straight from the SDK.
HWND GetConsoleHwnd(void)
{
    #define MY_BUFSIZE 1024 // buffer size for console window titles
    HWND hwndFound;         // this is what is returned to the caller
    char pszNewWindowTitle[MY_BUFSIZE]; // contains fabricated WindowTitle
    char pszOldWindowTitle[MY_BUFSIZE]; // contains original WindowTitle
 
    // fetch current window title
 
    if (GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE)==0)
		return NULL;

 
    // format a "unique" NewWindowTitle
 
    wsprintf(pszNewWindowTitle,"%d/%d",
                GetTickCount(),
                GetCurrentProcessId());
 
    // change current window title
 
    SetConsoleTitle(pszNewWindowTitle);
 
    // ensure window title has been updated
 
    Sleep(40);
 
    // look for NewWindowTitle
 
    hwndFound=FindWindow(NULL, pszNewWindowTitle);
 
    // restore original window title
 
    SetConsoleTitle(pszOldWindowTitle);
 
    return(hwndFound);
}
 
