import docview
import Image
import ImageWin
import win32ui, win32api, win32con

class PILDoc(docview.Document):
	def __init__(self, template):
		docview.Document.__init__(self, template)
		win32ui.SetStatusText("Opening image file", 1)
		self.image = Image.open("D:\pythonex\Imaging-0.2b3\images\lena.gif")

class PILView(docview.ScrollView):
	def __init__(self,  doc):
		docview.ScrollView.__init__(self, doc)
		self.SetScrollSizes(win32con.MM_TEXT, doc.image.size)
		self.pilDisplay = ImageWin.Dib("L", image.size)

		self.pilDisplay.paste(doc.image)

		self.width = self.height = 0
		# set up message handlers
		self.HookMessage (self.OnSize, win32con.WM_SIZE)

	def OnSize (self, params):
		lParam = params[3]
		self.width = win32api.LOWORD(lParam)
		self.height = win32api.HIWORD(lParam)

	def OnPrepareDC (self, dc, printinfo):
		# Set up the DC for forthcoming OnDraw call
		pass

	def OnDraw (self, dc):
		doc = self.GetDocument()
		self.pilDisplay.expose(dc.GetHandleOutput())
	
def Demo():
	# create doc/view
	template = docview.DocTemplate(win32ui.IDR_PYTHONTYPE, PILDoc, None, PILView)
	doc=template.OpenDocumentFile(None)
	doc.SetTitle ('PIL Demo')
#	print "template is ", template, "obj is", template._obj_
	template.close()
#	print "closed"
#	del template

if __name__=='__main__':
	Demo()

