'''
sax_builder.py: SaxBuilder class implementation.

SaxBuilder builds a DOM-conformant grove from evenements generated by a
SAX-conformant driver.
'''

from xml.sax.saxlib import HandlerBase
from builder import Builder


class SaxBuilder(Builder, HandlerBase):
	def __init__(self):
		HandlerBase.__init__(self)
		Builder.__init__(self)

	def characters(self, char, start, length):
		self.text(char[start:start+length])


# Test.
if __name__ == '__main__':
	print 'Testing dom.sax_builder. Usage: python dom/sax_builder <xml_file>.'

	import saxlib.xlsax, sys, writer

	p = saxlib.xlsax.SAX_XMLParser()
	dh = SaxBuilder()
	p.setDocumentHandler(dh)
	p.parse('', sys.argv[1])

	w = writer.XmlLineariser()
	print w.linearise(dh.document)
	
