
# Parser test suite:
# This checks if the test/xmltest directory is present, and if so, tries
# each of the parsers available.
#
# This is unfinished, and hence has been renamed to t_parsers instead
# of test_parsers.  Even on not-wf entries in Clark's test suite, the
# parsers don't seem to report any problems.  Am I not understanding
# how the test suite works?

import os, glob
from xml.sax import saxexts, saxlib

skip_tests = ['xmltest/valid/sa/097.xml', 'xmltest/not-wf/sa/083.xml',
              'xmltest/not-wf/sa/102.xml']

def test_parser(parser):
    # Put a parser through its paces.
    # Process the valid/sa directory
    files = glob.glob('xmltest/valid/sa/*.xml')
    for file in files:
        if file in skip_tests: continue
        print file
        p = saxexts.XMLParserFactory.make_parser( parser )
        f = open(file, 'r')
        p.parseFile( f )
        
    # Process the not-wf/sa directory
    files = glob.glob('xmltest/not-wf/sa/*.xml')
    for file in files:
        if file in skip_tests: continue
        print file
        p = saxexts.XMLParserFactory.make_parser( parser )
        f = open(file, 'r')
        p.parseFile( f )

def test_all_parsers():
    for parser in saxexts.XMLParserFactory.get_parser_list():
        try:
            p = saxexts.XMLParserFactory.make_parser( parser )
        except saxlib.SAXException:
            # The parser must not be available, so just silently move
            # on to the next parser
            pass
        else:
            print parser
            test_parser( parser )
            
if os.path.exists('xmltest/'):
    test_all_parsers()

