# 
# Top-level program for XML test suite
#

import sys, regrtest, getopt, string
from test import test_support

def main():
    # This main function is essentially the same as the one in the
    # original regrtest.py shipped with Python 1.5.1, slightly
    # modified to handle running outside of regrtest.  

    try:
        opts, args = getopt.getopt(sys.argv[1:], 'vgqx')
    except getopt.error, msg:
        print msg
        print __doc__
        return 2
    verbose = 0
    quiet = 0
    generate = 0
    exclude = 0
    for o, a in opts:
        if o == '-v': verbose = verbose+1
        if o == '-q': quiet = 1; verbose = 0
        if o == '-g': generate = 1
        if o == '-x': exclude = 1
    if generate and verbose:
        print "-g and -v don't go together!"
        return 2
    good = []
    bad = []
    skipped = []
    for i in range(len(args)):
        # Strip trailing ".py" from arguments
        if args[i][-3:] == '.py':
            args[i] = args[i][:-3]
    if exclude:
        nottests[:0] = args
        args = []
    tests = regrtest.findtests(testdir = '.', stdtests = [], nottests = [])
    test_support.verbose = verbose      # Tell tests to be moderately quiet
    for test in tests:
        if not quiet:
            print test
        ok = regrtest.runtest(test, generate, verbose)
        if ok > 0:
            good.append(test)
        elif ok == 0:
            bad.append(test)
        else:
            if not quiet:
                print "test", test,
                print "skipped -- an optional feature could not be imported"
            skipped.append(test)
    if good and not quiet:
        if not bad and not skipped and len(good) > 1:
            print "All",
        print regrtest.count(len(good), "test"), "OK."
    if bad:
        print regrtest.count(len(bad), "test"), "failed:",
        print string.join(bad)
    if skipped and not quiet:
        print regrtest.count(len(skipped), "test"), "skipped:",
        print string.join(skipped)
    return len(bad) > 0
    
if __name__ == '__main__':
    main()
