
# DOM Level 2 test suite

import StringIO
from xml.dom import core, sax_builder
from xml.sax import saxexts

def check(cond, explanation):
    truth = eval(cond)
    if not truth:
        print ' *** Failed:', explanation, '\n\t', cond

test_text = """<?xml version="1.0"?>
<doc>
<title>This is a test</title>
<h1>Don't panic</h1>
<p>Maybe it will work.</p>
<h2>We can handle it</h2>
<h3>Yes we can</h3>
<h3>Or maybe not</h3>
End of test.
</doc>
"""

p = saxexts.make_parser()
h = sax_builder.SaxBuilder()
p.setDocumentHandler( h )
file = StringIO.StringIO( test_text )
p.parseFile( file )

doc = h.document

print doc

doctype = core.createDocumentType("mydoctype", "publicId", "systemId",
                                  "intSubset")
check('doctype.ownerDocument == None', 'Fresh DocumentType has no ownerDocument')
check('doctype.parentNode == None', 'Fresh DocumentType has no parent')
check('doctype.publicId == "publicId"', 'DocumentType.publicId has right value')
check('doctype.systemId == "systemId"', 'DocumentType.systemId has right value')
check('doctype.internalSubset == "intSubset"', 'DocumentType.internalSubset has right value')




