#!/usr/bin/env python

# Specialized setup script for the Distutils used to throw together code
# snapshots.

__revision__ = "$Id: snapshot_setup.py,v 1.1 2000/06/08 01:18:36 gward Exp $"

from distutils.core import setup
from time import localtime, time, strftime

date = strftime("%Y%m%d", localtime(time()))

setup (name = "distutils",              # lowercase to distinguish from release
       version = date,
       description = "Python Distribution Utilities (code snapshot)",
       author = "Greg Ward",
       author_email = "gward@python.net",
       url = "http://www.python.org/sigs/distutils-sig/",
       licence = "Python",

       packages = ['distutils', 'distutils.command'],

       options = {'sdist': {'template': 'MINIFEST.in',
                            'manifest': 'MINIFEST'}},
      )
