import string, re

strings = [("foo bar baz",        ['foo', 'bar', 'baz']),
           (" foo bar",           ['foo', 'bar']),
           ("foo bar ",           ['foo', 'bar']),
           ("foo   bar",          ['foo', 'bar']),
           ("\\ foo",             [' foo']),
           ("foo \\ bar",         ['foo', ' bar']),
           ("foo \\  bar",        ['foo', ' ', 'bar']),
           ("foo",                ['foo']),
           ("foo\\ bar",          ['foo bar']),
           ("'foo bar'",          ['foo bar']),
           ("foo 'bar baz'",      ['foo', 'bar baz']),
           ('"foo bar" baz',      ['foo bar', 'baz']),
           ('"hello there" "*"',  ['hello there', '*']),
           ('ding" dong" dang',   ['ding dong', 'dang']),
           ('foo""bar',           ['foobar']),
           ('foo" "bar',          ['foo bar']),
           ('foo\\" bar',         ['foo\"', 'bar']),
           ('foo \\"bar',         ['foo', '\"bar']),
           ('foo\\ \\"bar',       ['foo \"bar']),
          ]

_wordchars_re = re.compile(r'[^\\\'\"\ ]*')
_squote_re = re.compile(r"'(?:[^'\\]|\\.)*'")
_dquote_re = re.compile(r'"(?:[^"\\]|\\.)*"')

def split_quoted (s):
    s = string.strip(s)
    words = []
    pos = 0

    while s:
        m = _wordchars_re.match(s, pos)
        end = m.end()
        if end == len(s):
            words.append(s[:end])
            break

        if s[end] == ' ':               # unescaped, unquoted space: now
            words.append(s[:end])       # we definitely have a word delimiter
            s = string.lstrip(s[end:])
            pos = 0

        elif s[end] == '\\':            # preserve whatever is being escaped;
                                        # will become part of the current word
            if s[end+1] in (' ', '"', "'"):
                s = s[:end] + s[end+1:]
                pos = end+1
            else:
                pos = end+2

        else:
            if s[end] == "'":           # slurp singly-quoted string
                m = _squote_re.match(s, end)
            elif s[end] == '"':         # slurp doubly-quoted string
                m = _dquote_re.match(s, end)
            else:
                raise RuntimeError, \
                      "this can't happen (bad char '%c')" % s[end]

            (beg, end) = m.span()
            s = s[:beg] + s[beg+1:end-1] + s[end:]
            pos = m.end() - 2

        if pos >= len(s):
            words.append(s)
            break

    return words

if __name__ == "__main__":
    for (s, words) in strings:
        got_split = split(s)
        if got_split == words:
            print "ok: %s -> %s" % (s, got_split)
        else:
            print "not ok: %s (expected %s, got %s)" % (s, words, got_split)

        #print "string to split: " + s
        #print "expect:", words
        #print "result:", split(s)
        #print "expect:", string.join(map(str, words), ", ")
        #print "result:", string.join(map(str, split(s)), ", ")
        #print
        
