#!/usr/bin/env python

import string, re
from distutils.util import split_quoted

strings = [("foo bar baz",        ['foo', 'bar', 'baz']),
           (" foo bar",           ['foo', 'bar']),
           ("foo bar ",           ['foo', 'bar']),
           ("foo   bar",          ['foo', 'bar']),
           ("\\ foo",             [' foo']),
           ("foo \\ bar",         ['foo', ' bar']),
           ("foo \\  bar",        ['foo', ' ', 'bar']),
           ("foo",                ['foo']),
           ("foo\\ bar",          ['foo bar']),
           ("'foo bar'",          ['foo bar']),
           ("foo 'bar baz'",      ['foo', 'bar baz']),
           ('"foo bar" baz',      ['foo bar', 'baz']),
           ('"hello there" "*"',  ['hello there', '*']),
           ('ding" dong" dang',   ['ding dong', 'dang']),
           ('foo""bar',           ['foobar']),
           ('foo" "bar',          ['foo bar']),
           ('foo\\" bar',         ['foo\"', 'bar']),
           ('foo \\"bar',         ['foo', '\"bar']),
           ('foo\\ \\"bar',       ['foo \"bar']),
          ]

bad_strings = ["foo bar'",
               "'foo bar",
               "foo 'bar",
               'foo "bar',
              ]

for (s, words) in strings:
    got_split = split_quoted(s)
    if got_split == words:
        print "ok: %s -> %s" % (s, got_split)
    else:
        print "not ok: %s (expected %s, got %s)" % (s, words, got_split)

    #print "string to split: " + s
    #print "expect:", words
    #print "result:", split(s)
    #print "expect:", string.join(map(str, words), ", ")
    #print "result:", string.join(map(str, split(s)), ", ")
    #print


for s in bad_strings:
    try:
        words = split_quoted(s)
    except ValueError, msg:
        print "ok: %s raised ValueError: %s" % (s, msg)
    else:
        print "not ok: %s -> %s (expected ValueError)" % (s, words)
