# exhaustive test of the 'distutils.util.change_root()' function

import sys, os, posixpath, ntpath #, macpath
from distutils.util import change_root

def test_change_root (tests, pathmodule, sep, name):

    os.path = pathmodule
    os.sep = sep
    os.name = name
    import distutils.util               # must be a fresh import each time!

    print "testing %s paths" % name
    
    for (new_root, pathname, output) in tests:
        got_output = distutils.util.change_root(new_root, pathname)
        if got_output == output:
            print "ok: change_root(%s, %s) == %s" % \
                  (new_root, pathname, output)
        else:
            print "not ok: change_root(%s, %s) != %s (got %s)" % \
                  (new_root, pathname, output, got_output)

    del sys.modules['distutils.util']
    

def test_posix ():
    # list of new_root, pathname, expected_output tuples
    tests = [('baz', 'foo', 'baz/foo'),
             ('/baz', 'foo', '/baz/foo'),
             ('baz', '/foo', 'baz/foo'),
             ('/baz', '/foo', '/baz/foo')]
    
    test_change_root (tests, posixpath, '/', 'posix')


def test_nt ():
    tests = [# absolute new roots
             ('c:\\baz', 'c:\\foo', 'c:\\baz\\foo'),
             ('\\baz'  , 'c:\\foo', '\\baz\\foo'),
             ('c:\\baz', '\\foo',   'c:\\baz\\foo'),
             ('\\baz',   '\\foo',   '\\baz\\foo'),
             ('c:\\baz', 'c:foo',   'c:\\baz\\foo'),
             ('\\baz',   'c:foo',   '\\baz\\foo'),
             ('c:\\baz', 'foo',     'c:\\baz\\foo'),
             ('\\baz',   'foo',     '\\baz\\foo'),

             # relative new roots
             ('c:baz',   'c:\\foo', 'c:baz\\foo'),
             ('baz',     'c:\\foo', 'baz\\foo'),
             ('c:baz',   '\\foo',   'c:baz\\foo'),
             ('baz',     '\\foo',   'baz\\foo'),
             ('c:baz',   'c:foo',   'c:baz\\foo'),
             ('baz',     'c:foo',   'baz\\foo'),
             ('c:baz',   'foo',     'c:baz\\foo'),
             ('baz',     'foo',     'baz\\foo'),

             # different drive letters
             ('d:\\baz', 'c:\\foo', 'd:\\baz\\foo'),
             ('d:\\baz', 'c:foo',   'd:\\baz\\foo'),
             ('d:baz',   'c:\\foo', 'd:baz\\foo'),
             ('d:baz',   'c:foo',   'd:baz\\foo')
            ]
             
    test_change_root (tests, ntpath, '\\', 'nt')
    

test_posix()
test_nt()
